/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.impl;

import com.gemantic.dal.cache.exception.CacheException;
import com.gemantic.dal.config.helper.DaoHelper;
import com.gemantic.dal.config.model.dao.ObjectItem;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.gemantic.dal.dao.exception.StrategyException;
import com.gemantic.dal.dao.helper.LogHelper;
import com.gemantic.dal.dao.helper.MultiDBGet;
import com.gemantic.dal.dao.impl.CallDSThread;
import com.gemantic.dal.dao.impl.DBAgentHibernateImpl;
import com.gemantic.dal.dao.model.SqlInfo;
import com.gemantic.dal.dao.util.AnnotationUtil;
import com.gemantic.dal.dao.util.DalAssert;
import com.gemantic.dal.dao.util.ObjectUtil;
import com.gemantic.dal.dao.util.SqlUtil;
import com.gemantic.dal.datasource.ContextHolder;
import com.gemantic.dal.route.RoutingService;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;

public class DBDaoImpl
implements Dao {
    private Log log = LogFactory.getLog(DBDaoImpl.class);
    private Log permLog = LogFactory.getLog((String)"DalPerformance");
    private static final int singleUsedTime = 15;
    private static final int lotsUsedTime = 50;

    @Override
    public Serializable save(Object accountId, Object object) throws DaoException {
        DalAssert.assertObjectNotNull(object);
        DalAssert.assertObjectIllegal(accountId, object);
        long t1 = System.currentTimeMillis();
        Serializable id = null;
        try {
            id = DBAgentHibernateImpl.getInstance().save(accountId, object);
            if (null == id) {
                LogHelper.savedError(this.log, object);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: save region: " + object.getClass().getName() + " params: " + id + " time: " + usedTime));
        }
        return id;
    }

    @Override
    public Serializable save(Object object) throws DaoException {
        return this.save(null, object);
    }

    @Override
    public List save(Object accountId, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(accountId, objects);
        ArrayList objList = new ArrayList();
        for (Object obj : objects) {
            if (obj == null) continue;
            this.save(accountId, obj);
            objList.add(obj);
        }
        return objList;
    }

    @Override
    public List save(List objects) throws DaoException {
        return this.save(null, objects);
    }

    @Override
    public List batchSave(Object accountId, List objList) throws DaoException {
        DalAssert.assertObjectNotNull(objList);
        long t1 = System.currentTimeMillis();
        Map resMap = null;
        ArrayList resList = new ArrayList();
        try {
            Object obj;
            resMap = DBAgentHibernateImpl.getInstance().save(accountId, objList);
            for (Serializable id : resMap.keySet()) {
                Object obj2 = resMap.get(id);
                resList.add(obj2);
            }
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 50L && this.permLog.isWarnEnabled() && null != (obj = objList.get(0)) && null != obj.getClass()) {
                this.permLog.warn((Object)("method: batchSave region: " + obj.getClass().getName() + " size: " + objList.size() + " time: " + usedTime));
            }
        }
        catch (Exception e) {
            resList = new ArrayList();
            this.processException(e);
        }
        return resList;
    }

    @Override
    public List batchSave(List objList) throws DaoException {
        return this.batchSave(null, objList);
    }

    @Override
    public boolean updateObjs(List objList) throws DaoException {
        long t1 = System.currentTimeMillis();
        boolean bUpdated = true;
        bUpdated = DBAgentHibernateImpl.getInstance().updateObjs(null, objList);
        if (!bUpdated) {
            return bUpdated;
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: updateObjects region: " + usedTime));
        }
        return bUpdated;
    }

    @Override
    public boolean update(Object object) throws DaoException {
        return this.update(null, object);
    }

    @Override
    public boolean update(Object accountId, Object object) throws DaoException {
        DalAssert.assertObjectNotNull(object);
        DalAssert.assertObjectIllegal(accountId, object);
        long t1 = System.currentTimeMillis();
        boolean bUpdated = true;
        Serializable objectId = null;
        try {
            objectId = ObjectUtil.getObjectId(object);
        }
        catch (Exception e) {
            this.processException(e);
        }
        if (null == objectId) {
            LogHelper.failedGetObjectId(this.log, object);
            return bUpdated;
        }
        bUpdated = DBAgentHibernateImpl.getInstance().update(accountId, object);
        if (!bUpdated) {
            LogHelper.updateError(this.log, object);
            return bUpdated;
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: update region: " + object.getClass().getName() + " params: " + objectId + " time: " + usedTime));
        }
        return bUpdated;
    }

    @Override
    public boolean batchUpdate(Object accountId, List objects) throws DaoException {
        DalAssert.assertObjectNotNull(objects);
        DalAssert.assertListIllegal(accountId, objects);
        boolean bUpdated = true;
        try {
            for (Object obj : objects) {
                this.update(accountId, obj);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return bUpdated;
    }

    @Override
    public boolean batchUpdate(List objects) throws DaoException {
        return this.batchUpdate(null, objects);
    }

    @Override
    public boolean delete(Object accountId, Class clazz, Serializable id) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        boolean bDeleted = true;
        Object obj = null;
        obj = this.get(accountId, clazz, id);
        boolean delFlag = bDeleted = DBAgentHibernateImpl.getInstance().delete(accountId, obj);
        if (!bDeleted) {
            LogHelper.deleteError(this.log, clazz, accountId, id, false);
            return delFlag;
        }
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: realDelete region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return bDeleted;
    }

    @Override
    public boolean delete(Class clazz, Serializable id) throws DaoException {
        return this.delete(null, clazz, id);
    }

    @Override
    public boolean deleteList(Object accountId, Class clazz, List ids) throws DaoException {
        DalAssert.assertObjectNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        boolean bDeleted = true;
        try {
            for (Object id : ids) {
                this.delete(accountId, clazz, (Serializable)id);
            }
        }
        catch (Exception e) {
            bDeleted = false;
            this.processException(e);
        }
        return bDeleted;
    }

    @Override
    public boolean deleteList(Class clazz, List ids) throws DaoException {
        return this.deleteList(null, clazz, ids);
    }

    @Override
    public boolean deleteList(Object accountId, String listName, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(listName);
        DalAssert.assertObjectNotNull(params);
        boolean res = true;
        try {
            List idList = this.getIdList(accountId, listName, params, true);
            if (null != idList && idList.size() > 0) {
                String clsName = DaoHelper.getObjectNameByListName(listName);
                if (StringUtils.isBlank((String)clsName)) {
                    LogHelper.failedGetClassNameByListName(this.log, listName);
                    return true;
                }
                res = this.deleteList(accountId, Class.forName(clsName), idList);
            }
        }
        catch (Exception e) {
            this.processException(e);
        }
        return res;
    }

    @Override
    public boolean deleteList(String listName, Object[] params) throws DaoException {
        return this.deleteList((Object)null, listName, params);
    }

    @Override
    public boolean deleteList(Object accountId, String listName, Object param) throws DaoException {
        if (null == param) {
            return this.deleteList(accountId, listName, new Object[0]);
        }
        return this.deleteList(accountId, listName, new Object[]{param});
    }

    @Override
    public boolean deleteList(String listName, Object param) throws DaoException {
        return this.deleteList(null, listName, param);
    }

    @Override
    public boolean fakeDelete(Object accountId, Class clazz, Serializable id) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDelete(Class clazz, Serializable id) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDeleteList(Object accountId, Class clazz, List ids) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDeleteList(Class clazz, List ids) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDeleteList(Object accountId, String listName, Object[] params) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDeleteList(String listName, Object[] params) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDeleteList(Object accountId, String listName, Object param) throws DaoException {
        return false;
    }

    @Override
    public boolean fakeDeleteList(String listName, Object param) throws DaoException {
        return false;
    }

    @Override
    public Object get(Object accountId, Class clazz, Serializable id) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(id);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        obj = DBAgentHibernateImpl.getInstance().get(accountId, clazz, id);
        long usedTime = System.currentTimeMillis() - t1;
        if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
            this.permLog.warn((Object)("method: get region: " + clazz.getName() + " params: " + id + " time: " + usedTime));
        }
        return obj;
    }

    @Override
    public Object get(Class clazz, Serializable id) throws DaoException {
        return this.get(null, clazz, id);
    }

    @Override
    public List getIdList(Object accountId, String listName, Object param, Integer start, Integer count, boolean forward) throws DaoException {
        if (null == param) {
            return this.getIdList(accountId, listName, new Object[0], start, count, forward);
        }
        return this.getIdList(accountId, listName, new Object[]{param}, start, count, forward);
    }

    @Override
    public List getIdList(String listSqlName, Object param, Integer start, Integer count, boolean forward) throws DaoException {
        return this.getIdList(null, listSqlName, param, start, count, forward);
    }

    @Override
    public List getIdList(Object accountId, String listName, Object param, boolean forward) throws DaoException {
        if (null == param) {
            return this.getIdList(accountId, listName, new Object[0], forward);
        }
        return this.getIdList(accountId, listName, new Object[]{param}, forward);
    }

    @Override
    public List getIdList(String listName, Object param, boolean forward) throws DaoException {
        return this.getIdList(null, listName, param, forward);
    }

    @Override
    public List getIdList(Object accountId, String listName, Object[] params, Integer start, Integer count, boolean forward) throws DaoException {
        DalAssert.assertObjectNotNull(listName);
        DalAssert.assertObjectNotNull(params);
        DalAssert.assertObjectNotNull(start);
        DalAssert.assertObjectNotNull(count);
        SqlInfo sqlInfo = SqlUtil.getListSql(listName, params, forward);
        long lsType = ObjectUtil.getListType(listName).intValue();
        if (lsType == 3L) {
            return DBAgentHibernateImpl.getInstance().getOrderedCrossList(accountId, listName, sqlInfo, new Long(start.intValue()), new Long(count.intValue()), 1, forward);
        }
        return DBAgentHibernateImpl.getInstance().getObjectList(accountId, listName, sqlInfo, new Long(start.intValue()), new Long(count.intValue()), 1, true, false);
    }

    @Override
    public List getIdList(String listName, Object[] params, Integer start, Integer count, boolean forward) throws DaoException {
        return this.getIdList((Object)null, listName, params, start, count, forward);
    }

    @Override
    public List getIdList(Object accountId, String listName, Object[] params, boolean forward) throws DaoException {
        int totalCount = this.count(accountId, listName, params);
        if (totalCount <= 0) {
            return new ArrayList();
        }
        return this.getIdList(accountId, listName, params, (Integer)0, (Integer)totalCount, forward);
    }

    @Override
    public List getIdList(String listName, Object[] params, boolean forward) throws DaoException {
        return this.getIdList((Object)null, listName, params, forward);
    }

    @Override
    public List getList(Object accountId, Class clazz, List ids) throws DaoException {
        DalAssert.assertClassTypeNotNull(clazz);
        DalAssert.assertObjectNotNull(ids);
        List objList = new ArrayList();
        if (null == ids || ids.size() < 1) {
            this.log.warn((Object)" id list is empty");
            return objList;
        }
        objList = this.getObjectList(accountId, clazz, ids);
        return objList;
    }

    private List getObjectList(Object account_id, Class clazz, List ids) throws DaoException {
        List objList = new ArrayList();
        ObjectItem objItem = DaoHelper.getObjectItemByObjectName(clazz.getName());
        String baseSql = objItem.getEntitySql();
        if (null == baseSql || StringUtils.isBlank((String)baseSql)) {
            return objList;
        }
        List<SqlInfo> sqlInfoLs = SqlUtil.getEntityUnionSql(ids, baseSql);
        if (null == sqlInfoLs) {
            return objList;
        }
        try {
            objList = MultiDBGet.get(account_id, clazz, sqlInfoLs);
        }
        catch (CacheException e) {
            e.printStackTrace(System.out);
            e.printStackTrace(System.err);
        }
        for (SqlInfo sqlInfo : sqlInfoLs) {
            List entityLs = DBAgentHibernateImpl.getInstance().getEntityList(account_id, clazz, sqlInfo, 1);
            objList.addAll(entityLs);
        }
        return objList;
    }

    @Override
    public List getList(Class clazz, List ids) throws DaoException {
        return this.getList(null, clazz, ids);
    }

    @Override
    public List getListWithNULLOBJ(Object account_id, Class clazz, List ids) throws DaoException {
        return this.getList(account_id, clazz, ids);
    }

    @Override
    public List getListWithNULLOBJ(Class clazz, List ids) throws DaoException {
        return this.getListWithNULLOBJ(null, clazz, ids);
    }

    @Override
    public List getMapList(List accountIdList, String mapname, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(accountIdList);
        DalAssert.assertObjectNotNull(mapname);
        DalAssert.assertObjectNotNull(paramsList);
        ArrayList resList = new ArrayList();
        try {
            HashMap dbParamsMap = new HashMap();
            HashMap dbAccountMap = new HashMap();
            for (int index = 0; index < accountIdList.size(); ++index) {
                Object[] params;
                Object accountId = accountIdList.get(index);
                RoutingService.getInstance().setRoutingStrategyForMap(mapname, accountId, 1);
                String dbName = ContextHolder.getDataSource();
                if (null == dbAccountMap.get(dbName)) {
                    params = paramsList.get(index);
                    if (null == params) continue;
                    dbAccountMap.put(dbName, accountId);
                    ArrayList<Object[]> newParamList = new ArrayList<Object[]>();
                    newParamList.add(params);
                    dbParamsMap.put(dbName, newParamList);
                    continue;
                }
                params = paramsList.get(index);
                if (null == params) continue;
                ((List)dbParamsMap.get(dbName)).add(params);
            }
            for (String dbName : dbAccountMap.keySet()) {
                List bufList = new ArrayList();
                List<SqlInfo> sqlInfoLs = SqlUtil.getMapAggreSqlInfos(mapname, (List)dbParamsMap.get(dbName));
                RoutingService.getInstance().setRoutingStrategyForMap(mapname, dbAccountMap.get(dbName), 1);
                for (SqlInfo sqlInfo : sqlInfoLs) {
                    bufList = DBAgentHibernateImpl.getInstance().getObjectList(null, null, sqlInfo, 0L, 0L, 1, false, true);
                    resList.addAll(bufList);
                }
            }
        }
        catch (StrategyException e) {
            this.processException(e);
        }
        return resList;
    }

    @Override
    public Object getMapping(Object accountId, String mappingName, Object[] keys) throws DaoException {
        return this.getRealMapping(accountId, mappingName, keys, false);
    }

    public Object getRealMapping(Object account_id, String mappingName, Object[] params, boolean bExtend) throws DaoException {
        DalAssert.assertObjectNotNull(mappingName);
        DalAssert.assertObjectNotNull(params);
        long t1 = System.currentTimeMillis();
        Object obj = null;
        try {
            SqlInfo sqlInfo = SqlUtil.getMappingSqlInfo(mappingName, params, bExtend);
            LogHelper.usingMappingWithDB(this.log);
            RoutingService.getInstance().setRoutingStrategyForMap(mappingName, account_id, 1);
            List objList = DBAgentHibernateImpl.getInstance().getObjectList(account_id, mappingName, sqlInfo, 0L, 0L, 1, false, false);
            if (null == objList || objList.size() < 1) {
                LogHelper.failedExecuteQueryFromDB(this.log, sqlInfo);
                return null;
            }
            long usedTime = System.currentTimeMillis() - t1;
            if (usedTime >= 15L && this.permLog.isWarnEnabled()) {
                this.permLog.warn((Object)("method: getRealMapping region: " + mappingName + " size: " + params.length + " time: " + usedTime));
            }
            return objList.get(0);
        }
        catch (StrategyException e) {
            e.printStackTrace(System.out);
            this.processException(e);
            return obj;
        }
    }

    @Override
    public Object getMapping(String mappingName, Object[] keys) throws DaoException {
        return this.getMapping((Object)null, mappingName, keys);
    }

    @Override
    public Object getMapping(Object accountId, String mappingName, Object key) throws DaoException {
        if (null == key) {
            return this.getMapping(accountId, mappingName, new Object[0]);
        }
        return this.getMapping(accountId, mappingName, new Object[]{key});
    }

    @Override
    public Object getMapping(String mappingName, Object key) throws DaoException {
        return this.getMapping(null, mappingName, key);
    }

    @Override
    public List getMappings(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        DalAssert.assertObjectNotNull(accountId);
        DalAssert.assertObjectNotNull(mapName);
        DalAssert.assertObjectNotNull(paramsList);
        long t1 = System.currentTimeMillis();
        try {
            return DBAgentHibernateImpl.getInstance().getMaps(accountId, mapName, paramsList);
        }
        catch (StrategyException e) {
            this.processException(e);
            return null;
        }
    }

    @Override
    public Map getMappingsMap(Object accountId, String mapName, List<Object[]> paramsList) throws DaoException {
        HashMap resultMap = new HashMap();
        List resultList = this.getMappings(accountId, mapName, paramsList);
        if (CollectionUtils.isNotEmpty(paramsList) && CollectionUtils.isNotEmpty((Collection)resultList)) {
            int size = paramsList.size();
            for (int i = 0; i < size; ++i) {
                Object[] objects = paramsList.get(i);
                Object obj = resultList.get(i);
                resultMap.put(objects, obj);
            }
        }
        return resultMap;
    }

    private void processException(Exception e) throws DaoException {
        e.printStackTrace(System.out);
        if (e instanceof MappingException) {
            throw new DaoException(401, e);
        }
        if (e instanceof NullPointerException) {
            throw new DaoException(303, e);
        }
        if (e instanceof SQLException) {
            throw new DaoException(500, e);
        }
        if (e instanceof HibernateException) {
            throw new DaoException(400, e);
        }
        if (e instanceof StrategyException) {
            throw new DaoException(306, e);
        }
        if (e instanceof DaoException) {
            throw (DaoException)e;
        }
        throw new DaoException(e);
    }

    @Override
    public int count(Object accountId, String listName, Object param) throws DaoException {
        if (null == param) {
            return this.count(accountId, listName, new Object[0]);
        }
        return this.count(accountId, listName, new Object[]{param});
    }

    @Override
    public int count(String listName, Object param) throws DaoException {
        return this.count(null, listName, param);
    }

    @Override
    public int count(Object accountId, String listName, Object[] params) throws DaoException {
        DalAssert.assertObjectNotNull(listName);
        DalAssert.assertObjectNotNull(params);
        Long count = 0L;
        SqlInfo sqlInfo = SqlUtil.getListCountSql(listName, params);
        int lsType = ObjectUtil.getListType(listName);
        if (lsType == 3) {
            List<List> list = DBAgentHibernateImpl.getInstance().crossDBList(accountId, listName, sqlInfo, 0, 1, 1);
            if (null != list) {
                for (List ls : list) {
                    count = count + (long)((Number)ls.get(0)).intValue();
                }
            }
            return count.intValue();
        }
        List list = DBAgentHibernateImpl.getInstance().getObjectList(accountId, listName, sqlInfo, 0L, 1L, 1, true, true);
        return ((Number)list.get(0)).intValue();
    }

    @Override
    public int count(String listName, Object[] params) throws DaoException {
        return this.count((Object)null, listName, params);
    }

    @Override
    public Long getMaxIdOfClass(Class clazz) throws DaoException {
        try {
            this.log.info((Object)"enter into method getMaxIdOfClass ");
            String id = AnnotationUtil.getIdClumnFromEntity(clazz);
            if (StringUtils.isBlank((String)id)) {
                this.log.error((Object)("can't find the id clomun for entity " + clazz.getName()));
                return 0L;
            }
            String tableName = AnnotationUtil.getTableNameFromEntity(clazz);
            if (StringUtils.isBlank((String)tableName)) {
                this.log.error((Object)("can't find the tableName for entity " + clazz.getName()));
                return 0L;
            }
            String sql = "select max(" + id + ") from " + tableName;
            List<Long> idList = Collections.synchronizedList(new ArrayList());
            List<String> dsNames = RoutingService.getInstance().getReadDsFromEachGroupForObject(clazz);
            if (CollectionUtils.isEmpty(dsNames)) {
                this.log.error((Object)("can't find any db for the entity " + clazz.getName()));
                return 0L;
            }
            for (String dsName : dsNames) {
                CallDSThread thread = new CallDSThread(dsName, idList, sql);
                if (null == thread) continue;
                thread.start();
            }
            while (idList.size() != dsNames.size()) {
                Thread.sleep(1L);
            }
            if (CollectionUtils.isEmpty(idList)) {
                this.log.error((Object)" find no id, no data in the db or something wrong happened ");
                return 0L;
            }
            Collections.sort(idList);
            this.log.info((Object)"get out of method getMaxIdOfClass ");
            return idList.get(idList.size() - 1);
        }
        catch (Exception e) {
            this.log.error((Object)("getMaxIdOfClass fail: " + e.getMessage()));
            this.processException(e);
            return 0L;
        }
    }

    @Override
    public Object excuteSimpleSql(String sql, Class clazz) throws DaoException {
        this.log.info((Object)("enter into method excuteSimpleSql, param is " + sql));
        return DBAgentHibernateImpl.getInstance().excuteSimpleSql(sql, clazz);
    }
}

