/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.cachehandler.impl;

import com.gemantic.dal.dao.cachehandler.ListHandler;
import com.gemantic.dal.dao.cachehandler.impl.AbstractListHandler;
import com.gemantic.dal.dao.helper.ListInfoHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.model.SectionInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.ObjectUtil;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrossListHandler
extends AbstractListHandler
implements ListHandler {
    private static Log log = LogFactory.getLog(CrossListHandler.class);

    @Override
    public void processSave(Object account_id, Object obj, List<SectionInfo> saveInfos) throws Exception {
        for (SectionInfo sectionInfo : saveInfos) {
            Number[] nums;
            LsCacheInfoHelper lsHelper = sectionInfo.getLsHelper();
            List idList = sectionInfo.getIdList();
            Number orderByProperty = (Number)ObjectUtil.getObjectStrategyPropert(obj);
            if (null != orderByProperty) {
                Object[] latestId = (Object[])sectionInfo.getLatestId();
                if (null == latestId) {
                    CacheHelper.remove(lsHelper.getRegion(), lsHelper.getKey());
                    continue;
                }
                Number maxValue = (Number)latestId[latestId.length - 1];
                if (orderByProperty.longValue() < maxValue.longValue()) {
                    CacheHelper.remove(lsHelper.getRegion(), lsHelper.getKey());
                    continue;
                }
            }
            ListInfoHelper infoHelper = sectionInfo.getInfoHelper();
            if (0 == idList.size()) {
                nums = new Number[]{orderByProperty, orderByProperty};
            } else {
                nums = infoHelper.getMinMaxOfCross(sectionInfo.getSectionNo());
                nums[1] = orderByProperty;
            }
            infoHelper.addMinMaxInfo(sectionInfo.getSectionNo(), nums[0], nums[1]);
            infoHelper.addSectionInfo(sectionInfo.getSectionNo(), (long)idList.size() + 1L);
            infoHelper.increaseSize();
        }
    }
}

