/*
 * Decompiled with CFR 0.152.
 */
package com.gemantic.dal.dao.cachehandler.impl;

import com.gemantic.dal.cache.Cache;
import com.gemantic.dal.dao.ListLoaderCenter;
import com.gemantic.dal.dao.cachehandler.ListHandler;
import com.gemantic.dal.dao.cachehandler.impl.AbstractListHandler;
import com.gemantic.dal.dao.helper.ListInfoHelper;
import com.gemantic.dal.dao.helper.LsCacheInfoHelper;
import com.gemantic.dal.dao.model.SectionInfo;
import com.gemantic.dal.dao.model.UpdateInfo;
import com.gemantic.dal.dao.util.CacheHelper;
import com.gemantic.dal.dao.util.ObjectUtil;
import com.gemantic.dal.route.RoutingService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonListHandler
extends AbstractListHandler
implements ListHandler {
    private static Log log = LogFactory.getLog(CommonListHandler.class);

    @Override
    public void processSave(Object account_id, Object obj, List<SectionInfo> saveInfos) throws Exception {
        boolean bRAndW = RoutingService.getInstance().isReadWrite(obj.getClass(), account_id);
        if (bRAndW) {
            for (SectionInfo sectionInfo : saveInfos) {
                LsCacheInfoHelper lsHelper = sectionInfo.getLsHelper();
                ListInfoHelper infoHelper = sectionInfo.getInfoHelper();
                List idList = sectionInfo.getIdList();
                CacheHelper.increaseListSize(lsHelper);
                infoHelper.addSectionInfo(sectionInfo.getSectionNo(), (long)idList.size() + 1L);
                CacheHelper.put(lsHelper.getRegion(), lsHelper.getListVisitInfoKey(), infoHelper.getVisitedSections());
                Object objValueOfLs = ObjectUtil.getObjectValueOfList(obj, lsHelper);
                idList.add(objValueOfLs);
                CacheHelper.put(lsHelper.getRegion(), lsHelper.getIdListKey(sectionInfo.getSectionNo()), idList);
            }
        } else {
            for (SectionInfo sectionInfo : saveInfos) {
                LsCacheInfoHelper lsHelper = sectionInfo.getLsHelper();
                ListInfoHelper infoHelper = sectionInfo.getInfoHelper();
                CacheHelper.increaseListSize(lsHelper, infoHelper);
            }
        }
    }

    @Override
    public UpdateInfo getUpdateInfos(Object account_id, Object obj, Object oldObj, Map<String, LsCacheInfoHelper> newObjLsMap, Map<String, LsCacheInfoHelper> oldObjLsMap) throws Exception {
        boolean bRAndW = RoutingService.getInstance().isReadWrite(obj.getClass(), account_id);
        if (bRAndW) {
            ArrayList<SectionInfo> oldSectionInfos = new ArrayList<SectionInfo>();
            HashMap<String, LsCacheInfoHelper> newChangedLsMsp = new HashMap<String, LsCacheInfoHelper>();
            for (String region : oldObjLsMap.keySet()) {
                String newKey;
                LsCacheInfoHelper oldLsHelper = oldObjLsMap.get(region);
                LsCacheInfoHelper newLsHelper = newObjLsMap.get(region);
                String oldKey = oldLsHelper.getKey();
                if (oldKey.equalsIgnoreCase(newKey = newLsHelper.getKey())) {
                    Object newValueOfLs;
                    Object oldValueOfLs = ObjectUtil.getObjectValueOfList(oldObj, oldLsHelper);
                    if (!oldValueOfLs.equals(newValueOfLs = ObjectUtil.getObjectValueOfList(obj, newLsHelper))) {
                        newChangedLsMsp.put(region, newLsHelper);
                        continue;
                    }
                    String oldOrderByKey = oldLsHelper.getOrderByKey();
                    String newOrderByKey = newLsHelper.getOrderByKey();
                    if (null == oldOrderByKey || oldOrderByKey.length() <= 0 || oldOrderByKey.equalsIgnoreCase(newOrderByKey)) continue;
                    newChangedLsMsp.put(region, newLsHelper);
                    continue;
                }
                Cache cache = CacheHelper.getListCache(region);
                if (null == cache) continue;
                ListInfoHelper oldInfoHelper = ListLoaderCenter.getInstance().getListInfo(account_id, oldLsHelper, 2, false);
                if (null != oldInfoHelper && oldInfoHelper.getSize() > 0L) {
                    SectionInfo delSec;
                    if (oldInfoHelper.isSectionsReBuild()) {
                        oldInfoHelper.getListInfo().setSections(null);
                    }
                    if (null != (delSec = ListLoaderCenter.getInstance().getUpdatedSection(account_id, oldObj, oldLsHelper))) {
                        oldSectionInfos.add(delSec);
                    }
                }
                newChangedLsMsp.put(region, newLsHelper);
            }
            return new UpdateInfo(null, oldSectionInfos, newChangedLsMsp);
        }
        return super.getUpdateInfos(account_id, obj, oldObj, newObjLsMap, oldObjLsMap);
    }

    @Override
    public void processUpdate(Object account_id, Class clazz, Object oldObj, Object obj, UpdateInfo updateInfo) throws Exception {
        boolean bRW = RoutingService.getInstance().isReadWrite(clazz, account_id);
        if (bRW) {
            if (null != updateInfo) {
                if (null != updateInfo.getOldObjListSections()) {
                    for (SectionInfo secInfo : updateInfo.getOldObjListSections()) {
                        ListLoaderCenter.getInstance().removeIdFromList(account_id, oldObj, secInfo, bRW);
                    }
                }
                if (null != updateInfo.getNewLsMap() && updateInfo.getNewLsMap().size() > 0) {
                    for (String region : updateInfo.getNewLsMap().keySet()) {
                        LsCacheInfoHelper lsHelper = updateInfo.getNewLsMap().get(region);
                        CacheHelper.removeListInfo(lsHelper);
                        ListLoaderCenter.getInstance().getUpdatedSection(account_id, obj, lsHelper);
                    }
                }
            }
        } else {
            super.processUpdate(null, null, null, null, updateInfo);
        }
    }
}

