/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.imp;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.CoordinatorLogEntry;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.LogWriteException;
import com.atomikos.recovery.Repository;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.imp.InMemoryRepository;
import java.util.Collection;
import java.util.HashSet;

public class CachedRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.createLogger(CachedRepository.class);
    private boolean corrupt = false;
    private final InMemoryRepository inMemoryCoordinatorLogEntryRepository;
    private final Repository backupCoordinatorLogEntryRepository;
    private volatile long numberOfPutsSinceLastCheckpoint = 0L;
    private long checkpointInterval;
    private long forgetOrphanedLogEntriesDelay;

    public CachedRepository(InMemoryRepository inMemoryCoordinatorLogEntryRepository, Repository backupCoordinatorLogEntryRepository) {
        this.inMemoryCoordinatorLogEntryRepository = inMemoryCoordinatorLogEntryRepository;
        this.backupCoordinatorLogEntryRepository = backupCoordinatorLogEntryRepository;
    }

    public void init() {
        ConfigProperties configProperties = Configuration.getConfigProperties();
        try {
            Collection coordinatorLogEntries = this.backupCoordinatorLogEntryRepository.getAllCoordinatorLogEntries();
            for (CoordinatorLogEntry coordinatorLogEntry : coordinatorLogEntries) {
                this.inMemoryCoordinatorLogEntryRepository.put(coordinatorLogEntry.id, coordinatorLogEntry);
            }
            this.performCheckpoint();
        }
        catch (LogException e) {
            LOGGER.logFatal("Corrupted log file - restart JVM", (Throwable)e);
            this.corrupt = true;
        }
        this.checkpointInterval = configProperties.getCheckpointInterval();
        this.forgetOrphanedLogEntriesDelay = configProperties.getForgetOrphanedLogEntriesDelay();
    }

    public void put(String id, CoordinatorLogEntry coordinatorLogEntry) throws IllegalArgumentException, LogWriteException {
        try {
            if (this.needsCheckpoint()) {
                this.performCheckpoint();
            }
            this.backupCoordinatorLogEntryRepository.put(id, coordinatorLogEntry);
            this.inMemoryCoordinatorLogEntryRepository.put(id, coordinatorLogEntry);
            ++this.numberOfPutsSinceLastCheckpoint;
        }
        catch (Exception e) {
            this.performCheckpoint();
        }
    }

    private synchronized void performCheckpoint() throws LogWriteException {
        try {
            Collection<CoordinatorLogEntry> coordinatorLogEntries = this.purgeExpiredCoordinatorLogEntriesInStateAborting();
            this.backupCoordinatorLogEntryRepository.writeCheckpoint(coordinatorLogEntries);
            this.inMemoryCoordinatorLogEntryRepository.writeCheckpoint(coordinatorLogEntries);
            this.numberOfPutsSinceLastCheckpoint = 0L;
        }
        catch (LogWriteException corrupted) {
            LOGGER.logFatal("Corrupted log file - restart JVM", (Throwable)corrupted);
            this.corrupt = true;
            throw corrupted;
        }
        catch (Exception corrupted) {
            LOGGER.logFatal("Corrupted log file - restart JVM", (Throwable)corrupted);
            this.corrupt = true;
            throw new LogWriteException((Throwable)corrupted);
        }
    }

    private Collection<CoordinatorLogEntry> purgeExpiredCoordinatorLogEntriesInStateAborting() {
        HashSet<CoordinatorLogEntry> ret = new HashSet<CoordinatorLogEntry>();
        long now = System.currentTimeMillis();
        Collection<CoordinatorLogEntry> coordinatorLogEntries = this.inMemoryCoordinatorLogEntryRepository.getAllCoordinatorLogEntries();
        for (CoordinatorLogEntry coordinatorLogEntry : coordinatorLogEntries) {
            if (this.canBeForgotten(now, coordinatorLogEntry)) continue;
            ret.add(coordinatorLogEntry);
        }
        return ret;
    }

    protected boolean canBeForgotten(long now, CoordinatorLogEntry coordinatorLogEntry) {
        TxState entryState;
        boolean ret = false;
        if (coordinatorLogEntry.expires() + this.forgetOrphanedLogEntriesDelay < now && !(entryState = coordinatorLogEntry.getResultingState()).isHeuristic()) {
            LOGGER.logWarning("Purging orphaned entry from log: " + coordinatorLogEntry);
            ret = true;
        }
        return ret;
    }

    private boolean needsCheckpoint() {
        return this.numberOfPutsSinceLastCheckpoint >= this.checkpointInterval;
    }

    public CoordinatorLogEntry get(String coordinatorId) throws LogReadException {
        this.assertNotCorrupted();
        return this.inMemoryCoordinatorLogEntryRepository.get(coordinatorId);
    }

    protected void assertNotCorrupted() throws LogReadException {
        if (this.corrupt) {
            throw new LogReadException("Log corrupted - restart JVM");
        }
    }

    public Collection<CoordinatorLogEntry> findAllCommittingCoordinatorLogEntries() throws LogReadException {
        this.assertNotCorrupted();
        return this.inMemoryCoordinatorLogEntryRepository.findAllCommittingCoordinatorLogEntries();
    }

    public void close() {
        this.backupCoordinatorLogEntryRepository.close();
        this.inMemoryCoordinatorLogEntryRepository.close();
    }

    public Collection<CoordinatorLogEntry> getAllCoordinatorLogEntries() {
        return this.inMemoryCoordinatorLogEntryRepository.getAllCoordinatorLogEntries();
    }

    public void writeCheckpoint(Collection<CoordinatorLogEntry> checkpointContent) {
        throw new UnsupportedOperationException();
    }
}

