/*
 * Decompiled with CFR 0.152.
 */
package cn.mineki.Utils;

import java.util.Locale;

public class LangUtils {
    private static final String a = Locale.JAPANESE.getLanguage().toLowerCase();
    private static final String b = Locale.KOREAN.getLanguage().toLowerCase();
    private static final String c = Locale.CHINESE.getLanguage().toLowerCase();

    public static boolean isChinese(String string) {
        int n = LangUtils.guessFullNameStyle(string);
        if (n == 2) {
            n = LangUtils.getAdjustedFullNameStyle(n);
        }
        return n == 3;
    }

    public static boolean isJapanese(String string) {
        int n = LangUtils.guessFullNameStyle(string);
        if (n == 2) {
            n = LangUtils.getAdjustedFullNameStyle(n);
        }
        return n == 4;
    }

    public static boolean isKorean(String string) {
        int n = LangUtils.guessFullNameStyle(string);
        if (n == 2) {
            n = LangUtils.getAdjustedFullNameStyle(n);
        }
        return n == 5;
    }

    public static int guessFullNameStyle(String string) {
        int n;
        if (string == null) {
            return 0;
        }
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; i += Character.charCount(n)) {
            n = Character.codePointAt(string, i);
            if (!Character.isLetter(n)) continue;
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n);
            if (!LangUtils.a(unicodeBlock)) {
                if (LangUtils.b(unicodeBlock)) {
                    return LangUtils.a(string, i + Character.charCount(n));
                }
                if (LangUtils.d(unicodeBlock)) {
                    return 4;
                }
                if (LangUtils.c(unicodeBlock)) {
                    return 5;
                }
            }
            n2 = 1;
        }
        return n2;
    }

    public static int getAdjustedFullNameStyle(int n) {
        String string = Locale.getDefault().getLanguage().toLowerCase();
        if (n == 0) {
            if (a.equals(string)) {
                return 4;
            }
            if (b.equals(string)) {
                return 5;
            }
            if (c.equals(string)) {
                return 3;
            }
            return 1;
        }
        if (n == 2) {
            if (a.equals(string)) {
                return 4;
            }
            if (b.equals(string)) {
                return 5;
            }
            return 3;
        }
        return n;
    }

    private static boolean a(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.BASIC_LATIN || unicodeBlock == Character.UnicodeBlock.LATIN_1_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL;
    }

    private static boolean b(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT;
    }

    private static boolean c(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO;
    }

    private static boolean d(Character.UnicodeBlock unicodeBlock) {
        return unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || unicodeBlock == Character.UnicodeBlock.HIRAGANA;
    }

    private static int a(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            int n3 = Character.codePointAt(string, n);
            if (Character.isLetter(n3)) {
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(n3);
                if (LangUtils.d(unicodeBlock)) {
                    return 4;
                }
                if (LangUtils.c(unicodeBlock)) {
                    return 5;
                }
            }
            n += Character.charCount(n3);
        }
        return 2;
    }

    public static interface FullNameStyle {
        public static final int UNDEFINED = 0;
        public static final int WESTERN = 1;
        public static final int CJK = 2;
        public static final int CHINESE = 3;
        public static final int JAPANESE = 4;
        public static final int KOREAN = 5;
    }
}

