/*
 * Decompiled with CFR 0.152.
 */
package cn.mineki.Utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DataUtils {
    public static byte[] hexStringToBytes(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i = 0; i < n; ++i) {
            int n2 = i * 2;
            byArray[i] = (byte)(DataUtils.toByte(cArray[n2]) << 4 | DataUtils.toByte(cArray[n2 + 1]));
        }
        return byArray;
    }

    public static int toByte(char c2) {
        byte by = (byte)"0123456789ABCDEF".indexOf(c2);
        return by;
    }

    public static String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(DataUtils.toHexString1(byArray[i]));
        }
        return stringBuffer.toString();
    }

    public static String toHexString1(byte by) {
        String string = Integer.toHexString(by & 0xFF);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    public static String hexStr2Str(String string) {
        String string2 = "0123456789ABCDEF";
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = string2.indexOf(cArray[2 * i]) * 16;
            byArray[i] = (byte)((n += string2.indexOf(cArray[2 * i + 1])) & 0xFF);
        }
        return new String(byArray);
    }

    public static String str2Hexstr(String string) {
        char[] cArray = "0123456789ABCDEF".toCharArray();
        StringBuilder stringBuilder = new StringBuilder("");
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xF0) >> 4;
            stringBuilder.append(cArray[n]);
            n = byArray[i] & 0xF;
            stringBuilder.append(cArray[n]);
        }
        return stringBuilder.toString();
    }

    public static String byte2Hexstr(byte by) {
        String string = Integer.toHexString(0xFF & by);
        if (string.length() < 2) {
            string = "0" + string;
        }
        string = string.toUpperCase();
        return string;
    }

    public static String str2Hexstr(String string, int n) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        byArray2[n - 1] = (byte)byArray.length;
        String string2 = DataUtils.bytesToHexString(byArray2);
        return string2;
    }

    public static String[] hexStr2StrArray(String string) {
        int n = 32;
        int n2 = string.length() % n == 0 ? string.length() / n : string.length() / n + 1;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            if (i == n2 - 1) {
                String string2 = string.substring(i * n);
                for (int j = 0; j < n - string2.length(); ++j) {
                    string2 = string2 + "0";
                }
                stringArray[i] = string2;
                continue;
            }
            stringArray[i] = string.substring(i * n, (i + 1) * n);
        }
        return stringArray;
    }

    public static byte[] compress(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray);
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] uncompress(byte[] byArray) {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[256];
        while ((n = gZIPInputStream.read(byArray2)) >= 0) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] short2byte(short s) {
        byte[] byArray = new byte[2];
        byArray[0] = (byte)(s >>> 8);
        short s2 = (short)(s << 8);
        byArray[1] = (byte)(s2 >>> 8);
        return byArray;
    }

    public static short[] hexStr2short(String string) {
        byte[] byArray = DataUtils.hexStringToBytes(string);
        short[] sArray = new short[4];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = DataUtils.getShort(byArray[i * 2], byArray[i * 2 + 1]);
        }
        return sArray;
    }

    public static short getShort(byte by, byte by2) {
        short s = 0;
        s = (short)(s | by & 0xFF);
        s = (short)(s << 8);
        s = (short)(s | by2 & 0xFF);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String bitmapToBase64(Bitmap bitmap) {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            if (bitmap != null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
                byteArrayOutputStream.flush();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                string = Base64.encodeToString((byte[])byArray, (int)0);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return string;
    }

    public static Bitmap base64ToBitmap(String string) {
        byte[] byArray = Base64.decode((String)string, (int)0);
        return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
    }

    public static byte[] getBytesFromString(String string, String string2) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return byArray;
    }

    public static String setBytesToString(byte[] byArray, String string) {
        String string2 = "";
        try {
            string2 = new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String UTF8ToGBK(String string) {
        byte[] byArray = null;
        byArray = DataUtils.getBytesFromString(string, "gbk");
        String string2 = DataUtils.setBytesToString(byArray, "gbk");
        return string2;
    }

    public static String GBKToUTF8(String string) {
        String string2 = "";
        byte[] byArray = null;
        byArray = DataUtils.getBytesFromString(string, "utf-8");
        string2 = DataUtils.setBytesToString(byArray, "utf-8");
        return string2;
    }

    public static void printBytes(byte[] byArray) {
        int n = byArray.length;
        System.out.print(String.format("length: %d, bytes: ", n));
        for (int i = 0; i < n; ++i) {
            System.out.print(String.format("%02X ", byArray[i]));
        }
        System.out.println("");
    }

    public static void printBytes(byte[] byArray, int n) {
        System.out.print(String.format("length: %d, bytes: ", n));
        for (int i = 0; i < n; ++i) {
            System.out.print(String.format("%02X ", byArray[i]));
        }
        System.out.println("");
    }
}

