/*
 * Decompiled with CFR 0.152.
 */
package cn.mineki.CardReaders;

import android.content.Context;
import android.graphics.Bitmap;
import cn.mineki.CardReaders.CardType;
import cn.mineki.CardReaders.Common;
import cn.mineki.CardReaders.FPRCardInfo;
import cn.mineki.CardReaders.GATCardInfo;
import cn.mineki.CardReaders.IDCardInfo;
import cn.mineki.CardReaders.IDCardReader;
import cn.mineki.CardReaders.IUsbReaderCallback;
import cn.mineki.CardReaders.Sdtapi;
import cn.mineki.Utils.DataUtils;
import cn.mineki.Utils.LangUtils;
import cn.mineki.Utils.Logs;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class MKR200UReader
extends IDCardReader {
    private byte[] a = new byte[2320];
    private final String b = "32250000";
    private final String c = "32240000";
    private final String d = "32410000";
    private final String e = "3251";
    private final String f = "3229FF";
    private final String g = "3226FF";
    private final String h = "3113030101";
    private Common i = null;
    private Sdtapi j = null;
    private Context k = null;
    private static byte[] l = new byte[1024];
    private static byte[] m = new byte[1024];
    private static byte[] n = new byte[256];
    private boolean o = false;
    private static MKR200UReader p;
    private IUsbReaderCallback q = null;
    private static String r;

    public static String getVersion() {
        return r;
    }

    public static MKR200UReader getInstance(Context context) {
        if (p == null) {
            p = new MKR200UReader(context);
        }
        return p;
    }

    public MKR200UReader(Context context) {
        super(context);
        this.isOpen = false;
        this.k = context;
        this.CODE = 3;
        this.TAG = "MKR200UReader";
        this.i = new Common();
    }

    @Override
    public String ReadSAMID(String[] stringArray) {
        String string = "";
        char[] cArray = new char[36];
        try {
            int n = this.j.SDT_GetSAMIDToStr(cArray);
            if (n == 144) {
                string = String.valueOf(cArray);
            }
        }
        catch (Exception exception) {
            Logs.e(this.TAG, exception);
        }
        return string;
    }

    public boolean GetAct() {
        byte[] byArray = null;
        this.o = true;
        this.sKey = this.getAct(byArray, this.byLicData, this.CODE);
        Logs.d(this.TAG, "GetAct Begin key=" + this.sKey);
        if (this.sKey.length() < 16) {
            this.o = false;
            this.byLicData = null;
        }
        Logs.d(this.TAG, "GetAct end.");
        return this.o;
    }

    public boolean InitReader(byte[] byArray, IUsbReaderCallback iUsbReaderCallback) {
        if (this.isOpen) {
            return true;
        }
        Logs.d(this.TAG, "InitReader begin.");
        try {
            this.j = new Sdtapi(this.k, iUsbReaderCallback);
        }
        catch (Exception exception) {
            if (exception.getCause() == null) {
                return false;
            }
            return false;
        }
        Logs.d(this.TAG, "InitReader end.");
        this.byLicData = byArray;
        this.isOpen = true;
        return true;
    }

    @Override
    public void ReleaseReader() {
        this.o = false;
        this.isOpen = false;
        if (this.j != null) {
            this.j.destroy();
            this.j = null;
        }
    }

    @Override
    public IDCardInfo ReadBaseCardInfo(String[] stringArray) {
        if (!this.isOpen) {
            return null;
        }
        if (this.j.SDT_StartFindIDCard() != this.i.FINDCARD || this.j.SDT_SelectIDCard() != this.i.SELECTCARD) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = this.j.SDT_ReadBaseMsg(MKR200UReader.n, nArray, l, nArray2);
        if (n == this.i.SUCCESS) {
            try {
                return this.a(MKR200UReader.n, l, null, this.o);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IDCardInfo ReadAllCardInfo(String[] stringArray) {
        IDCardInfo iDCardInfo = null;
        if (!this.isOpen) {
            return null;
        }
        if (this.j.SDT_StartFindIDCard() != this.i.FINDCARD || this.j.SDT_SelectIDCard() != this.i.SELECTCARD) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        byte[] byArray = new byte[70];
        int n = this.j.SDT_ReadBaseFPMsg(MKR200UReader.n, nArray, l, nArray2, m, nArray3);
        if (n == this.i.SUCCESS && (iDCardInfo = nArray3[0] > 0 ? this.a(MKR200UReader.n, l, m, this.o) : this.a(MKR200UReader.n, l, null, this.o)) == null) {
            return null;
        }
        String string = "";
        if (this.j.SDT_GetNewAddress(byArray) == this.i.SUCCESS) {
            try {
                string = new String(byArray, 0, 70, "UTF-16LE").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (iDCardInfo != null) {
            iDCardInfo.setNewAddress(string);
        }
        return iDCardInfo;
    }

    private IDCardInfo a(byte[] byArray, byte[] byArray2, byte[] byArray3, boolean bl) {
        IDCardInfo iDCardInfo = null;
        FPRCardInfo fPRCardInfo = null;
        GATCardInfo gATCardInfo = null;
        String string = null;
        boolean bl2 = false;
        try {
            String string2;
            string = new String(byArray, 248, 2, "UTF-16LE").trim();
            if (string.equals("I")) {
                iDCardInfo = new FPRCardInfo();
                iDCardInfo.setCardType(CardType.FPRCard);
                iDCardInfo.setCardTypeCode(string);
                iDCardInfo.setCardTypeName("\u5916\u56fd\u4eba\u6c38\u4e45\u5c45\u7559\u8bc1");
                fPRCardInfo = (FPRCardInfo)iDCardInfo;
                string = new String(n, 0, 120, "UTF-16LE").trim();
                fPRCardInfo.setFPR_ENName(string);
                string = new String(n, 120, 2, "UTF-16LE").trim();
                fPRCardInfo.setFPR_SexCode(string);
                string = new String(n, 122, 30, "UTF-16LE").trim();
                fPRCardInfo.setFPR_IDNo(string);
                string = new String(n, 152, 6, "UTF-16LE").trim();
                fPRCardInfo.setFPR_NationCode(string);
                fPRCardInfo.setFPR_Nation(this.parseCountry(string));
                string = new String(n, 158, 30, "UTF-16LE").trim();
                fPRCardInfo.setFPR_CHNName(string);
                string = new String(n, 188, 16, "UTF-16LE").trim();
                fPRCardInfo.setFPR_ValidStartDate(string);
                string = new String(n, 204, 16, "UTF-16LE").trim();
                fPRCardInfo.setFPR_ValidEndDate(string);
                string = new String(n, 220, 16, "UTF-16LE").trim();
                fPRCardInfo.setFPR_Birthday(string);
                string = new String(n, 236, 4, "UTF-16LE").trim();
                fPRCardInfo.setFPR_IDVersion(string);
                string = new String(n, 240, 8, "UTF-16LE").trim();
                fPRCardInfo.setFPR_IssuingAuthorityCode(string);
                if (fPRCardInfo.getFPR_SexCode().equals("1")) {
                    iDCardInfo.setSex("\u7537");
                    fPRCardInfo.setFPR_Sex("\u7537");
                } else {
                    iDCardInfo.setSex("\u5973");
                    fPRCardInfo.setFPR_Sex("\u5973");
                }
                iDCardInfo.setName(fPRCardInfo.getFPR_ENName());
                iDCardInfo.setBirthday(fPRCardInfo.getFPR_Birthday());
                iDCardInfo.setCardNum(fPRCardInfo.getFPR_IDNo());
                iDCardInfo.setValidStartDate(fPRCardInfo.getFPR_ValidStartDate());
                iDCardInfo.setValidEndDate(fPRCardInfo.getFPR_ValidEndDate());
                iDCardInfo.setRegistInstitution(fPRCardInfo.getFPR_IssuingAuthorityCode());
                iDCardInfo.setNation(fPRCardInfo.getFPR_Nation());
            } else if (string.equals("J")) {
                iDCardInfo = new GATCardInfo();
                iDCardInfo.setCardType(CardType.GATCard);
                iDCardInfo.setCardTypeCode(string);
                iDCardInfo.setCardTypeName("\u6e2f\u6fb3\u53f0\u5c45\u6c11\u5c45\u4f4f\u8bc1");
                gATCardInfo = (GATCardInfo)iDCardInfo;
                string = new String(n, 0, 30, "UTF-16LE").trim();
                gATCardInfo.setGAT_Name(string);
                string = new String(n, 30, 2, "UTF-16LE").trim();
                gATCardInfo.setGAT_SexCode(string);
                string = new String(n, 32, 4, "UTF-16LE").trim();
                gATCardInfo.setGAT_ReserveA(string);
                string = new String(n, 36, 16, "UTF-16LE").trim();
                gATCardInfo.setGAT_Birthday(string);
                string = new String(n, 52, 70, "UTF-16LE").trim();
                gATCardInfo.setGAT_Address(string);
                string = new String(n, 122, 36, "UTF-16LE").trim();
                gATCardInfo.setGAT_IDNo(string);
                string = new String(n, 158, 30, "UTF-16LE").trim();
                gATCardInfo.setGAT_IssuingAuthority(string);
                string = new String(n, 188, 16, "UTF-16LE").trim();
                gATCardInfo.setGAT_ValidStartDate(string);
                string = new String(n, 204, 16, "UTF-16LE").trim();
                gATCardInfo.setGAT_ValidEndDate(string);
                string = new String(n, 220, 18, "UTF-16LE").trim();
                gATCardInfo.setGAT_PassportNo(string);
                string = new String(n, 238, 4, "UTF-16LE").trim();
                gATCardInfo.setGAT_IssuanceCount(string);
                string = new String(n, 242, 6, "UTF-16LE").trim();
                gATCardInfo.setGAT_ReserveB(string);
                string = new String(n, 250, 6, "UTF-16LE").trim();
                gATCardInfo.setGAT_ReserveC(string);
                if (gATCardInfo.getGAT_SexCode().equals("1")) {
                    iDCardInfo.setSex("\u7537");
                    gATCardInfo.setGAT_Sex("\u7537");
                } else {
                    iDCardInfo.setSex("\u5973");
                    gATCardInfo.setGAT_Sex("\u5973");
                }
                iDCardInfo.setName(gATCardInfo.getGAT_Name());
                iDCardInfo.setBirthday(gATCardInfo.getGAT_Birthday());
                iDCardInfo.setAddress(gATCardInfo.getGAT_Address());
                iDCardInfo.setCardNum(gATCardInfo.getGAT_IDNo());
                iDCardInfo.setValidStartDate(gATCardInfo.getGAT_ValidStartDate());
                iDCardInfo.setValidEndDate(gATCardInfo.getGAT_ValidEndDate());
                iDCardInfo.setRegistInstitution(gATCardInfo.getGAT_IssuingAuthority());
                iDCardInfo.setNation("");
            } else {
                int n;
                iDCardInfo = new IDCardInfo();
                iDCardInfo.setCardType(CardType.IDCard);
                iDCardInfo.setCardTypeCode(string);
                iDCardInfo.setCardTypeName("\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1");
                string = new String(MKR200UReader.n, 0, 30, "UTF-16LE");
                string2 = "";
                for (n = 0; n < string.length(); ++n) {
                    String string3 = string.substring(n, n + 1);
                    if (string3.equals(" ")) continue;
                    if (string3.equals("\u00b7")) {
                        string2 = string2 + string3;
                        continue;
                    }
                    if (!LangUtils.isChinese(string3)) break;
                    string2 = string2 + string3;
                }
                iDCardInfo.setName(string2);
                string = new String(MKR200UReader.n, 30, 2, "UTF-16LE");
                iDCardInfo.setSexCode(string);
                string = string.equals("1") ? "\u7537" : "\u5973";
                iDCardInfo.setSex(string);
                string = new String(MKR200UReader.n, 32, 4, "UTF-16LE");
                try {
                    n = Integer.parseInt(string.toString());
                    string = this.parseNation(n);
                }
                catch (Exception exception) {
                    string = "";
                }
                iDCardInfo.setNation(string);
                string = new String(MKR200UReader.n, 36, 16, "UTF-16LE").trim();
                iDCardInfo.setBirthday(string);
                string = new String(MKR200UReader.n, 52, 70, "UTF-16LE").trim();
                iDCardInfo.setAddress(string);
                string = new String(MKR200UReader.n, 122, 36, "UTF-16LE").trim();
                iDCardInfo.setCardNum(string);
                string = new String(MKR200UReader.n, 158, 30, "UTF-16LE").trim();
                iDCardInfo.setRegistInstitution(string);
                string = new String(MKR200UReader.n, 188, 16, "UTF-16LE").trim();
                iDCardInfo.setValidStartDate(string);
                string = new String(MKR200UReader.n, 204, 16, "UTF-16LE").trim();
                iDCardInfo.setValidEndDate(string);
            }
            if (bl) {
                string2 = this.parsePhoto(byArray2);
                iDCardInfo.setPhoto((Bitmap)string2);
            }
            iDCardInfo.setFingerInfo(byArray3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        return iDCardInfo;
    }

    private byte[] a(byte[] byArray) {
        int n = 0;
        byte by = 0;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 5];
        byArray2[n++] = 2;
        byArray2[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray2[n++] = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray2[n++] = byArray[i];
            by = (byte)(by ^ byArray[i]);
        }
        byArray2[n++] = by;
        byArray2[n++] = 3;
        return byArray2;
    }

    private byte[] a() {
        if (this.a[0] != 2) {
            return null;
        }
        byte by = 0;
        int n = this.a[1] << 8;
        byte[] byArray = new byte[n |= this.a[2]];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.a[3 + i];
            by = (byte)(by ^ byArray[i]);
        }
        if (by != this.a[3 + n]) {
            return null;
        }
        return byArray;
    }

    private boolean a(String string, String[] stringArray, int[] nArray, int n) {
        if (!this.isOpen) {
            return false;
        }
        stringArray[0] = "";
        Arrays.fill(this.a, (byte)0);
        try {
            byte[] byArray = this.a(DataUtils.hexStringToBytes(string));
            int[] nArray2 = new int[1];
            int n2 = this.j.SendReceiveBytes(byArray, byArray.length, this.a, nArray2);
            if (n2 != 0) {
                stringArray[0] = "read err1:" + String.valueOf(n2);
                Logs.d(stringArray[0]);
                return false;
            }
            byArray = this.a();
            if (byArray == null) {
                stringArray[0] = "data crc err:" + String.valueOf(n2);
                Logs.d(stringArray[0]);
                return false;
            }
            stringArray[0] = DataUtils.bytesToHexString(byArray);
            nArray[0] = byArray.length;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray[0] = exception.getMessage();
            Logs.d(stringArray[0]);
            return false;
        }
    }

    public int ResetCard(int n, byte[] byArray, int[] nArray) {
        boolean bl = false;
        if (!this.isOpen) {
            return -1;
        }
        if (!this.j.usbapi.isHidReader()) {
            return -4;
        }
        String[] stringArray = new String[1];
        switch (n) {
            case 1: 
            case 2: {
                if (!this.a("32250000", stringArray, nArray, 300) || !this.a("32240000", stringArray, nArray, 300)) break;
                byte[] byArray2 = DataUtils.hexStringToBytes(stringArray[0]);
                if (byArray2[0] == 0 && byArray2[1] == 0 && byArray2.length > 5) {
                    if ((n != 1 || byArray2[2] != 10) && (n != 2 || byArray2[2] != 11)) break;
                    nArray[0] = nArray[0] - 3;
                    System.arraycopy(byArray2, 3, byArray, 0, nArray[0]);
                    return 0;
                }
                System.arraycopy(byArray2, 0, byArray, 0, nArray[0]);
                break;
            }
            case 3: {
                if (!this.a("3251", stringArray, nArray, 300)) break;
                byte[] byArray3 = DataUtils.hexStringToBytes(stringArray[0]);
                if (byArray3[0] == 0 && byArray3[1] == 0 && byArray3.length > 4) {
                    nArray[0] = nArray[0] - 2;
                    System.arraycopy(byArray3, 2, byArray, 0, nArray[0]);
                    return 0;
                }
                System.arraycopy(byArray3, 0, byArray, 0, nArray[0]);
                break;
            }
            case 4: {
                byte[] byArray4;
                if (!this.a("3229FF", stringArray, nArray, 300) || (byArray4 = DataUtils.hexStringToBytes(stringArray[0]))[0] != 0 || byArray4[1] != 0 || byArray4.length <= 6) break;
                nArray[0] = nArray[0] - 4;
                System.arraycopy(byArray4, 2, byArray, 0, nArray[0]);
                int[] nArray2 = new int[1];
                this.a("32250000", stringArray, nArray2, 300);
                return 0;
            }
            case 5: {
                if (!this.a("32410000", stringArray, nArray, 300)) break;
                byte[] byArray5 = DataUtils.hexStringToBytes(stringArray[0]);
                if (byArray5[0] == 0 && byArray5[1] == 0 && byArray5.length > 5) {
                    byte[] byArray6;
                    nArray[0] = nArray[0] - 3;
                    System.arraycopy(byArray5, 3, byArray, 0, nArray[0]);
                    int[] nArray3 = new int[1];
                    if (this.a("32240000", stringArray, nArray3, 300) && (byArray6 = DataUtils.hexStringToBytes(stringArray[0]))[0] == 0 && byArray6[1] == 0) {
                        return -3;
                    }
                    return 0;
                }
                System.arraycopy(byArray5, 0, byArray, 0, nArray[0]);
                break;
            }
            default: {
                return -2;
            }
        }
        return -3;
    }

    public int TransApduCommand(int n, byte[] byArray, int n2, byte[] byArray2, int[] nArray) {
        boolean bl = false;
        if (!this.isOpen) {
            return -1;
        }
        if (!this.j.usbapi.isHidReader()) {
            return -4;
        }
        String[] stringArray = new String[1];
        byte[] byArray3 = byArray;
        String string = "";
        string = n == 1 || n == 2 ? "3226FF" + DataUtils.bytesToHexString(byArray3) : DataUtils.bytesToHexString(byArray3);
        if (!this.a(string, stringArray, nArray, 300)) {
            return -2;
        }
        byte[] byArray4 = DataUtils.hexStringToBytes(stringArray[0]);
        if (byArray4[0] == 0 && byArray4[1] == 0) {
            nArray[0] = nArray[0] - 2;
            System.arraycopy(byArray4, 2, byArray2, 0, nArray[0]);
        } else {
            System.arraycopy(byArray4, 0, byArray2, 0, nArray[0]);
        }
        return 0;
    }

    public void Beep(int n) {
        if (!this.isOpen) {
            return;
        }
        if (!this.j.usbapi.isHidReader()) {
            return;
        }
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        this.a("3113030101", stringArray, nArray, 300);
    }

    static {
        r = "2.2.1";
    }
}

