/*
 * Decompiled with CFR 0.152.
 */
package cn.mineki.CardReaders;

import android.content.Context;
import android.graphics.Bitmap;
import cn.mineki.CardReaders.CardType;
import cn.mineki.CardReaders.FPRCardInfo;
import cn.mineki.CardReaders.GATCardInfo;
import cn.mineki.CardReaders.IDCardInfo;
import cn.mineki.CardReaders.IDCardReader;
import cn.mineki.Utils.DataUtils;
import cn.mineki.Utils.LangUtils;
import cn.mineki.Utils.Logs;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class MKR200SReader
extends IDCardReader {
    private byte[] a = new byte[2320];
    private final String b = "32250000";
    private final String c = "32240000";
    private final String d = "32410000";
    private final String e = "3251";
    private final String f = "3229FF";
    private final String g = "3226FF";
    private final String h = "3113030101";
    private final String i = "AAAAAA9669000312FFEE";
    private final String j = "AAAAAA96690003200122";
    private final String k = "AAAAAA96690003200221";
    private final String l = "AAAAAA96690003300132";
    private final String m = "AAAAAA96690003300330";
    private final String n = "AAAAAA96690003301023";
    private final String o = "AAAAAA9669000400008084";
    private final String p = "AAAAAA9669000800009F0000000097";
    private final String q = "AAAAAA9669000400004145";
    private final String r = "AAAAAA9669000400008185";
    private final String s = "AAAAAA9669000C00009000000000000000009C";
    private boolean t = false;
    private static byte[] u = new byte[1024];
    private static byte[] v = new byte[1024];
    private static byte[] w = new byte[256];
    private static MKR200SReader x;
    private static String y;

    public static String getVersion() {
        return y;
    }

    public static MKR200SReader getInstance(Context context) {
        if (x == null) {
            x = new MKR200SReader(context);
        }
        return x;
    }

    public MKR200SReader(Context context) {
        super(context);
        this.CODE = 1;
        this.TAG = "MKR200SReader";
        this.PATH = "/dev/ttyS2";
        this.BAUDRATE = 115200;
    }

    public MKR200SReader(Context context, String string, int n) {
        super(context);
        this.CODE = 1;
        this.TAG = "MKR200SReader";
        this.PATH = string;
        this.BAUDRATE = n;
    }

    @Override
    public boolean InitReader(byte[] byArray) {
        byte[] byArray2 = null;
        if (this.isOpen) {
            return true;
        }
        try {
            if (!this.openSerialPort(new File(this.PATH), this.BAUDRATE, 0)) {
                return false;
            }
            this.sKey = this.getAct(byArray2, byArray, this.CODE);
            if (this.sKey.length() < 16) {
                this.t = false;
            } else {
                this.t = true;
                this.byLicData = byArray;
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            this.isOpen = false;
            this.t = false;
            return false;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.isOpen = false;
            this.t = false;
            return false;
        }
        this.isOpen = true;
        return true;
    }

    @Override
    public void ReleaseReader() {
        if (this.isOpen) {
            this.closeSerialPort();
            this.isOpen = false;
            this.t = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ReadSAMID(String[] stringArray) {
        String string = "";
        boolean bl = false;
        try {
            boolean bl2;
            if (!this.isOpen) {
                if (!this.openSerialPort(new File(this.PATH), this.BAUDRATE, 0)) {
                    String string2 = string;
                    return string2;
                }
                bl = true;
                this.isOpen = true;
            }
            if (!(bl2 = this.a("AAAAAA9669000312FFEE", stringArray, 300))) {
                String string3 = string;
                return string3;
            }
            if (this.a[0] == 0 && this.a[1] == 0 && this.a[2] == -112) {
                String string4 = DataUtils.toHexString1(this.a[3]);
                String string5 = DataUtils.toHexString1(this.a[5]);
                byte[] byArray = new byte[4];
                System.arraycopy(this.a, 7, byArray, 0, byArray.length);
                this.a(byArray);
                byte[] byArray2 = new byte[4];
                System.arraycopy(this.a, 11, byArray2, 0, byArray2.length);
                this.a(byArray2);
                byte[] byArray3 = new byte[4];
                System.arraycopy(this.a, 15, byArray3, 0, byArray3.length);
                this.a(byArray3);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string4);
                stringBuffer.append(".");
                stringBuffer.append(string5);
                stringBuffer.append("-");
                stringBuffer.append(this.b(byArray));
                stringBuffer.append("-");
                String string6 = Long.toString(this.b(byArray2));
                for (int i = 0; i < 10 - string6.length(); ++i) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string6);
                stringBuffer.append("-");
                String string7 = Long.toString(this.b(byArray3));
                for (int i = 0; i < 10 - string7.length(); ++i) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string7);
                string = stringBuffer.toString();
            }
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bl) {
                this.isOpen = false;
                this.closeSerialPort();
            }
        }
        return string;
    }

    private byte[] a(String[] stringArray) {
        boolean bl = this.a("AAAAAA9669000312FFEE", stringArray, 300);
        if (!bl) {
            return null;
        }
        if (this.a[0] == 0 && this.a[1] == 0 && this.a[2] == -112) {
            byte[] byArray = new byte[16];
            System.arraycopy(this.a, 3, byArray, 0, byArray.length);
            return byArray;
        }
        return null;
    }

    @Override
    public IDCardInfo ReadBaseCardInfo(String[] stringArray) {
        if (!this.isOpen) {
            return null;
        }
        if (!this.b(stringArray)) {
            return null;
        }
        if (this.c(stringArray) && this.d(stringArray)) {
            return this.a(this.a, false, this.t);
        }
        return null;
    }

    @Override
    public IDCardInfo ReadAllCardInfo(String[] stringArray) {
        if (!this.isOpen) {
            return null;
        }
        if (!this.b(stringArray)) {
            return null;
        }
        if (this.c(stringArray)) {
            String string = "";
            if (this.f(stringArray)) {
                try {
                    string = new String(this.a, 3, 70, "UTF-16LE").trim();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            if (this.e(stringArray)) {
                IDCardInfo iDCardInfo = this.a(this.a, true, this.t);
                if (iDCardInfo != null) {
                    iDCardInfo.setNewAddress(string);
                }
                return iDCardInfo;
            }
        }
        return null;
    }

    private boolean b(String[] stringArray) {
        boolean bl = this.a("AAAAAA96690003200122", stringArray, 100);
        if (!bl) {
            return false;
        }
        return stringArray[0].equalsIgnoreCase("AAAAAA9669000800009F0000000097");
    }

    private boolean c(String[] stringArray) {
        boolean bl = this.a("AAAAAA96690003200221", stringArray, 100);
        if (!bl) {
            return false;
        }
        return stringArray[0].equalsIgnoreCase("AAAAAA9669000C00009000000000000000009C");
    }

    private boolean d(String[] stringArray) {
        boolean bl = this.a("AAAAAA96690003300132", stringArray, 2000);
        if (!bl) {
            return false;
        }
        return this.a[0] == 0 && this.a[1] == 0 && this.a[2] == -112;
    }

    private boolean e(String[] stringArray) {
        boolean bl = this.a("AAAAAA96690003301023", stringArray, 3000);
        if (!bl) {
            return false;
        }
        return this.a[0] == 0 && this.a[1] == 0 && this.a[2] == -112;
    }

    private boolean f(String[] stringArray) {
        boolean bl = this.a("AAAAAA96690003300330", stringArray, 1500);
        if (!bl) {
            return false;
        }
        return this.a[0] == 0 && this.a[1] == 0 && this.a[2] == -112;
    }

    private IDCardInfo a(byte[] byArray, boolean bl, boolean bl2) {
        IDCardInfo iDCardInfo;
        block22: {
            Object object;
            iDCardInfo = null;
            FPRCardInfo fPRCardInfo = null;
            GATCardInfo gATCardInfo = null;
            String string = null;
            int n = 3;
            short s = DataUtils.getShort(byArray[n + 0], byArray[n + 1]);
            short s2 = DataUtils.getShort(byArray[n + 2], byArray[n + 3]);
            short s3 = 0;
            if (bl) {
                s3 = DataUtils.getShort(byArray[n + 4], byArray[n + 5]);
                n += 6;
            } else {
                n += 4;
            }
            System.arraycopy(byArray, n, w, 0, s);
            try {
                string = new String(w, 248, 2, "UTF-16LE").trim();
                if (string.equals("I")) {
                    iDCardInfo = new FPRCardInfo();
                    iDCardInfo.setCardType(CardType.FPRCard);
                    iDCardInfo.setCardTypeCode(string);
                    iDCardInfo.setCardTypeName("\u5916\u56fd\u4eba\u6c38\u4e45\u5c45\u7559\u8bc1");
                } else if (string.equals("J")) {
                    iDCardInfo = new GATCardInfo();
                    iDCardInfo.setCardType(CardType.GATCard);
                    iDCardInfo.setCardTypeCode(string);
                    iDCardInfo.setCardTypeName("\u6e2f\u6fb3\u53f0\u5c45\u6c11\u5c45\u4f4f\u8bc1");
                } else {
                    iDCardInfo = new IDCardInfo();
                    iDCardInfo.setCardType(CardType.IDCard);
                    iDCardInfo.setCardTypeCode(string);
                    iDCardInfo.setCardTypeName("\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u5c45\u6c11\u8eab\u4efd\u8bc1");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
            if (bl2) {
                System.arraycopy(byArray, n + s, u, 0, s2);
                object = this.parsePhoto(u);
                iDCardInfo.setPhoto((Bitmap)object);
            }
            if (s3 > 0) {
                System.arraycopy(byArray, n + s + s2, v, 0, s3);
                iDCardInfo.setFingerInfo(v);
            }
            try {
                int n2;
                if (iDCardInfo.getCardType() == CardType.FPRCard) {
                    fPRCardInfo = (FPRCardInfo)iDCardInfo;
                    string = new String(w, 0, 120, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_ENName(string);
                    string = new String(w, 120, 2, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_SexCode(string);
                    string = new String(w, 122, 30, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_IDNo(string);
                    string = new String(w, 152, 6, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_NationCode(string);
                    fPRCardInfo.setFPR_Nation(this.parseCountry(string));
                    string = new String(w, 158, 30, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_CHNName(string);
                    string = new String(w, 188, 16, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_ValidStartDate(string);
                    string = new String(w, 204, 16, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_ValidEndDate(string);
                    string = new String(w, 220, 16, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_Birthday(string);
                    string = new String(w, 236, 4, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_IDVersion(string);
                    string = new String(w, 240, 8, "UTF-16LE").trim();
                    fPRCardInfo.setFPR_IssuingAuthorityCode(string);
                    if (fPRCardInfo.getFPR_SexCode().equals("1")) {
                        iDCardInfo.setSex("\u7537");
                        fPRCardInfo.setFPR_Sex("\u7537");
                    } else {
                        iDCardInfo.setSex("\u5973");
                        fPRCardInfo.setFPR_Sex("\u5973");
                    }
                    iDCardInfo.setName(fPRCardInfo.getFPR_ENName());
                    iDCardInfo.setBirthday(fPRCardInfo.getFPR_Birthday());
                    iDCardInfo.setCardNum(fPRCardInfo.getFPR_IDNo());
                    iDCardInfo.setValidStartDate(fPRCardInfo.getFPR_ValidStartDate());
                    iDCardInfo.setValidEndDate(fPRCardInfo.getFPR_ValidEndDate());
                    iDCardInfo.setRegistInstitution(fPRCardInfo.getFPR_IssuingAuthorityCode());
                    iDCardInfo.setNation(fPRCardInfo.getFPR_Nation());
                    break block22;
                }
                if (iDCardInfo.getCardType() == CardType.GATCard) {
                    gATCardInfo = (GATCardInfo)iDCardInfo;
                    string = new String(w, 0, 30, "UTF-16LE").trim();
                    gATCardInfo.setGAT_Name(string);
                    string = new String(w, 30, 2, "UTF-16LE").trim();
                    gATCardInfo.setGAT_SexCode(string);
                    string = new String(w, 32, 4, "UTF-16LE").trim();
                    gATCardInfo.setGAT_ReserveA(string);
                    string = new String(w, 36, 16, "UTF-16LE").trim();
                    gATCardInfo.setGAT_Birthday(string);
                    string = new String(w, 52, 70, "UTF-16LE").trim();
                    gATCardInfo.setGAT_Address(string);
                    string = new String(w, 122, 36, "UTF-16LE").trim();
                    gATCardInfo.setGAT_IDNo(string);
                    string = new String(w, 158, 30, "UTF-16LE").trim();
                    gATCardInfo.setGAT_IssuingAuthority(string);
                    string = new String(w, 188, 16, "UTF-16LE").trim();
                    gATCardInfo.setGAT_ValidStartDate(string);
                    string = new String(w, 204, 16, "UTF-16LE").trim();
                    gATCardInfo.setGAT_ValidEndDate(string);
                    string = new String(w, 220, 18, "UTF-16LE").trim();
                    gATCardInfo.setGAT_PassportNo(string);
                    string = new String(w, 238, 4, "UTF-16LE").trim();
                    gATCardInfo.setGAT_IssuanceCount(string);
                    string = new String(w, 242, 6, "UTF-16LE").trim();
                    gATCardInfo.setGAT_ReserveB(string);
                    string = new String(w, 250, 6, "UTF-16LE").trim();
                    gATCardInfo.setGAT_ReserveC(string);
                    if (gATCardInfo.getGAT_SexCode().equals("1")) {
                        iDCardInfo.setSex("\u7537");
                        gATCardInfo.setGAT_Sex("\u7537");
                    } else {
                        iDCardInfo.setSex("\u5973");
                        gATCardInfo.setGAT_Sex("\u5973");
                    }
                    iDCardInfo.setName(gATCardInfo.getGAT_Name());
                    iDCardInfo.setBirthday(gATCardInfo.getGAT_Birthday());
                    iDCardInfo.setAddress(gATCardInfo.getGAT_Address());
                    iDCardInfo.setCardNum(gATCardInfo.getGAT_IDNo());
                    iDCardInfo.setValidStartDate(gATCardInfo.getGAT_ValidStartDate());
                    iDCardInfo.setValidEndDate(gATCardInfo.getGAT_ValidEndDate());
                    iDCardInfo.setRegistInstitution(gATCardInfo.getGAT_IssuingAuthority());
                    iDCardInfo.setNation("");
                    break block22;
                }
                object = "";
                for (n2 = 0; n2 < string.length(); ++n2) {
                    String string2 = string.substring(n2, n2 + 1);
                    if (string2.equals(" ")) continue;
                    if (string2.equals("\u00b7")) {
                        object = (String)object + string2;
                        continue;
                    }
                    if (!LangUtils.isChinese(string2)) break;
                    object = (String)object + string2;
                }
                iDCardInfo.setName((String)object);
                string = new String(w, 30, 2, "UTF-16LE");
                iDCardInfo.setSexCode(string);
                string = string.equals("1") ? "\u7537" : "\u5973";
                iDCardInfo.setSex(string);
                string = new String(w, 32, 4, "UTF-16LE");
                try {
                    n2 = Integer.parseInt(string.toString());
                    string = this.parseNation(n2);
                }
                catch (Exception exception) {
                    string = "";
                }
                iDCardInfo.setNation(string);
                string = new String(w, 36, 16, "UTF-16LE").trim();
                iDCardInfo.setBirthday(string);
                string = new String(w, 52, 70, "UTF-16LE").trim();
                iDCardInfo.setAddress(string);
                string = new String(w, 122, 36, "UTF-16LE").trim();
                iDCardInfo.setCardNum(string);
                string = new String(w, 158, 30, "UTF-16LE").trim();
                iDCardInfo.setRegistInstitution(string);
                string = new String(w, 188, 16, "UTF-16LE").trim();
                iDCardInfo.setValidStartDate(string);
                string = new String(w, 204, 16, "UTF-16LE").trim();
                iDCardInfo.setValidEndDate(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
        }
        return iDCardInfo;
    }

    private boolean a(String string, String[] stringArray, int n) {
        short s = 0;
        if (!this.isOpen) {
            return false;
        }
        stringArray[0] = "";
        Arrays.fill(this.a, (byte)0);
        try {
            this.write(DataUtils.hexStringToBytes(string));
            Logs.d(this.TAG, "SendAndRecvGA write\uff1a" + string);
            int n2 = this.read(this.a, 7, n);
            if (n2 != 0) {
                stringArray[0] = "read err1:" + String.valueOf(n2);
                Logs.e(this.TAG, "SendAndRecvGA read err1\uff1a" + DataUtils.bytesToHexString(this.a));
                return false;
            }
            byte[] byArray = new byte[7];
            System.arraycopy(this.a, 0, byArray, 0, byArray.length);
            stringArray[0] = DataUtils.bytesToHexString(byArray);
            Logs.d(this.TAG, "SendAndRecvGA read\uff1a" + stringArray[0]);
            if (this.a[0] == -86 && this.a[1] == -86 && this.a[2] == -86 && this.a[3] == -106 && this.a[4] == 105) {
                s = DataUtils.getShort(this.a[5], this.a[6]);
                n2 = this.read(this.a, s, n);
                if (n2 != 0) {
                    stringArray[0] = "read err2:" + String.valueOf(n2);
                    Logs.e(this.TAG, "SendAndRecvGA read err2\uff1a" + stringArray[0]);
                    return false;
                }
                byArray = new byte[s];
                System.arraycopy(this.a, 0, byArray, 0, byArray.length);
                stringArray[0] = stringArray[0] + DataUtils.bytesToHexString(byArray);
                return true;
            }
            stringArray[0] = "read err3";
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stringArray[0] = iOException.getMessage();
            Logs.e(this.TAG, "SendAndRecvGA Exception\uff1a" + stringArray[0]);
        }
        return false;
    }

    private void a(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n / 2; ++i) {
            byte by = byArray[i];
            byArray[i] = byArray[n - 1 - i];
            byArray[n - 1 - i] = by;
        }
    }

    private long b(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            n += (byArray[i] & 0xFF) << 8 * (3 - i);
        }
        long l = n;
        l <<= 32;
        return l >>>= 32;
    }

    private byte[] c(byte[] byArray) {
        int n = 0;
        byte by = 0;
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2 + 5];
        byArray2[n++] = 2;
        byArray2[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray2[n++] = (byte)(n2 & 0xFF);
        for (int i = 0; i < n2; ++i) {
            byArray2[n++] = byArray[i];
            by = (byte)(by ^ byArray[i]);
        }
        byArray2[n++] = by;
        byArray2[n++] = 3;
        return byArray2;
    }

    private byte[] a() {
        if (this.a[0] != 2) {
            return null;
        }
        byte by = 0;
        int n = this.a[1] << 8;
        byte[] byArray = new byte[n |= this.a[2]];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.a[3 + i];
            by = (byte)(by ^ byArray[i]);
        }
        if (by != this.a[3 + n]) {
            return null;
        }
        return byArray;
    }

    private int a(byte[] byArray, int n, byte[] byArray2, int[] nArray, int n2) {
        try {
            this.write(byArray, n);
            byte[] byArray3 = new byte[3];
            int n3 = this.read(byArray3, 3, n2);
            if (n3 != 0) {
                return -1;
            }
            if (byArray3[0] != 2) {
                return -2;
            }
            int n4 = DataUtils.getShort(byArray3[1], byArray3[2]);
            System.arraycopy(byArray3, 0, byArray2, 0, 3);
            byArray3 = new byte[n4 += 2];
            n3 = this.read(byArray3, n4, n2);
            if (n3 != 0) {
                return -3;
            }
            System.arraycopy(byArray3, 0, byArray2, 3, n4);
            nArray[0] = n4 + 3;
            return 0;
        }
        catch (IOException iOException) {
            return -4;
        }
    }

    private boolean a(String string, String[] stringArray, int[] nArray, int n) {
        if (!this.isOpen) {
            return false;
        }
        stringArray[0] = "";
        Arrays.fill(this.a, (byte)0);
        try {
            byte[] byArray = this.c(DataUtils.hexStringToBytes(string));
            int[] nArray2 = new int[1];
            int n2 = this.a(byArray, byArray.length, this.a, nArray2, n);
            if (n2 != 0) {
                stringArray[0] = "read err1:" + String.valueOf(n2);
                Logs.d(stringArray[0]);
                return false;
            }
            byArray = this.a();
            if (byArray == null) {
                stringArray[0] = "data crc err:" + String.valueOf(n2);
                Logs.d(stringArray[0]);
                return false;
            }
            stringArray[0] = DataUtils.bytesToHexString(byArray);
            nArray[0] = byArray.length;
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            stringArray[0] = exception.getMessage();
            Logs.d(stringArray[0]);
            return false;
        }
    }

    public int ResetCard(int n, byte[] byArray, int[] nArray) {
        boolean bl = false;
        if (!this.isOpen) {
            return -1;
        }
        String[] stringArray = new String[1];
        switch (n) {
            case 1: 
            case 2: {
                if (!this.a("32250000", stringArray, nArray, 300) || !this.a("32240000", stringArray, nArray, 300)) break;
                byte[] byArray2 = DataUtils.hexStringToBytes(stringArray[0]);
                if (byArray2[0] == 0 && byArray2[1] == 0 && byArray2.length > 5) {
                    if ((n != 1 || byArray2[2] != 10) && (n != 2 || byArray2[2] != 11)) break;
                    nArray[0] = nArray[0] - 3;
                    System.arraycopy(byArray2, 3, byArray, 0, nArray[0]);
                    return 0;
                }
                System.arraycopy(byArray2, 0, byArray, 0, nArray[0]);
                break;
            }
            case 3: {
                if (!this.a("3251", stringArray, nArray, 300)) break;
                byte[] byArray3 = DataUtils.hexStringToBytes(stringArray[0]);
                if (byArray3[0] == 0 && byArray3[1] == 0 && byArray3.length > 4) {
                    nArray[0] = nArray[0] - 2;
                    System.arraycopy(byArray3, 2, byArray, 0, nArray[0]);
                    return 0;
                }
                System.arraycopy(byArray3, 0, byArray, 0, nArray[0]);
                break;
            }
            case 4: {
                byte[] byArray4;
                if (!this.a("3229FF", stringArray, nArray, 300) || (byArray4 = DataUtils.hexStringToBytes(stringArray[0]))[0] != 0 || byArray4[1] != 0 || byArray4.length <= 6) break;
                nArray[0] = nArray[0] - 4;
                System.arraycopy(byArray4, 2, byArray, 0, nArray[0]);
                int[] nArray2 = new int[1];
                this.a("32250000", stringArray, nArray2, 300);
                return 0;
            }
            case 5: {
                if (!this.a("32410000", stringArray, nArray, 300)) break;
                byte[] byArray5 = DataUtils.hexStringToBytes(stringArray[0]);
                if (byArray5[0] == 0 && byArray5[1] == 0 && byArray5.length > 5) {
                    byte[] byArray6;
                    nArray[0] = nArray[0] - 3;
                    System.arraycopy(byArray5, 3, byArray, 0, nArray[0]);
                    int[] nArray3 = new int[1];
                    if (this.a("32240000", stringArray, nArray3, 300) && (byArray6 = DataUtils.hexStringToBytes(stringArray[0]))[0] == 0 && byArray6[1] == 0) {
                        return -3;
                    }
                    return 0;
                }
                System.arraycopy(byArray5, 0, byArray, 0, nArray[0]);
                break;
            }
            default: {
                return -2;
            }
        }
        return -3;
    }

    public int TransApduCommand(int n, byte[] byArray, int n2, byte[] byArray2, int[] nArray) {
        boolean bl = false;
        if (!this.isOpen) {
            return -1;
        }
        String[] stringArray = new String[1];
        byte[] byArray3 = byArray;
        String string = "";
        string = n == 1 || n == 2 ? "3226FF" + DataUtils.bytesToHexString(byArray3) : DataUtils.bytesToHexString(byArray3);
        if (!this.a(string, stringArray, nArray, 300)) {
            return -2;
        }
        byte[] byArray4 = DataUtils.hexStringToBytes(stringArray[0]);
        if (byArray4[0] == 0 && byArray4[1] == 0) {
            nArray[0] = nArray[0] - 2;
            System.arraycopy(byArray4, 2, byArray2, 0, nArray[0]);
        } else {
            System.arraycopy(byArray4, 0, byArray2, 0, nArray[0]);
        }
        return 0;
    }

    public void Beep(int n) {
        if (!this.isOpen) {
            return;
        }
        String[] stringArray = new String[1];
        int[] nArray = new int[1];
        this.a("3113030101", stringArray, nArray, 300);
    }

    static {
        y = "1.2.0";
    }
}

