/*
 * Decompiled with CFR 0.152.
 */
package cn.mineki.CardReaders;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import cn.mineki.CardReaders.IDCardInfo;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class IDCardReader {
    protected int CODE = 0;
    protected String TAG = "IDCardReader";
    private Context mContext = null;
    protected boolean isOpen = false;
    protected String sKey = "";
    protected byte[] byLicData = null;
    private FileDescriptor mFd;
    private FileInputStream mFileInputStream = null;
    private FileOutputStream mFileOutputStream = null;
    private byte[] bmpData = new byte[38864];
    protected String PATH = "/dev/ttyS3";
    protected int BAUDRATE = 115200;

    private static native FileDescriptor open(String var0, int var1, int var2);

    private native void close();

    protected native String getAct(byte[] var1, byte[] var2, int var3);

    protected native int WltToBmp(String var1, String var2, String var3);

    protected native int WltToBmpBuffer(byte[] var1, byte[] var2, String var3);

    public IDCardReader(Context context) {
        this.mContext = context;
    }

    public static String getVersion() {
        return "";
    }

    public void setLicense(byte[] byArray) {
        this.byLicData = Arrays.copyOf(byArray, byArray.length);
    }

    public byte[] getLicense() {
        return this.byLicData;
    }

    public void PowerOnReader(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void PowerOffReader(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(new File(string));
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getReaderPowerStatus(String string) {
        try {
            FileReader fileReader = new FileReader(new File(string));
            int n = fileReader.read();
            fileReader.close();
            return String.valueOf(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public String ReadSAMID(String[] stringArray) {
        return "";
    }

    public boolean InitReader(byte[] byArray) {
        return false;
    }

    public void ReleaseReader() {
    }

    public IDCardInfo ReadBaseCardInfo(String[] stringArray) {
        return null;
    }

    public IDCardInfo ReadAllCardInfo(String[] stringArray) {
        return null;
    }

    protected String parseNation(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "\u6c49";
                break;
            }
            case 2: {
                string = "\u8499\u53e4";
                break;
            }
            case 3: {
                string = "\u56de";
                break;
            }
            case 4: {
                string = "\u85cf";
                break;
            }
            case 5: {
                string = "\u7ef4\u543e\u5c14";
                break;
            }
            case 6: {
                string = "\u82d7";
                break;
            }
            case 7: {
                string = "\u5f5d";
                break;
            }
            case 8: {
                string = "\u58ee";
                break;
            }
            case 9: {
                string = "\u5e03\u4f9d";
                break;
            }
            case 10: {
                string = "\u671d\u9c9c";
                break;
            }
            case 11: {
                string = "\u6ee1";
                break;
            }
            case 12: {
                string = "\u4f97";
                break;
            }
            case 13: {
                string = "\u7476";
                break;
            }
            case 14: {
                string = "\u767d";
                break;
            }
            case 15: {
                string = "\u571f\u5bb6";
                break;
            }
            case 16: {
                string = "\u54c8\u5c3c";
                break;
            }
            case 17: {
                string = "\u54c8\u8428\u514b";
                break;
            }
            case 18: {
                string = "\u50a3";
                break;
            }
            case 19: {
                string = "\u9ece";
                break;
            }
            case 20: {
                string = "\u5088\u50f3";
                break;
            }
            case 21: {
                string = "\u4f64";
                break;
            }
            case 22: {
                string = "\u7572";
                break;
            }
            case 23: {
                string = "\u9ad8\u5c71";
                break;
            }
            case 24: {
                string = "\u62c9\u795c";
                break;
            }
            case 25: {
                string = "\u6c34";
                break;
            }
            case 26: {
                string = "\u4e1c\u4e61";
                break;
            }
            case 27: {
                string = "\u7eb3\u897f";
                break;
            }
            case 28: {
                string = "\u666f\u9887";
                break;
            }
            case 29: {
                string = "\u67ef\u5c14\u514b\u5b5c";
                break;
            }
            case 30: {
                string = "\u571f";
                break;
            }
            case 31: {
                string = "\u8fbe\u65a1\u5c14";
                break;
            }
            case 32: {
                string = "\u4eeb\u4f6c";
                break;
            }
            case 33: {
                string = "\u7f8c";
                break;
            }
            case 34: {
                string = "\u5e03\u6717";
                break;
            }
            case 35: {
                string = "\u6492\u62c9";
                break;
            }
            case 36: {
                string = "\u6bdb\u5357";
                break;
            }
            case 37: {
                string = "\u4ee1\u4f6c";
                break;
            }
            case 38: {
                string = "\u9521\u4f2f";
                break;
            }
            case 39: {
                string = "\u963f\u660c";
                break;
            }
            case 40: {
                string = "\u666e\u7c73";
                break;
            }
            case 41: {
                string = "\u5854\u5409\u514b";
                break;
            }
            case 42: {
                string = "\u6012";
                break;
            }
            case 43: {
                string = "\u4e4c\u5b5c\u522b\u514b";
                break;
            }
            case 44: {
                string = "\u4fc4\u7f57\u65af";
                break;
            }
            case 45: {
                string = "\u9102\u6e29\u514b";
                break;
            }
            case 46: {
                string = "\u5fb7\u6602";
                break;
            }
            case 47: {
                string = "\u4fdd\u5b89";
                break;
            }
            case 48: {
                string = "\u88d5\u56fa";
                break;
            }
            case 49: {
                string = "\u4eac";
                break;
            }
            case 50: {
                string = "\u5854\u5854\u5c14";
                break;
            }
            case 51: {
                string = "\u72ec\u9f99";
                break;
            }
            case 52: {
                string = "\u9102\u4f26\u6625";
                break;
            }
            case 53: {
                string = "\u8d6b\u54f2";
                break;
            }
            case 54: {
                string = "\u95e8\u5df4";
                break;
            }
            case 55: {
                string = "\u73de\u5df4";
                break;
            }
            case 56: {
                string = "\u57fa\u8bfa";
                break;
            }
            case 97: {
                string = "\u5176\u4ed6";
                break;
            }
            case 98: {
                string = "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb";
                break;
            }
            case 81: {
                string = "\u7a7f\u9752\u4eba";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    protected String parseCountry(String string) {
        String string2;
        switch (string) {
            case "AND": {
                string2 = "\u5b89\u9053\u5c14";
                break;
            }
            case "ARE": {
                string2 = "\u963f\u8054\u914b";
                break;
            }
            case "AFG": {
                string2 = "\u963f\u5bcc\u6c57";
                break;
            }
            case "ATG": {
                string2 = "\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe";
                break;
            }
            case "AIA": {
                string2 = "\u5b89\u572d\u62c9";
                break;
            }
            case "ALB": {
                string2 = "\u963f\u5c14\u5df4\u5c3c\u4e9a";
                break;
            }
            case "ARM": {
                string2 = "\u4e9a\u7f8e\u5c3c\u4e9a";
                break;
            }
            case "AGO": {
                string2 = "\u5b89\u54e5\u62c9";
                break;
            }
            case "ATA": {
                string2 = "\u5357\u6781\u6d32";
                break;
            }
            case "ARG": {
                string2 = "\u963f\u6839\u5ef7";
                break;
            }
            case "ASM": {
                string2 = "\u7f8e\u5c5e\u8428\u6469\u4e9a";
                break;
            }
            case "AUT": {
                string2 = "\u5965\u5730\u5229";
                break;
            }
            case "AUS": {
                string2 = "\u6fb3\u5927\u5229\u4e9a";
                break;
            }
            case "ABW": {
                string2 = "\u963f\u9c81\u5df4";
                break;
            }
            case "ALA": {
                string2 = "\u5965\u5170\u7fa4\u5c9b";
                break;
            }
            case "AZE": {
                string2 = "\u963f\u585e\u62dc\u7586";
                break;
            }
            case "BIH": {
                string2 = "\u6ce2\u9ed1";
                break;
            }
            case "BRB": {
                string2 = "\u5df4\u5df4\u591a\u65af";
                break;
            }
            case "BGD": {
                string2 = "\u5b5f\u52a0\u62c9";
                break;
            }
            case "BEL": {
                string2 = "\u6bd4\u5229\u65f6";
                break;
            }
            case "BFA": {
                string2 = "\u5e03\u57fa\u7eb3\u6cd5\u7d22";
                break;
            }
            case "BGR": {
                string2 = "\u4fdd\u52a0\u5229\u4e9a";
                break;
            }
            case "BHR": {
                string2 = "\u5df4\u6797";
                break;
            }
            case "BDI": {
                string2 = "\u5e03\u9686\u8fea";
                break;
            }
            case "BEN": {
                string2 = "\u8d1d\u5b81";
                break;
            }
            case "BLM": {
                string2 = "\u5723\u5df4\u6cf0\u52d2\u7c73\u5c9b";
                break;
            }
            case "BMU": {
                string2 = "\u767e\u6155\u5927";
                break;
            }
            case "BRN": {
                string2 = "\u6587\u83b1";
                break;
            }
            case "BOL": {
                string2 = "\u73bb\u5229\u7ef4\u4e9a";
                break;
            }
            case "BES": {
                string2 = "\u8377\u5170\u52a0\u52d2\u6bd4\u533a";
                break;
            }
            case "BRA": {
                string2 = "\u5df4\u897f";
                break;
            }
            case "BHS": {
                string2 = "\u5df4\u54c8\u9a6c";
                break;
            }
            case "BTN": {
                string2 = "\u4e0d\u4e39";
                break;
            }
            case "BVT": {
                string2 = "\u5e03\u97e6\u5c9b";
                break;
            }
            case "BWA": {
                string2 = "\u535a\u8328\u74e6\u7eb3";
                break;
            }
            case "BLR": {
                string2 = "\u767d\u4fc4\u7f57\u65af";
                break;
            }
            case "BLZ": {
                string2 = "\u4f2f\u5229\u5179";
                break;
            }
            case "CAN": {
                string2 = "\u52a0\u62ff\u5927";
                break;
            }
            case "CCK": {
                string2 = "\u79d1\u79d1\u65af\u7fa4\u5c9b";
                break;
            }
            case "CAF": {
                string2 = "\u4e2d\u975e";
                break;
            }
            case "CHE": {
                string2 = "\u745e\u58eb";
                break;
            }
            case "CHL": {
                string2 = "\u667a\u5229";
                break;
            }
            case "CMR": {
                string2 = "\u5580\u9ea6\u9686";
                break;
            }
            case "COL": {
                string2 = "\u54e5\u4f26\u6bd4\u4e9a";
                break;
            }
            case "CRI": {
                string2 = "\u54e5\u65af\u8fbe\u9ece\u52a0";
                break;
            }
            case "CUB": {
                string2 = "\u53e4\u5df4";
                break;
            }
            case "CPV": {
                string2 = "\u4f5b\u5f97\u89d2";
                break;
            }
            case "CXR": {
                string2 = "\u5723\u8bde\u5c9b";
                break;
            }
            case "CYP": {
                string2 = "\u585e\u6d66\u8def\u65af";
                break;
            }
            case "CZE": {
                string2 = "\u6377\u514b";
                break;
            }
            case "DEU": {
                string2 = "\u5fb7\u56fd";
                break;
            }
            case "DJI": {
                string2 = "\u5409\u5e03\u63d0";
                break;
            }
            case "DNK": {
                string2 = "\u4e39\u9ea6";
                break;
            }
            case "DMA": {
                string2 = "\u591a\u7c73\u5c3c\u514b";
                break;
            }
            case "DOM": {
                string2 = "\u591a\u7c73\u5c3c\u52a0";
                break;
            }
            case "DZA": {
                string2 = "\u963f\u5c14\u53ca\u5229\u4e9a";
                break;
            }
            case "ECU": {
                string2 = "\u5384\u74dc\u591a\u5c14";
                break;
            }
            case "EST": {
                string2 = "\u7231\u6c99\u5c3c\u4e9a";
                break;
            }
            case "EGY": {
                string2 = "\u57c3\u53ca";
                break;
            }
            case "ESH": {
                string2 = "\u897f\u6492\u54c8\u62c9";
                break;
            }
            case "ERI": {
                string2 = "\u5384\u7acb\u7279\u91cc\u4e9a";
                break;
            }
            case "ESP": {
                string2 = "\u897f\u73ed\u7259";
                break;
            }
            case "FIN": {
                string2 = "\u82ac\u5170";
                break;
            }
            case "FJI": {
                string2 = "\u6590\u6d4e\u7fa4\u5c9b";
                break;
            }
            case "FLK": {
                string2 = "\u9a6c\u5c14\u7ef4\u7eb3\u65af\u7fa4\u5c9b\uff08 \u798f\u514b\u5170\uff09";
                break;
            }
            case "FSM": {
                string2 = "\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u8054\u90a6";
                break;
            }
            case "FRO": {
                string2 = "\u6cd5\u7f57\u7fa4\u5c9b";
                break;
            }
            case "FRA": {
                string2 = "\u6cd5\u56fd";
                break;
            }
            case "GAB": {
                string2 = "\u52a0\u84ec";
                break;
            }
            case "GRD": {
                string2 = "\u683c\u6797\u7eb3\u8fbe";
                break;
            }
            case "GEO": {
                string2 = "\u683c\u9c81\u5409\u4e9a";
                break;
            }
            case "GUF": {
                string2 = "\u6cd5\u5c5e\u572d\u4e9a\u90a3";
                break;
            }
            case "GHA": {
                string2 = "\u52a0\u7eb3";
                break;
            }
            case "GIB": {
                string2 = "\u76f4\u5e03\u7f57\u9640";
                break;
            }
            case "GRL": {
                string2 = "\u683c\u9675\u5170";
                break;
            }
            case "GIN": {
                string2 = "\u51e0\u5185\u4e9a";
                break;
            }
            case "GLP": {
                string2 = "\u74dc\u5fb7\u7f57\u666e";
                break;
            }
            case "GNQ": {
                string2 = "\u8d64\u9053\u51e0\u5185\u4e9a";
                break;
            }
            case "GRC": {
                string2 = "\u5e0c\u814a";
                break;
            }
            case "SGS": {
                string2 = "\u5357\u4e54\u6cbb\u4e9a\u5c9b\u548c\u5357\u6851\u5a01\u5947\u7fa4\u5c9b";
                break;
            }
            case "GTM": {
                string2 = "\u5371\u5730\u9a6c\u62c9";
                break;
            }
            case "GUM": {
                string2 = "\u5173\u5c9b";
                break;
            }
            case "GNB": {
                string2 = "\u51e0\u5185\u4e9a\u6bd4\u7ecd";
                break;
            }
            case "GUY": {
                string2 = "\u572d\u4e9a\u90a3";
                break;
            }
            case "HKG": {
                string2 = "\u9999\u6e2f";
                break;
            }
            case "HMD": {
                string2 = "\u8d6b\u5fb7\u5c9b\u548c\u9ea6\u514b\u5510\u7eb3\u7fa4\u5c9b";
                break;
            }
            case "HND": {
                string2 = "\u6d2a\u90fd\u62c9\u65af";
                break;
            }
            case "HRV": {
                string2 = "\u514b\u7f57\u5730\u4e9a";
                break;
            }
            case "HTI": {
                string2 = "\u6d77\u5730";
                break;
            }
            case "HUN": {
                string2 = "\u5308\u7259\u5229";
                break;
            }
            case "IDN": {
                string2 = "\u5370\u5c3c";
                break;
            }
            case "IRL": {
                string2 = "\u7231\u5c14\u5170";
                break;
            }
            case "ISR": {
                string2 = "\u4ee5\u8272\u5217";
                break;
            }
            case "IMN": {
                string2 = "\u9a6c\u6069\u5c9b";
                break;
            }
            case "IND": {
                string2 = "\u5370\u5ea6";
                break;
            }
            case "IOT": {
                string2 = "\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730";
                break;
            }
            case "IRQ": {
                string2 = "\u4f0a\u62c9\u514b";
                break;
            }
            case "IRN": {
                string2 = "\u4f0a\u6717";
                break;
            }
            case "ISL": {
                string2 = "\u51b0\u5c9b";
                break;
            }
            case "ITA": {
                string2 = "\u610f\u5927\u5229";
                break;
            }
            case "JEY": {
                string2 = "\u6cfd\u897f\u5c9b";
                break;
            }
            case "JAM": {
                string2 = "\u7259\u4e70\u52a0";
                break;
            }
            case "JOR": {
                string2 = "\u7ea6\u65e6";
                break;
            }
            case "JPN": {
                string2 = "\u65e5\u672c";
                break;
            }
            case "KHM": {
                string2 = "\u67ec\u57d4\u5be8";
                break;
            }
            case "KIR": {
                string2 = "\u57fa\u91cc\u5df4\u65af";
                break;
            }
            case "COM": {
                string2 = "\u79d1\u6469\u7f57";
                break;
            }
            case "KWT": {
                string2 = "\u79d1\u5a01\u7279";
                break;
            }
            case "CYM": {
                string2 = "\u5f00\u66fc\u7fa4\u5c9b";
                break;
            }
            case "LBN": {
                string2 = "\u9ece\u5df4\u5ae9";
                break;
            }
            case "LIE": {
                string2 = "\u5217\u652f\u6566\u58eb\u767b";
                break;
            }
            case "LKA": {
                string2 = "\u65af\u91cc\u5170\u5361";
                break;
            }
            case "LBR": {
                string2 = "\u5229\u6bd4\u91cc\u4e9a";
                break;
            }
            case "LSO": {
                string2 = "\u83b1\u7d22\u6258";
                break;
            }
            case "LTU": {
                string2 = "\u7acb\u9676\u5b9b";
                break;
            }
            case "LUX": {
                string2 = "\u5362\u68ee\u5821";
                break;
            }
            case "LVA": {
                string2 = "\u62c9\u8131\u7ef4\u4e9a";
                break;
            }
            case "LBY": {
                string2 = "\u5229\u6bd4\u4e9a";
                break;
            }
            case "MAR": {
                string2 = "\u6469\u6d1b\u54e5";
                break;
            }
            case "MCO": {
                string2 = "\u6469\u7eb3\u54e5";
                break;
            }
            case "MDA": {
                string2 = "\u6469\u5c14\u591a\u74e6";
                break;
            }
            case "MNE": {
                string2 = "\u9ed1\u5c71";
                break;
            }
            case "MAF": {
                string2 = "\u6cd5\u5c5e\u5723\u9a6c\u4e01";
                break;
            }
            case "MDG": {
                string2 = "\u9a6c\u8fbe\u52a0\u65af\u52a0";
                break;
            }
            case "MHL": {
                string2 = "\u9a6c\u7ecd\u5c14\u7fa4\u5c9b";
                break;
            }
            case "MKD": {
                string2 = "\u9a6c\u5176\u987f";
                break;
            }
            case "MLI": {
                string2 = "\u9a6c\u91cc";
                break;
            }
            case "MMR": {
                string2 = "\u7f05\u7538";
                break;
            }
            case "MAC": {
                string2 = "\u6fb3\u95e8";
                break;
            }
            case "MTQ": {
                string2 = "\u9a6c\u63d0\u5c3c\u514b";
                break;
            }
            case "MRT": {
                string2 = "\u6bdb\u91cc\u5854\u5c3c\u4e9a";
                break;
            }
            case "MSR": {
                string2 = "\u8499\u585e\u62c9\u7279\u5c9b";
                break;
            }
            case "MLT": {
                string2 = "\u9a6c\u8033\u4ed6";
                break;
            }
            case "MDV": {
                string2 = "\u9a6c\u5c14\u4ee3\u592b";
                break;
            }
            case "MWI": {
                string2 = "\u9a6c\u62c9\u7ef4";
                break;
            }
            case "MEX": {
                string2 = "\u58a8\u897f\u54e5";
                break;
            }
            case "MYS": {
                string2 = "\u9a6c\u6765\u897f\u4e9a";
                break;
            }
            case "NAM": {
                string2 = "\u7eb3\u7c73\u6bd4\u4e9a";
                break;
            }
            case "NER": {
                string2 = "\u5c3c\u65e5\u5c14";
                break;
            }
            case "NFK": {
                string2 = "\u8bfa\u798f\u514b\u5c9b";
                break;
            }
            case "NGA": {
                string2 = "\u5c3c\u65e5\u5229\u4e9a";
                break;
            }
            case "NIC": {
                string2 = "\u5c3c\u52a0\u62c9\u74dc";
                break;
            }
            case "NLD": {
                string2 = "\u8377\u5170";
                break;
            }
            case "NOR": {
                string2 = "\u632a\u5a01";
                break;
            }
            case "NPL": {
                string2 = "\u5c3c\u6cca\u5c14";
                break;
            }
            case "NRU": {
                string2 = "\u7459\u9c81";
                break;
            }
            case "OMN": {
                string2 = "\u963f\u66fc";
                break;
            }
            case "PAN": {
                string2 = "\u5df4\u62ff\u9a6c";
                break;
            }
            case "PER": {
                string2 = "\u79d8\u9c81";
                break;
            }
            case "PYF": {
                string2 = "\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a";
                break;
            }
            case "PNG": {
                string2 = "\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a";
                break;
            }
            case "PHL": {
                string2 = "\u83f2\u5f8b\u5bbe";
                break;
            }
            case "PAK": {
                string2 = "\u5df4\u57fa\u65af\u5766";
                break;
            }
            case "POL": {
                string2 = "\u6ce2\u5170";
                break;
            }
            case "PCN": {
                string2 = "\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b";
                break;
            }
            case "PRI": {
                string2 = "\u6ce2\u591a\u9ece\u5404";
                break;
            }
            case "PSE": {
                string2 = "\u5df4\u52d2\u65af\u5766";
                break;
            }
            case "PLW": {
                string2 = "\u5e15\u52b3";
                break;
            }
            case "PRY": {
                string2 = "\u5df4\u62c9\u572d";
                break;
            }
            case "QAT": {
                string2 = "\u5361\u5854\u5c14";
                break;
            }
            case "REU": {
                string2 = "\u7559\u5c3c\u6c6a";
                break;
            }
            case "ROU": {
                string2 = "\u7f57\u9a6c\u5c3c\u4e9a";
                break;
            }
            case "SRB": {
                string2 = "\u585e\u5c14\u7ef4\u4e9a";
                break;
            }
            case "RUS": {
                string2 = "\u4fc4\u7f57\u65af";
                break;
            }
            case "RWA": {
                string2 = "\u5362\u65fa\u8fbe";
                break;
            }
            case "SLB": {
                string2 = "\u6240\u7f57\u95e8\u7fa4\u5c9b";
                break;
            }
            case "SYC": {
                string2 = "\u585e\u820c\u5c14";
                break;
            }
            case "SDN": {
                string2 = "\u82cf\u4e39";
                break;
            }
            case "SWE": {
                string2 = "\u745e\u5178";
                break;
            }
            case "SGP": {
                string2 = "\u65b0\u52a0\u5761";
                break;
            }
            case "SVN": {
                string2 = "\u65af\u6d1b\u6587\u5c3c\u4e9a";
                break;
            }
            case "SJM": {
                string2 = "\u65af\u74e6\u5c14\u5df4\u7fa4\u5c9b\u548c\u626c\u9a6c\u5ef6\u5c9b";
                break;
            }
            case "SVK": {
                string2 = "\u65af\u6d1b\u4f10\u514b";
                break;
            }
            case "SLE": {
                string2 = "\u585e\u62c9\u5229\u6602";
                break;
            }
            case "SMR": {
                string2 = "\u5723\u9a6c\u529b\u8bfa";
                break;
            }
            case "SEN": {
                string2 = "\u585e\u5185\u52a0\u5c14";
                break;
            }
            case "SOM": {
                string2 = "\u7d22\u9a6c\u91cc";
                break;
            }
            case "SUR": {
                string2 = "\u82cf\u91cc\u5357";
                break;
            }
            case "SSD": {
                string2 = "\u5357\u82cf\u4e39";
                break;
            }
            case "STP": {
                string2 = "\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4";
                break;
            }
            case "SLV": {
                string2 = "\u8428\u5c14\u74e6\u591a";
                break;
            }
            case "SYR": {
                string2 = "\u53d9\u5229\u4e9a";
                break;
            }
            case "SWZ": {
                string2 = "\u65af\u5a01\u58eb\u5170";
                break;
            }
            case "TCA": {
                string2 = "\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b";
                break;
            }
            case "TCD": {
                string2 = "\u4e4d\u5f97";
                break;
            }
            case "TGO": {
                string2 = "\u591a\u54e5";
                break;
            }
            case "THA": {
                string2 = "\u6cf0\u56fd";
                break;
            }
            case "TKL": {
                string2 = "\u6258\u514b\u52b3";
                break;
            }
            case "TLS": {
                string2 = "\u4e1c\u5e1d\u6c76";
                break;
            }
            case "TUN": {
                string2 = "\u7a81\u5c3c\u65af";
                break;
            }
            case "TON": {
                string2 = "\u6c64\u52a0";
                break;
            }
            case "TUR": {
                string2 = "\u571f\u8033\u5176";
                break;
            }
            case "TUV": {
                string2 = "\u56fe\u74e6\u5362";
                break;
            }
            case "TZA": {
                string2 = "\u5766\u6851\u5c3c\u4e9a";
                break;
            }
            case "UKR": {
                string2 = "\u4e4c\u514b\u5170";
                break;
            }
            case "UGA": {
                string2 = "\u4e4c\u5e72\u8fbe";
                break;
            }
            case "USA": {
                string2 = "\u7f8e\u56fd";
                break;
            }
            case "URY": {
                string2 = "\u4e4c\u62c9\u572d";
                break;
            }
            case "VAT": {
                string2 = "\u68b5\u8482\u5188";
                break;
            }
            case "VEN": {
                string2 = "\u59d4\u5185\u745e\u62c9";
                break;
            }
            case "VGB": {
                string2 = "\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b";
                break;
            }
            case "VIR": {
                string2 = "\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b";
                break;
            }
            case "VNM": {
                string2 = "\u8d8a\u5357";
                break;
            }
            case "WLF": {
                string2 = "\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3";
                break;
            }
            case "WSM": {
                string2 = "\u8428\u6469\u4e9a";
                break;
            }
            case "YEM": {
                string2 = "\u4e5f\u95e8";
                break;
            }
            case "MYT": {
                string2 = "\u9a6c\u7ea6\u7279";
                break;
            }
            case "ZAF": {
                string2 = "\u5357\u975e";
                break;
            }
            case "ZMB": {
                string2 = "\u8d5e\u6bd4\u4e9a";
                break;
            }
            case "ZWE": {
                string2 = "\u6d25\u5df4\u5e03\u97e6";
                break;
            }
            case "CHN": {
                string2 = "\u4e2d\u56fd";
                break;
            }
            case "COG": {
                string2 = "\u521a\u679c(\u5e03)";
                break;
            }
            case "COD": {
                string2 = "\u521a\u679c(\u91d1)";
                break;
            }
            case "MOZ": {
                string2 = "\u83ab\u6851\u6bd4\u514b";
                break;
            }
            case "GGY": {
                string2 = "\u6839\u897f\u5c9b";
                break;
            }
            case "GMB": {
                string2 = "\u5188\u6bd4\u4e9a";
                break;
            }
            case "MNP": {
                string2 = "\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b";
                break;
            }
            case "ETH": {
                string2 = "\u57c3\u585e\u4fc4\u6bd4\u4e9a";
                break;
            }
            case "NCL": {
                string2 = "\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a";
                break;
            }
            case "VUT": {
                string2 = "\u74e6\u52aa\u963f\u56fe";
                break;
            }
            case "ATF": {
                string2 = "\u6cd5\u5c5e\u5357\u90e8\u9886\u5730";
                break;
            }
            case "NIU": {
                string2 = "\u7ebd\u57c3";
                break;
            }
            case "UMI": {
                string2 = "\u7f8e\u56fd\u672c\u571f\u5916\u5c0f\u5c9b\u5c7f";
                break;
            }
            case "COK": {
                string2 = "\u5e93\u514b\u7fa4\u5c9b";
                break;
            }
            case "GBR": {
                string2 = "\u82f1\u56fd";
                break;
            }
            case "TTO": {
                string2 = "\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5";
                break;
            }
            case "VCT": {
                string2 = "\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af";
                break;
            }
            case "TWN": {
                string2 = "\u4e2d\u534e\u6c11\u56fd\uff08\u53f0\u6e7e\uff09";
                break;
            }
            case "NZL": {
                string2 = "\u65b0\u897f\u5170";
                break;
            }
            case "SAU": {
                string2 = "\u6c99\u7279\u963f\u62c9\u4f2f";
                break;
            }
            case "LAO": {
                string2 = "\u8001\u631d";
                break;
            }
            case "PRK": {
                string2 = "\u671d\u9c9c";
                break;
            }
            case "KOR": {
                string2 = "\u97e9\u56fd";
                break;
            }
            case "PRT": {
                string2 = "\u8461\u8404\u7259";
                break;
            }
            case "KGZ": {
                string2 = "\u5409\u5c14\u5409\u65af\u65af\u5766";
                break;
            }
            case "KAZ": {
                string2 = "\u54c8\u8428\u514b\u65af\u5766";
                break;
            }
            case "TJK": {
                string2 = "\u5854\u5409\u514b\u65af\u5766";
                break;
            }
            case "TKM": {
                string2 = "\u571f\u5e93\u66fc\u65af\u5766";
                break;
            }
            case "UZB": {
                string2 = "\u4e4c\u5179\u522b\u514b\u65af\u5766";
                break;
            }
            case "KNA": {
                string2 = "\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af";
                break;
            }
            case "SPM": {
                string2 = "\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686";
                break;
            }
            case "SHN": {
                string2 = "\u5723\u8d6b\u52d2\u62ff";
                break;
            }
            case "LCA": {
                string2 = "\u5723\u5362\u897f\u4e9a";
                break;
            }
            case "MUS": {
                string2 = "\u6bdb\u91cc\u6c42\u65af";
                break;
            }
            case "CIV": {
                string2 = "\u79d1\u7279\u8fea\u74e6";
                break;
            }
            case "KEN": {
                string2 = "\u80af\u5c3c\u4e9a";
                break;
            }
            case "MNG": {
                string2 = "\u8499\u53e4\u56fd";
                break;
            }
            default: {
                string2 = string;
            }
        }
        return string2;
    }

    protected Bitmap parsePhoto(byte[] byArray) {
        byte[] byArray2 = new byte[38864];
        int n = this.WltToBmpBuffer(byArray, byArray2, this.sKey);
        if (n != 0) {
            this.sKey = this.getAct(null, this.byLicData, this.CODE);
            n = this.WltToBmpBuffer(byArray, byArray2, this.sKey);
            if (n != 0) {
                return null;
            }
        }
        return BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    protected void closeSerialPort() {
        try {
            if (this.mFileInputStream != null) {
                this.mFileInputStream.close();
            }
            if (this.mFileOutputStream != null) {
                this.mFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.close();
        this.mFd = null;
    }

    protected boolean openSerialPort(File file, int n, int n2) {
        try {
            if (!file.canRead() || !file.canWrite()) {
                try {
                    Process process = Runtime.getRuntime().exec("/system/bin/su");
                    String string = "chmod 666 " + file.getAbsolutePath() + "\nexit\n";
                    process.getOutputStream().write(string.getBytes());
                    if (process.waitFor() != 0 || !file.canRead() || !file.canWrite()) {
                        throw new SecurityException();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new SecurityException();
                }
            }
            this.mFd = IDCardReader.open(file.getAbsolutePath(), n, n2);
            if (this.mFd == null) {
                return false;
            }
            this.mFileInputStream = new FileInputStream(this.mFd);
            this.mFileOutputStream = new FileOutputStream(this.mFd);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private InputStream getInputStream() {
        return this.mFileInputStream;
    }

    private OutputStream getOutputStream() {
        return this.mFileOutputStream;
    }

    protected int read(byte[] byArray, int n, long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        int n2 = 0;
        int n3 = 0;
        while (this.mFileInputStream.available() <= 0 || (n2 = this.mFileInputStream.read(byArray, n3, n - n3)) <= 0 || n != (n3 += n2)) {
            try {
                Thread.sleep(10L);
                l3 = System.currentTimeMillis();
                if (l3 - l2 <= l) continue;
                return 2;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
        return 0;
    }

    protected int read(byte[] byArray, long l) {
        long l2 = System.currentTimeMillis();
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        while (true) {
            if (this.mFileInputStream.available() > 0 && (n = this.mFileInputStream.read(byArray, n2, 1)) > 0) {
                n2 += n;
            }
            try {
                Thread.sleep(10L);
                l3 = System.currentTimeMillis();
                if (l3 - l2 <= l) continue;
                return n2;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    protected void write(byte[] byArray) {
        while (this.mFileInputStream.available() > 0) {
            this.mFileInputStream.read();
        }
        this.mFileOutputStream.write(byArray);
    }

    protected void write(byte[] byArray, int n) {
        while (this.mFileInputStream.available() > 0) {
            this.mFileInputStream.read();
        }
        this.mFileOutputStream.write(byArray, 0, n);
    }

    static {
        System.loadLibrary("IDCardReader");
    }
}

