/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Team;
import com.ptteng.common.skill.service.TeamService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TeamServiceImpl
extends BaseDaoServiceImpl
implements TeamService {
    private static final Log log = LogFactory.getLog(TeamServiceImpl.class);

    public Long insert(Team team) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + team));
        if (team == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        team.setCreateAt(Long.valueOf(currentTimeMillis));
        team.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)team);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + team));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Team> insertList(List<Team> teamList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (teamList == null ? "null" : Integer.valueOf(teamList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(teamList)) {
            return new ArrayList<Team>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Team team : teamList) {
            team.setCreateAt(Long.valueOf(currentTimeMillis));
            team.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(teamList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + teamList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Team.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Team team) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (team == null ? "null" : team.getId())));
        boolean result = false;
        if (team == null) {
            return true;
        }
        team.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)team);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + team));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + team));
        }
        return result;
    }

    public boolean updateList(List<Team> teamList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (teamList == null ? "null" : Integer.valueOf(teamList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(teamList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Team team : teamList) {
            team.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(teamList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + teamList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + teamList.size()));
        return result;
    }

    public Team getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Team team = null;
        if (id == null) {
            return team;
        }
        try {
            team = (Team)this.dao.get(Team.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return team;
    }

    public List<Team> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List team = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Team>();
        }
        try {
            team = this.dao.getList(Team.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (team == null ? "null" : Integer.valueOf(team.size()))));
        return team;
    }

    public List<Long> getTeamIdsByNameOrderByCreateAt(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by name,start,limit  : " + name + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTeamIdsByNameOrderByCreateAt", new Object[]{name}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by name,start,limit)  : " + name + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTeamIdsByNameOrderByCreateAt(String name) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by name  : " + name));
        }
        Integer count = null;
        try {
            count = this.dao.count("getTeamIdsByNameOrderByCreateAt", new Object[]{name});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by name)  : " + name));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getTeamIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getTeamIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countTeamIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getTeamIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getTeamIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

