/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Successor;
import com.ptteng.common.skill.service.SuccessorService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SuccessorServiceImpl
extends BaseDaoServiceImpl
implements SuccessorService {
    private static final Log log = LogFactory.getLog(SuccessorServiceImpl.class);

    public Long insert(Successor successor) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + successor));
        if (successor == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        successor.setCreateAt(Long.valueOf(currentTimeMillis));
        successor.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)successor);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + successor));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Successor> insertList(List<Successor> successorList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (successorList == null ? "null" : Integer.valueOf(successorList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(successorList)) {
            return new ArrayList<Successor>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Successor successor : successorList) {
            successor.setCreateAt(Long.valueOf(currentTimeMillis));
            successor.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(successorList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + successorList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Successor.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Successor successor) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (successor == null ? "null" : successor.getId())));
        boolean result = false;
        if (successor == null) {
            return true;
        }
        successor.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)successor);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + successor));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + successor));
        }
        return result;
    }

    public boolean updateList(List<Successor> successorList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (successorList == null ? "null" : Integer.valueOf(successorList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(successorList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Successor successor : successorList) {
            successor.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(successorList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + successorList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + successorList.size()));
        return result;
    }

    public Successor getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Successor successor = null;
        if (id == null) {
            return successor;
        }
        try {
            successor = (Successor)this.dao.get(Successor.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return successor;
    }

    public List<Successor> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List successor = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Successor>();
        }
        try {
            successor = this.dao.getList(Successor.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (successor == null ? "null" : Integer.valueOf(successor.size()))));
        return successor;
    }

    public List<Long> getUidsByOidAndBranchId(Long oid, Long branchId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get uids by oid,branchId,start,limit  : " + oid + " , " + branchId + " , " + start + " , " + limit));
        }
        List uidList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            uidList = this.dao.getIdList("getUidsByOidAndBranchId", new Object[]{oid, branchId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get uids  wrong by oid,branchId,start,limit)  : " + oid + " , " + branchId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get uids success : " + (uidList == null ? "null" : Integer.valueOf(uidList.size()))));
        }
        return uidList;
    }

    public List<Long> getSuccessorIdsByBranchId(Long branchId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by branchId,start,limit  : " + branchId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSuccessorIdsByBranchId", new Object[]{branchId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by branchId,start,limit)  : " + branchId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getSuccessorIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSuccessorIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getOidsByBranchId(Long branchId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get oids by branchId,start,limit  : " + branchId + " , " + start + " , " + limit));
        }
        List oidList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            oidList = this.dao.getIdList("getOidsByBranchId", new Object[]{branchId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get oids  wrong by branchId,start,limit)  : " + branchId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get oids success : " + (oidList == null ? "null" : Integer.valueOf(oidList.size()))));
        }
        return oidList;
    }

    public List<Long> getUidsByOid(Long oid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get uids by oid,start,limit  : " + oid + " , " + start + " , " + limit));
        }
        List uidList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            uidList = this.dao.getIdList("getUidsByOid", new Object[]{oid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get uids  wrong by oid,start,limit)  : " + oid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get uids success : " + (uidList == null ? "null" : Integer.valueOf(uidList.size()))));
        }
        return uidList;
    }

    public List<Long> getUidsByBranchId(Long branchId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get uids by branchId,start,limit  : " + branchId + " , " + start + " , " + limit));
        }
        List uidList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            uidList = this.dao.getIdList("getUidsByBranchId", new Object[]{branchId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get uids  wrong by branchId,start,limit)  : " + branchId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get uids success : " + (uidList == null ? "null" : Integer.valueOf(uidList.size()))));
        }
        return uidList;
    }

    public Long getSuccessorIdByBranchIdAndUidAndOid(Long branchId, Long uid, Long oid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by branchId,uid,oid  : " + branchId + " , " + uid + " , " + oid));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getSuccessorIdByBranchIdAndUidAndOid", new Object[]{branchId, uid, oid});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by branchId,uid,oid  : " + branchId + " , " + uid + " , " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public Integer countUidsByOidAndBranchId(Long oid, Long branchId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count uids by oid,branchId  : " + oid + " , " + branchId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUidsByOidAndBranchId", new Object[]{oid, branchId});
        }
        catch (DaoException e) {
            log.error((Object)(" count uids  wrong by oid,branchId)  : " + oid + " , " + branchId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countSuccessorIdsByBranchId(Long branchId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by branchId  : " + branchId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSuccessorIdsByBranchId", new Object[]{branchId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by branchId)  : " + branchId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countSuccessorIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getSuccessorIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countOidsByBranchId(Long branchId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count oids by branchId  : " + branchId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getOidsByBranchId", new Object[]{branchId});
        }
        catch (DaoException e) {
            log.error((Object)(" count oids  wrong by branchId)  : " + branchId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUidsByOid(Long oid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count uids by oid  : " + oid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUidsByOid", new Object[]{oid});
        }
        catch (DaoException e) {
            log.error((Object)(" count uids  wrong by oid)  : " + oid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUidsByBranchId(Long branchId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count uids by branchId  : " + branchId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUidsByBranchId", new Object[]{branchId});
        }
        catch (DaoException e) {
            log.error((Object)(" count uids  wrong by branchId)  : " + branchId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getSuccessorIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getSuccessorIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countSuccessorIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getSuccessorIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getSuccessorIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

