

-- ----------------------------
-- Table structure for `user_article_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_article_relation`;
CREATE TABLE `user_article_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `aid` bigint(20) NOT NULL   COMMENT '日报ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',
    `type` int(11)    COMMENT '用户与日报关系 1-点赞 2-收藏',
    `whether` int(11)    COMMENT '关系状态 1-存在 2-撤销',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


CREATE TABLE `user_document_relation` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `document_id` bigint(20) NOT NULL,
  `uid` bigint(20) NOT NULL,
  `type` int(11) NOT NULL COMMENT '类型 1 文档 2 视频  3 书籍',
  `status` int(11) NOT NULL COMMENT '状态 1 点赞 2 收藏',
  `comment` text COMMENT '冗余字段未使用',
  `whether` int(11) DEFAULT NULL COMMENT '关系状态 1-存在 0-撤销',
  `create_by` bigint(20) ,
  `update_by` bigint(20) ,
  `update_at` bigint(20) NOT NULL,
  `create_at` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;






-- ----------------------------
-- Table structure for `user_skill_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_skill_relation`;
    CREATE TABLE `user_skill_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `sid` bigint(20) NOT NULL   COMMENT '技能ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',
    `degree` int(11)    COMMENT '技能熟练度',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;







-- ----------------------------
-- Table structure for `user_task_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_task_relation`;
CREATE TABLE `user_task_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `tid` bigint(20) NOT NULL   COMMENT '任务ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业ID',
    `progress` int(2) NOT NULL   COMMENT '当前进度',
    `result_url` varchar(1000)    COMMENT '成果展示链接',
    `code_url` varchar(1000)    COMMENT '成果代码链接',
    `receive_at` bigint(20)    COMMENT '领取任务时间',
    `submit_at` bigint(20)    COMMENT '提交任务时间',
    `judge_uid` bigint(20)    COMMENT '审核者用户ID',
    `judge_remark` text    COMMENT '审核备注',
    `judge_at` bigint(20)    COMMENT '审核时间',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `sms`
-- ----------------------------
-- DROP TABLE IF EXISTS `sms`;
CREATE TABLE `sms` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `message` varchar(1000) NOT NULL  ,  
    `type` varchar(50) NOT NULL  ,  
    `mobile` varchar(30) NOT NULL  ,  
    `count` int   ,  
    `send_at` bigint NOT NULL  ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user`
-- ----------------------------
-- DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `nick` varchar(1000)   ,  
    `mobile` varchar(200) NOT NULL  ,  
    `pwd` varchar(1000) NOT NULL  ,  
    `sex` bigint   ,  
    `thumb` varchar(200)   ,  
    `sign` varchar(1000)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_class_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_class_relation`;
CREATE TABLE `user_class_relation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `cid` bigint NOT NULL  ,  
    `swear` varchar(1000)   ,
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `comment`
-- ----------------------------
-- DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `uid` bigint NOT NULL  ,  
    `did` bigint NOT NULL  ,  
    `comment` varchar(1000)   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `occupation`
-- ----------------------------
-- DROP TABLE IF EXISTS `occupation`;
CREATE TABLE `occupation` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(200)   ,  
    `grade_count` bigint NOT NULL  ,  
    `class_count` bigint NOT NULL  ,  
    `user_count` bigint NOT NULL  ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `article`
-- ----------------------------
-- DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `cid` bigint NOT NULL  ,  
    `uid` bigint NOT NULL  ,  
    `type` varchar(200) NOT NULL  ,  
    `title` varchar(500)   ,  
    `content` varchar(1000)   ,  
    `reply` bigint   ,  
    `read` bigint   ,  
    `create_by` bigint   ,  
    `update_by` bigint   ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `class`
-- ----------------------------
-- DROP TABLE IF EXISTS `class`;
CREATE TABLE `class` (
    `id` bigint NOT NULL   AUTO_INCREMENT ,  
    `name` varchar(200) NOT NULL  ,  
    `oid` bigint NOT NULL  ,  
    `total` bigint NOT NULL  ,  
    `qq` bigint   ,  
    `content` varchar(1000)   ,  
    `grade` bigint NOT NULL  ,  
    `status` bigint NOT NULL  ,  
    `create_by` bigint NOT NULL  ,  
    `update_by` bigint NOT NULL  ,  
    `update_at` bigint NOT NULL  ,  
    `create_at` bigint NOT NULL  ,  
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `user_score`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_score`;
CREATE TABLE `user_score` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户id',
    `score` bigint(20) NOT NULL   COMMENT '总积分',
    `comment` text    COMMENT '积分增减原由描述',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `leaves`
-- ----------------------------
-- DROP TABLE IF EXISTS `leaves`;
CREATE TABLE `leaves` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `uid` bigint(20) NOT NULL   COMMENT '用户id',
    `start_at` bigint(20) NOT NULL   COMMENT '请假时间',
    `end_at` bigint(20) NOT NULL   COMMENT '销假时间',
    `hours` int(50) NOT NULL   COMMENT '请假小时数',
    `comments` text NOT NULL   COMMENT '请假理由',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `constant`
-- ----------------------------
-- DROP TABLE IF EXISTS `constant`;
CREATE TABLE `constant` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(500)    COMMENT '用户ID',
    `value` varchar(2000)    COMMENT '日报id',
    `type` varchar(1000)    COMMENT '评论',
    `comments` varchar(2000)    COMMENT '备注',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20) NOT NULL   COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `ctype`
-- ----------------------------
-- DROP TABLE IF EXISTS `ctype`;
CREATE TABLE `ctype` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `title` varchar(50) NOT NULL   COMMENT '类型名称',
    `img` varchar(255)    COMMENT '图片链接',
    `description` varchar(255)    COMMENT '使用规则限制描述',
    `expire` int(8) NOT NULL   COMMENT '有效期',
    `status` int(2) NOT NULL   COMMENT '是否有效',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint    COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `card`
-- ----------------------------
-- DROP TABLE IF EXISTS `card`;
CREATE TABLE `card` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `code` varchar(20) NOT NULL    COMMENT '卡券编号',
    `tid` bigint NOT NULL   COMMENT '类型id',
    `owner_id` bigint    COMMENT '持有者id',
    `assign_id` bigint    COMMENT '发放人id',
    `verification_id` bigint    COMMENT '核销人id',
    `status` int(2) NOT NULL   COMMENT '状态',
    `card_valid` int(2) NOT NULL   COMMENT '启用禁用状态',
    `assign_at` bigint    COMMENT '发放时间',
    `apply_at` bigint    COMMENT '申请使用时间',
    `verification_at` bigint    COMMENT '核销时间',
    `expire_at` bigint    COMMENT '过期时间',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint    COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;





-- ----------------------------
-- Table structure for `clog`
-- ----------------------------
-- DROP TABLE IF EXISTS `clog`;
CREATE TABLE `clog` (
    `id` bigint NOT NULL   AUTO_INCREMENT  COMMENT 'id',
    `cid` bigint NOT NULL   COMMENT '卡券id',
    `tid` bigint NOT NULL   COMMENT '类型id',
    `type` int(2) NOT NULL   COMMENT '操作',
    `admin_id` int(8)    COMMENT '管理员',
    `use_id` int(8)    COMMENT '使用人',
    `receive_id` int(8)    COMMENT '被使用人',
    `remark` VARCHAR(100)    COMMENT '备注',
    `create_by` bigint NOT NULL   COMMENT '创建人ID',
    `update_by` bigint    COMMENT '更新人ID',
    `update_at` bigint    COMMENT '数据更新时间',
    `create_at` bigint NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `user_statistics`
-- ----------------------------
-- DROP TABLE IF EXISTS `user_statistics`;
CREATE TABLE `user_statistics` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '关联用户ID',
    `card_used` int(10)    COMMENT '已使用卡券',
    `card_unused` int(10)    COMMENT '未使用卡券',
    `card_verified` int(10)    COMMENT '已核销卡券',
    `card_verifying` int(10)    COMMENT '核销中卡券',
    `card_cession` int(10)    COMMENT '已转让卡券',
    `card_expired` int(10)    COMMENT '已过期卡券',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `stage`
-- ----------------------------
-- DROP TABLE IF EXISTS `stage`;
CREATE TABLE `stage` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业ID',
    `name` varchar(1000) NOT NULL   COMMENT '阶段名字',
    `achievement` text   COMMENT '阶段成果',
    `target` text    COMMENT '阶段目标',
    `salary` bigint(20)    COMMENT '阶段薪资',
    `sort` int(50)    COMMENT '排序',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `product`
-- ----------------------------
-- DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(200) NOT NULL   COMMENT '产品名',
    `industry` varchar(200)    COMMENT '行业',
    `status` int(2)    COMMENT '状态',
    `description` text    COMMENT '产品背景',
    `nums` int(20)    COMMENT '迭代数',
    `level` bigint(20)    COMMENT '排序',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `iteration`
-- ----------------------------
-- DROP TABLE IF EXISTS `iteration`;
CREATE TABLE `iteration` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `product_id` bigint(20) NOT NULL   COMMENT '产品ID',
    `name` varchar(200) NOT NULL   COMMENT '迭代名',
    `time` bigint(20)    COMMENT '迭代天数',
    `status` int(2)    COMMENT '状态',
    `exdata` text    COMMENT '迭代资料',
    `sort` bigint(20) NOT NULL   COMMENT '排序',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `stage_replay`
-- ----------------------------
-- DROP TABLE IF EXISTS `stage_replay`;
CREATE TABLE `stage_replay` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(200) NOT NULL   COMMENT '阶段名称',
    `contents` varchar(1000)    COMMENT '交付内容',
    `sort` bigint(20) NOT NULL   COMMENT '排序',
    `status` int(2) NOT NULL   COMMENT '状态',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `team`
-- ----------------------------
-- DROP TABLE IF EXISTS `team`;
CREATE TABLE `team` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `name` varchar(200) NOT NULL   COMMENT '小组名',
    `leader_id` bigint(20) NOT NULL   COMMENT '小组长ID',
    `senior_id` bigint(20) NOT NULL   COMMENT '复盘师兄ID',
    `nums` int(10)    COMMENT '组员人数',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `project`
-- ----------------------------
-- DROP TABLE IF EXISTS `project`;
CREATE TABLE `project` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `gid` bigint(20) NOT NULL   COMMENT '小组ID',
    `name` varchar(200) NOT NULL   COMMENT '项目代号',
    `product_id` bigint(20) NOT NULL   COMMENT '产品ID',
    `iteration_id` bigint(20) NOT NULL   COMMENT '迭代ID',
    `url` varchar(200)    COMMENT '禅道地址',
    `start_at` bigint(20)    COMMENT '项目开始时间',
    `end_at` bigint(20)    COMMENT '项目结束时间',
    `stages` text    COMMENT '项目全部阶段',
    `time` bigint(20)    COMMENT '总预估时间',
    `time_actual` bigint(20)    COMMENT '实际完成时间',
    `sid` bigint(20)    COMMENT '当前阶段',
    `status` int(10)    COMMENT '状态',
    `nums` int(10)    COMMENT '晨报数',
    `create_by` bigint(20)    COMMENT '创建人ID',
    `update_by` bigint(20)    COMMENT '更新人ID',
    `update_at` bigint(20) NOT NULL   COMMENT '数据更新时间',
    `create_at` bigint(20) NOT NULL   COMMENT '数据创建时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for `label`
-- ----------------------------
-- DROP TABLE IF EXISTS `label`;
CREATE TABLE `label` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业id',
    `tid` bigint(20) NOT NULL   COMMENT '任务id',
    `title` varchar(15) NOT NULL   COMMENT '标签名称',
    `question_num` bigint(20) NOT NULL  DEFAULT 0  COMMENT '问题数量默认0',
    `status` Int(2) NOT NULL  DEFAULT 1 COMMENT '标签状态默认上架',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `question`
-- ----------------------------
-- DROP TABLE IF EXISTS `question`;
CREATE TABLE `question` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业id',
    `tid` bigint(20) NOT NULL   COMMENT '任务id',
    `type` Int(2) NOT NULL   COMMENT '问题类型',
    `title` varchar(200) NOT NULL   COMMENT '问题标题',
    `description` text NOT NULL   COMMENT '问题描述',
    `modules` text    COMMENT '问题模块',
    `status` Int(2) NOT NULL  DEFAULT 1 COMMENT '问题状态默认展示',
    `adopt` Int(2) NOT NULL   DEFAULT 0 COMMENT '收录状态默认未收录',
    `agree_num` int(20) NOT NULL  DEFAULT 0  COMMENT '踩坑数默认0',
    `answer_num` int(20) NOT NULL   COMMENT '回答数默认0',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `answer`
-- ----------------------------
-- DROP TABLE IF EXISTS `answer`;
CREATE TABLE `answer` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `question_id` bigint(20) NOT NULL   COMMENT '问题id',
    `content` longtext NOT NULL   COMMENT '回答内容',
    `like_num` int(20) NOT NULL  DEFAULT 0  COMMENT '点赞数',
    `status` Int(2) NOT NULL   DEFAULT 1 COMMENT '回答状态默认展示',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `question_label_relation`
-- ----------------------------
-- DROP TABLE IF EXISTS `question_label_relation`;
CREATE TABLE `question_label_relation` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `question_id` bigint(20) NOT NULL   COMMENT '问题id',
    `label_id` bigint(20) NOT NULL   COMMENT '标签id',
    `create_by` bigint(20) NOT NULL   COMMENT '创建人',
    `create_at` bigint(20) NOT NULL   COMMENT '创建时间',
    `update_by` bigint(20) NOT NULL   COMMENT '更新人',
    `update_at` bigint(20) NOT NULL   COMMENT '更新时间',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for `class_subject`
-- ----------------------------
-- DROP TABLE IF EXISTS `class_subject`;
CREATE TABLE `class_subject` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业ID',
    `tid` bigint(20) NOT NULL   COMMENT '任务ID',
    `subject_name` text NOT NULL   COMMENT '课题名',
    `status` int NOT NULL   COMMENT '上下架状态 0：下架 1：上架',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20) NOT NULL   COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `class_team`
-- ----------------------------
-- DROP TABLE IF EXISTS `class_team`;
CREATE TABLE `class_team` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业ID',
    `uid` bigint(20) NOT NULL   COMMENT '任务ID',
    `live_number` varchar(20) NOT NULL   COMMENT '直播群号',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20) NOT NULL   COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




-- ----------------------------
-- Table structure for `class_timetable`
-- ----------------------------
-- DROP TABLE IF EXISTS `class_timetable`;
CREATE TABLE `class_timetable` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `arrange_date` bigint(20) NOT NULL   COMMENT '排课日期',
    `subject_id` bigint(20) NOT NULL   COMMENT '课题id',
    `teach_uid` bigint(20) NOT NULL   COMMENT '讲课ID',
    `speak_status` int NOT NULL   COMMENT '课程状态  1：预告 2：未审核 3：未评级 4：已评级',
    `level` int NOT NULL   COMMENT '评级  1:下品 2:中品 3:上品',
    `comment` text NOT NULL   COMMENT '评语',
    `status` int NOT NULL   COMMENT '上下架(精选)状态   0：下架 1：上架 2：深度思考删除后，小课堂也被假删除的状态',
    `leave_uid` varchar(300)    COMMENT '请假人id数组',
    `absent_uid` varchar(300)    COMMENT '旷课人id数组',
    `collection` int    COMMENT '收藏数',
    `love` int    COMMENT '点赞数',
    `read_count` int    COMMENT '收藏数',
    `ppt_url` text    COMMENT 'ppt链接',
    `video_url` text    COMMENT '视频链接',
    `content` text    COMMENT '讲课内容',
    `target_people` varchar(40)    COMMENT '目标人群',
    `expect` varchar(200)    COMMENT '课堂期望',
    `class_abstract` varchar(200)    COMMENT '课堂简介',
    `preview_img` text    COMMENT '预告图片',
    `is_delete` int    COMMENT '是否删除课表记录 0：不删除 1：删除 备注：课表删除后，不影响小课堂的展示',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20) NOT NULL   COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for `deep_think`
-- ----------------------------
-- DROP TABLE IF EXISTS `deep_think`;
CREATE TABLE `deep_think` (
    `id` bigint(20) NOT NULL   AUTO_INCREMENT  COMMENT '自增长ID',
    `oid` bigint(20) NOT NULL   COMMENT '职业ID',
    `tid` bigint(20) NOT NULL   COMMENT '任务ID',
    `name` text NOT NULL   COMMENT '',
    `create_by` bigint(20) NOT NULL   COMMENT '',
    `update_by` bigint(20) NOT NULL   COMMENT '',
    `update_at` bigint(20) NOT NULL   COMMENT '',
    `create_at` bigint(20) NOT NULL   COMMENT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8;




















