package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.UserTeamRelation;
import com.ptteng.common.skill.service.UserTeamRelationService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class UserTeamRelationServiceImpl extends BaseDaoServiceImpl implements UserTeamRelationService {

 

	private static final Log log = LogFactory.getLog(UserTeamRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserTeamRelation userTeamRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userTeamRelation);

		if (userTeamRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userTeamRelation.setCreateAt(currentTimeMillis);
		userTeamRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userTeamRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userTeamRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserTeamRelation> insertList(List<UserTeamRelation> userTeamRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userTeamRelationList == null ? "null" : userTeamRelationList.size()));
      
		List<UserTeamRelation> resultList = null;

		if (CollectionUtils.isEmpty(userTeamRelationList)) {
			return new ArrayList<UserTeamRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserTeamRelation userTeamRelation : userTeamRelationList) {
			userTeamRelation.setCreateAt(currentTimeMillis);
			userTeamRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserTeamRelation>) dao.batchSave(userTeamRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userTeamRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserTeamRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserTeamRelation userTeamRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userTeamRelation == null ? "null" : userTeamRelation.getId()));

		boolean result = false;

		if (userTeamRelation == null) {
			return true;
		}

		userTeamRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userTeamRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userTeamRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userTeamRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserTeamRelation> userTeamRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userTeamRelationList == null ? "null" : userTeamRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userTeamRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserTeamRelation userTeamRelation : userTeamRelationList) {
			userTeamRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userTeamRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userTeamRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userTeamRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserTeamRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserTeamRelation userTeamRelation = null;

		if (id == null) {
			return userTeamRelation;
		}

		try {
			userTeamRelation = (UserTeamRelation) dao.get(UserTeamRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userTeamRelation;		
		}	
		  
    	   
		@Override
		public List<UserTeamRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserTeamRelation> userTeamRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserTeamRelation>();
		}

		try {
			userTeamRelation = (List<UserTeamRelation>) dao.getList(UserTeamRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userTeamRelation == null ? "null" : userTeamRelation.size()));
    
		return userTeamRelation;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTeamRelationIdsByUidOrderByCreateAt(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTeamRelationIdsByUidOrderByCreateAt", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTeamRelationIdsByTidOrderByCreateAt(Long tid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,start,limit  : " + tid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTeamRelationIdsByTidOrderByCreateAt", new Object[] { tid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,start,limit)  : " + tid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUserTeamRelationIdsByTidAndUidOrderByCreateAt(Long tid,Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by tid,uid,start,limit  : " + tid+" , "+uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getUserTeamRelationIdsByTidAndUidOrderByCreateAt", new Object[] { tid,uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by tid,uid,start,limit)  : " + tid+" , "+uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTeamRelationIdsByUidOrderByCreateAt(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTeamRelationIdsByUidOrderByCreateAt", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTeamRelationIdsByTidOrderByCreateAt(Long tid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid  : " + tid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTeamRelationIdsByTidOrderByCreateAt", new Object[] { tid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid)  : " + tid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUserTeamRelationIdsByTidAndUidOrderByCreateAt(Long tid,Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by tid,uid  : " + tid+" , "+uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUserTeamRelationIdsByTidAndUidOrderByCreateAt", new Object[] { tid,uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by tid,uid)  : " + tid+" , "+uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getUserTeamRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserTeamRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserTeamRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserTeamRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserTeamRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

