package com.ptteng.common.skill.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.skill.model.Successor;
import com.ptteng.common.skill.service.SuccessorService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class SuccessorServiceImpl extends BaseDaoServiceImpl implements SuccessorService {

 

	private static final Log log = LogFactory.getLog(SuccessorServiceImpl.class);



		   
		@Override
		public Long insert(Successor successor)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + successor);

		if (successor == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		successor.setCreateAt(currentTimeMillis);
		successor.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(successor);
		} catch (DaoException e) {
			log.error(" insert wrong : " + successor);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Successor> insertList(List<Successor> successorList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (successorList == null ? "null" : successorList.size()));
      
		List<Successor> resultList = null;

		if (CollectionUtils.isEmpty(successorList)) {
			return new ArrayList<Successor>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Successor successor : successorList) {
			successor.setCreateAt(currentTimeMillis);
			successor.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Successor>) dao.batchSave(successorList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + successorList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Successor.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Successor successor)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (successor == null ? "null" : successor.getId()));

		boolean result = false;

		if (successor == null) {
			return true;
		}

		successor.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(successor);
		} catch (DaoException e) {
			log.error(" update wrong : " + successor);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + successor);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Successor> successorList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (successorList == null ? "null" : successorList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(successorList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Successor successor : successorList) {
			successor.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(successorList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + successorList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + successorList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Successor getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Successor successor = null;

		if (id == null) {
			return successor;
		}

		try {
			successor = (Successor) dao.get(Successor.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return successor;		
		}	
		  
    	   
		@Override
		public List<Successor> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Successor> successor = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Successor>();
		}

		try {
			successor = (List<Successor>) dao.getList(Successor.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (successor == null ? "null" : successor.size()));
    
		return successor;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByOidAndBranchId(Long oid,Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get uids by oid,branchId,start,limit  : " + oid+" , "+branchId+" , "+start+" , "+limit );
	  }
	 	List<Long> uidList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		uidList = dao.getIdList("getUidsByOidAndBranchId", new Object[] { oid,branchId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get uids  wrong by oid,branchId,start,limit)  : " + oid+" , "+branchId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get uids success : " + (uidList == null ? "null" : uidList.size()));
  }
		return uidList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSuccessorIdsByBranchId(Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by branchId,start,limit  : " + branchId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getSuccessorIdsByBranchId", new Object[] { branchId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by branchId,start,limit)  : " + branchId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getSuccessorIdsByUid(Long uid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getSuccessorIdsByUid", new Object[] { uid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit)  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getOidsByBranchId(Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get oids by branchId,start,limit  : " + branchId+" , "+start+" , "+limit );
	  }
	 	List<Long> oidList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		oidList = dao.getIdList("getOidsByBranchId", new Object[] { branchId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get oids  wrong by branchId,start,limit)  : " + branchId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get oids success : " + (oidList == null ? "null" : oidList.size()));
  }
		return oidList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByOid(Long oid,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get uids by oid,start,limit  : " + oid+" , "+start+" , "+limit );
	  }
	 	List<Long> uidList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		uidList = dao.getIdList("getUidsByOid", new Object[] { oid},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get uids  wrong by oid,start,limit)  : " + oid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get uids success : " + (uidList == null ? "null" : uidList.size()));
  }
		return uidList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getUidsByBranchId(Long branchId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get uids by branchId,start,limit  : " + branchId+" , "+start+" , "+limit );
	  }
	 	List<Long> uidList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		uidList = dao.getIdList("getUidsByBranchId", new Object[] { branchId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get uids  wrong by branchId,start,limit)  : " + branchId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get uids success : " + (uidList == null ? "null" : uidList.size()));
  }
		return uidList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getSuccessorIdByBranchIdAndUidAndOid(Long branchId,Long uid,Long oid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by branchId,uid,oid  : " + branchId+" , "+uid+" , "+oid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getSuccessorIdByBranchIdAndUidAndOid", new Object[] {branchId,uid,oid });
   } catch (DaoException e) {
			log.error(" get id wrong by branchId,uid,oid  : " + branchId+" , "+uid+" , "+oid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByOidAndBranchId(Long oid,Long branchId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count uids by oid,branchId  : " + oid+" , "+branchId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUidsByOidAndBranchId", new Object[] { oid,branchId});

   
   } catch (DaoException e) {
			log.error(" count uids  wrong by oid,branchId)  : " + oid+" , "+branchId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSuccessorIdsByBranchId(Long branchId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by branchId  : " + branchId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSuccessorIdsByBranchId", new Object[] { branchId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by branchId)  : " + branchId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countSuccessorIdsByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by uid  : " + uid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getSuccessorIdsByUid", new Object[] { uid});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by uid)  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countOidsByBranchId(Long branchId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count oids by branchId  : " + branchId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getOidsByBranchId", new Object[] { branchId});

   
   } catch (DaoException e) {
			log.error(" count oids  wrong by branchId)  : " + branchId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByOid(Long oid)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count uids by oid  : " + oid );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUidsByOid", new Object[] { oid});

   
   } catch (DaoException e) {
			log.error(" count uids  wrong by oid)  : " + oid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countUidsByBranchId(Long branchId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count uids by branchId  : " + branchId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getUidsByBranchId", new Object[] { branchId});

   
   } catch (DaoException e) {
			log.error(" count uids  wrong by branchId)  : " + branchId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getSuccessorIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getSuccessorIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countSuccessorIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getSuccessorIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getSuccessorIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

