package com.ptteng.common.skill.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.common.skill.model.Provinces;
import com.ptteng.common.skill.service.ProvincesService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ProvincesServiceImpl extends BaseDaoServiceImpl implements ProvincesService {

 

	private static final Log log = LogFactory.getLog(ProvincesServiceImpl.class);



		   
		@Override
		public Long insert(Provinces provinces)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + provinces);

		if (provinces == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		provinces.setCreateAt(currentTimeMillis);
		provinces.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(provinces);
		} catch (DaoException e) {
			log.error(" insert wrong : " + provinces);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Provinces> insertList(List<Provinces> provincesList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (provincesList == null ? "null" : provincesList.size()));
      
		List<Provinces> resultList = null;

		if (CollectionUtils.isEmpty(provincesList)) {
			return new ArrayList<Provinces>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Provinces provinces : provincesList) {
			provinces.setCreateAt(currentTimeMillis);
			provinces.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Provinces>) dao.batchSave(provincesList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + provincesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Provinces.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Provinces provinces)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (provinces == null ? "null" : provinces.getId()));

		boolean result = false;

		if (provinces == null) {
			return true;
		}

		provinces.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(provinces);
		} catch (DaoException e) {
			log.error(" update wrong : " + provinces);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + provinces);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Provinces> provincesList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (provincesList == null ? "null" : provincesList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(provincesList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Provinces provinces : provincesList) {
			provinces.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(provincesList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + provincesList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + provincesList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Provinces getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Provinces provinces = null;

		if (id == null) {
			return provinces;
		}

		try {
			provinces = (Provinces) dao.get(Provinces.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return provinces;		
		}	
		  
    	   
		@Override
		public List<Provinces> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Provinces> provinces = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Provinces>();
		}

		try {
			provinces = (List<Provinces>) dao.getList(Provinces.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (provinces == null ? "null" : provinces.size()));
    
		return provinces;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getProvincesIdByProvince(String province)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by province  : " + province );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getProvincesIdByProvince", new Object[] {province });
   } catch (DaoException e) {
			log.error(" get id wrong by province  : " + province );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getProvincesIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getProvincesIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countProvincesIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getProvincesIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getProvincesIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

