/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.mtwmsdk.utils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class MtWmUtils {
    public static void sigCheck(String url, Map<String, String> params, String appId, String secret) {
        SigPart sigPart = MtWmUtils.getSigPart(url, params);
        if (sigPart.getSig() == null) {
            throw new RuntimeException("sig is required");
        }
        Map<String, String> signParams = sigPart.getSignRelationParams();
        if (!signParams.containsKey("timestamp")) {
            throw new RuntimeException("timestamp is required");
        }
        if (!signParams.containsKey("app_id")) {
            throw new RuntimeException("app_id is required");
        }
        if (!appId.equals(signParams.get("app_id"))) {
            throw new RuntimeException("app_id is incorrect");
        }
        List<String> sortParams = MtWmUtils.getSortParams(signParams);
        String signature = DigestUtils.md5Hex((String)(sigPart.getUrl() + "?" + StringUtils.join(sortParams, (String)"&") + secret));
        if (!signature.equals(sigPart.getSig())) {
            throw new RuntimeException("sig is incorrect");
        }
    }

    public static List<String> getSortParams(Map<String, String> signParams) {
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry<String, String> entry : signParams.entrySet()) {
            String param = entry.getKey() + "=" + entry.getValue();
            params.add(param);
        }
        Collections.sort(params);
        return params;
    }

    public static Map<String, String> urlDecodeParams(Map<String, String> params) {
        HashMap<String, String> paramsTemp = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                paramsTemp.put(String.valueOf(entry.getKey()), URLDecoder.decode(String.valueOf(entry.getValue()), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("data decode incorrect");
            }
        }
        return paramsTemp;
    }

    private static SigPart getSigPart(String url, Map<String, String> params) {
        if (!url.contains("?")) {
            HashMap<String, String> signParams = new HashMap<String, String>();
            signParams.putAll(params);
            String sig = (String)signParams.remove("sig");
            SigPart sigPart = new SigPart();
            sigPart.setSig(sig);
            sigPart.setSignRelationParams(signParams);
            sigPart.setUrl(url);
            return sigPart;
        }
        String noQueryUrl = url.substring(0, url.indexOf("?"));
        String queryString = url.substring(url.indexOf("?") + 1, url.length());
        HashMap<String, String> signParams = new HashMap<String, String>();
        String sig = null;
        List<String> queryParts = Arrays.asList(StringUtils.split((String)queryString, (String)"&"));
        for (String queryPart : queryParts) {
            String[] kv = queryPart.split("=");
            if ("sig".equals(kv[0])) {
                sig = kv[1];
                continue;
            }
            signParams.put(kv[0], kv[1]);
        }
        signParams.putAll(params);
        SigPart sigPart = new SigPart();
        sigPart.setSig(sig);
        sigPart.setSignRelationParams(signParams);
        sigPart.setUrl(noQueryUrl);
        return sigPart;
    }

    public static class SigPart
    implements Serializable {
        Map<String, String> signRelationParams;
        String sig;
        String url;

        public Map<String, String> getSignRelationParams() {
            return this.signRelationParams;
        }

        public void setSignRelationParams(Map<String, String> signRelationParams) {
            this.signRelationParams = signRelationParams;
        }

        public String getSig() {
            return this.sig;
        }

        public void setSig(String sig) {
            this.sig = sig;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String toString() {
            return "SigPart{signRelationParams=" + this.signRelationParams + ", sig='" + this.sig + '\'' + ", url='" + this.url + '\'' + '}';
        }
    }
}

