/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.bdwmsdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.Cmd;
import com.jiabangou.bdwmsdk.model.CmdSign;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class CmdUtils {
    public static final String DATA = "data";
    public static final String API_URL = "http://api.waimai.baidu.com";
    public static final String VERSION = "2";
    public static final String BODY = "body";

    public static Cmd buildCmd(String source, String secret, String version, String cmdName, Object body) {
        Cmd cmd = new Cmd();
        cmd.setCmd(cmdName);
        cmd.setSource(source);
        cmd.setTicket(UUID.randomUUID().toString().toUpperCase());
        cmd.setTimestamp((int)(System.currentTimeMillis() / 1000L));
        cmd.setVersion(version);
        cmd.setBody(body);
        cmd.setSign(CmdUtils.createApiSignature(cmd, secret));
        return cmd;
    }

    public static String getResponseCmdName(String requestCmdName) {
        return "resp." + requestCmdName;
    }

    public static Cmd parseCmd(String jsonString, String source, String secret) throws BdWmErrorException {
        Cmd cmd = (Cmd)JSON.parseObject((String)jsonString, Cmd.class);
        if (cmd.getCmd() == null || cmd.getCmd().isEmpty()) {
            throw new BdWmErrorException(1, "cmd is required");
        }
        if (cmd.getSource() == null || cmd.getSource().isEmpty()) {
            throw new BdWmErrorException(1, "source is required");
        }
        if (!cmd.getSource().equals(source)) {
            throw new BdWmErrorException(1, "source is incorrect");
        }
        if (cmd.getSign() == null || cmd.getSign().isEmpty()) {
            throw new BdWmErrorException(1, "sign is required");
        }
        if (cmd.getTicket() == null || cmd.getTicket().isEmpty()) {
            throw new BdWmErrorException(1, "ticket is required");
        }
        if (cmd.getTimestamp() == 0) {
            throw new BdWmErrorException(1, "timestamp is required");
        }
        if (cmd.getVersion() == null || cmd.getVersion().isEmpty()) {
            throw new BdWmErrorException(1, "version is required");
        }
        if (!CmdUtils.checkSignature(cmd, secret, cmd.getSign())) {
            throw new BdWmErrorException(20114, "\u7b7e\u540d\u4e0d\u5339\u914d");
        }
        return cmd;
    }

    public static Cmd buildSuccessCmd(String source, String secret, String version, String cmdName, Object data) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(){
            {
                this.put("errno", 0);
                this.put("error", "success");
            }
        };
        if (data != null) {
            params.put(DATA, data);
        }
        return CmdUtils.buildCmd(source, secret, version, cmdName, params);
    }

    public static Cmd buildSuccessCmd(String source, String secret, String version, String cmdName) {
        return CmdUtils.buildSuccessCmd(source, secret, version, cmdName, null);
    }

    public static Cmd buildErrorCmd(String source, String secret, String version, String cmdName, final BdWmErrorException exception) {
        return CmdUtils.buildCmd(source, secret, version, cmdName, new LinkedHashMap<String, Object>(){
            {
                this.put("errno", exception.getCode());
                this.put("error", exception.getMessage());
            }
        });
    }

    public static Cmd buildErrorCmd(String source, String secret, String version, String cmdName, final Exception exception) {
        return CmdUtils.buildCmd(source, secret, version, cmdName, new LinkedHashMap<String, Object>(){
            {
                this.put("errno", -1);
                this.put("error", exception.getMessage());
            }
        });
    }

    public static String createApiSignature(Cmd cmd, String secret) {
        CmdSign cmdSign = new CmdSign(cmd, secret);
        String requestJson = JSONObject.toJSONString(CmdUtils.covertToSortedMap((Map<String, Object>)((JSONObject)JSON.toJSON((Object)cmdSign))));
        requestJson = requestJson.replace("/", "\\/");
        requestJson = CmdUtils.chinaToUnicode(requestJson);
        return DigestUtils.md5Hex((String)requestJson).toUpperCase();
    }

    public static SortedMap<String, Object> covertToSortedMap(Map<String, Object> map) {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>(map);
        for (Map.Entry entry : sortedMap.entrySet()) {
            if (entry.getValue() instanceof Map && !(entry.getValue() instanceof SortedMap)) {
                entry.setValue(CmdUtils.covertToSortedMap((Map)entry.getValue()));
                continue;
            }
            if (!(entry.getValue() instanceof List)) continue;
            ArrayList<SortedMap<String, Object>> newList = new ArrayList<SortedMap<String, Object>>();
            for (Object obj : (List)entry.getValue()) {
                if (obj instanceof Map && !(obj instanceof SortedMap)) {
                    newList.add(CmdUtils.covertToSortedMap((Map)obj));
                    continue;
                }
                newList.add((SortedMap<String, Object>)obj);
            }
            entry.setValue(newList);
        }
        return sortedMap;
    }

    public static boolean checkSignature(Cmd cmd, String secret, String signature) {
        return CmdUtils.createApiSignature(cmd, secret).equals(signature);
    }

    public static String chinaToUnicode(String str) {
        String result = "";
        for (int i = 0; i < str.length(); ++i) {
            char chr1 = str.charAt(i);
            result = chr1 >= '\u007f' ? result + "\\u" + StringUtils.leftPad((String)Integer.toHexString(chr1), (int)4, (String)"0") : result + str.charAt(i);
        }
        return result;
    }
}

