/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.bdwmsdk.api.impl;

import com.alibaba.fastjson.util.TypeUtils;
import com.jiabangou.bdwmsdk.api.ShopService;
import com.jiabangou.bdwmsdk.api.impl.BdWmBaseService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.Picture;
import com.jiabangou.bdwmsdk.model.Shop;
import com.jiabangou.bdwmsdk.model.ShopDetail;
import com.jiabangou.bdwmsdk.model.ShopDetailLite;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ShopServiceImpl
extends BdWmBaseService
implements ShopService {
    public static final String COMMAND_SHOP_CREATE = "shop.create";
    public static final String COMMAND_SHOP_UPDATE = "shop.update";
    public static final String COMMAND_SHOP_OFFLINE = "shop.offline";
    public static final String COMMAND_SHOP_OPEN = "shop.open";
    public static final String COMMAND_SHOP_CLOSE = "shop.close";
    public static final String COMMAND_DELIVERY_DELAY = "shop.delivery.delay";
    public static final String COMMAND_UPLOAD_PIC = "shop.pic.upload";
    public static final String COMMAND_SHOP_GET = "shop.get";
    public static final String COMMAND_SHOP_LIST = "shop.list";
    public static final String COMMAND_SHOP_ANNOUNCEMENT_SET = "shop.announcement.set";

    @Override
    public int create(Shop shop) throws BdWmErrorException {
        return this.execute(COMMAND_SHOP_CREATE, shop).getJSONObject("data").getIntValue("baidu_shop_id");
    }

    @Override
    public boolean update(Shop shop) throws BdWmErrorException {
        return this.execute(COMMAND_SHOP_UPDATE, shop).getBoolean("data");
    }

    @Override
    public void offline(final String shopId) throws BdWmErrorException {
        HashMap<String, String> bodyMap = new HashMap<String, String>(1){
            {
                super(x0);
                this.put("shop_id", shopId);
            }
        };
        this.execute(COMMAND_SHOP_OFFLINE, bodyMap);
    }

    @Override
    public void open(final String shopId) throws BdWmErrorException {
        HashMap<String, String> bodyMap = new HashMap<String, String>(1){
            {
                super(x0);
                this.put("shop_id", shopId);
            }
        };
        this.execute(COMMAND_SHOP_OPEN, bodyMap);
    }

    @Override
    public void close(final String shopId) throws BdWmErrorException {
        HashMap<String, String> bodyMap = new HashMap<String, String>(1){
            {
                super(x0);
                this.put("shop_id", shopId);
            }
        };
        this.execute(COMMAND_SHOP_CLOSE, bodyMap);
    }

    @Override
    public void setDeliverDelayTime(String shopId, int deliveryDelayTime) throws BdWmErrorException {
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>(2);
        bodyMap.put("delivery_delay_time", deliveryDelayTime);
        bodyMap.put("shop_id", shopId);
        this.execute(COMMAND_DELIVERY_DELAY, bodyMap);
    }

    @Override
    public boolean uploadIdentityPicture(String shopId, List<Picture> pictures) throws BdWmErrorException {
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>(2);
        bodyMap.put("pic", pictures);
        bodyMap.put("shop_id", shopId);
        return this.execute(COMMAND_UPLOAD_PIC, bodyMap).getBoolean("data");
    }

    @Override
    public ShopDetail getDetail(String shopId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(1);
        bodyMap.put("shop_id", shopId);
        try {
            return (ShopDetail)this.execute(COMMAND_SHOP_GET, bodyMap).getObject("data", ShopDetail.class);
        }
        catch (BdWmErrorException e) {
            if (20253 == e.getCode()) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public List<ShopDetailLite> gets() throws BdWmErrorException {
        return this.execute(COMMAND_SHOP_LIST, "").getJSONArray("data").stream().map(o -> (ShopDetailLite)TypeUtils.castToJavaBean((Object)o, ShopDetailLite.class)).collect(Collectors.toList());
    }

    @Override
    public void setAnnouncement(String shopId, String content) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(1);
        bodyMap.put("content", content);
        bodyMap.put("shop_id", shopId);
        this.execute(COMMAND_SHOP_ANNOUNCEMENT_SET, bodyMap);
    }
}

