/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.bdwmsdk.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jiabangou.bdwmsdk.api.OrderService;
import com.jiabangou.bdwmsdk.api.impl.BdWmBaseService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.Order;
import com.jiabangou.bdwmsdk.model.OrderDelivery;
import com.jiabangou.bdwmsdk.model.OrderDetail;
import com.jiabangou.bdwmsdk.model.OrderLite;
import com.jiabangou.bdwmsdk.model.Page;
import java.util.LinkedHashMap;

public class OrderServiceImpl
extends BdWmBaseService
implements OrderService {
    public static final String ORDER_CONFIRM = "order.confirm";
    public static final String ORDER_CANCEL = "order.cancel";
    public static final String ORDER_COMPLETE = "order.complete";
    public static final String ORDER_STATUS_GET = "order.status.get";
    public static final String ORDER_GET = "order.get";
    public static final String ORDER_LIST = "order.list";

    @Override
    public void confirm(String orderId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(1);
        bodyMap.put("order_id", orderId);
        this.execute(ORDER_CONFIRM, bodyMap);
    }

    @Override
    public void cancel(String orderId, int type, String reason) throws BdWmErrorException {
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>(3);
        bodyMap.put("order_id", orderId);
        bodyMap.put("reason", reason);
        bodyMap.put("type", type);
        this.execute(ORDER_CANCEL, bodyMap);
    }

    @Override
    public void complete(String orderId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(1);
        bodyMap.put("order_id", orderId);
        this.execute(ORDER_COMPLETE, bodyMap);
    }

    @Override
    public int getStatus(String orderId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(1);
        bodyMap.put("order_id", orderId);
        return this.execute(ORDER_STATUS_GET, bodyMap).getIntValue("status");
    }

    @Override
    public OrderDetail getOrderDetail(String orderId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(1);
        bodyMap.put("order_id", orderId);
        return (OrderDetail)this.execute(ORDER_GET, bodyMap).getObject("data", OrderDetail.class);
    }

    @Override
    public Page<OrderLite> getOrderLites(long startTime, long endTime) throws BdWmErrorException {
        LinkedHashMap<String, Long> bodyMap = new LinkedHashMap<String, Long>(2);
        bodyMap.put("end_time", endTime);
        bodyMap.put("start_time", startTime);
        JSONObject jsonObject = this.execute(ORDER_LIST, bodyMap);
        return (Page)JSON.parseObject((String)jsonObject.getJSONObject("data").toJSONString(), (TypeReference)new TypeReference<Page<OrderLite>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public OrderDelivery getOrderDelivery(String orderId) throws BdWmErrorException {
        OrderDetail orderDetail = this.getOrderDetail(orderId);
        Order order = orderDetail.getOrder();
        OrderDelivery orderDelivery = new OrderDelivery();
        orderDelivery.setPickup_time(order.getPickup_time());
        orderDelivery.setAtshop_time(order.getAtshop_time());
        orderDelivery.setConfirm_time(order.getConfirm_time());
        orderDelivery.setDelivery_phone(order.getDelivery_phone());
        orderDelivery.setDelivery_time(order.getDelivery_time());
        orderDelivery.setFinished_time(order.getFinished_time());
        return orderDelivery;
    }
}

