/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.bdwmsdk.api.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.util.TypeUtils;
import com.jiabangou.bdwmsdk.api.DishService;
import com.jiabangou.bdwmsdk.api.impl.BdWmBaseService;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.Category;
import com.jiabangou.bdwmsdk.model.CategoryGet;
import com.jiabangou.bdwmsdk.model.CategoryUpdate;
import com.jiabangou.bdwmsdk.model.Dish;
import com.jiabangou.bdwmsdk.model.DishDetail;
import com.jiabangou.bdwmsdk.model.DishProduct;
import com.jiabangou.bdwmsdk.model.DishReplaceBatch;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class DishServiceImpl
extends BdWmBaseService
implements DishService {
    public static final String COMMAND_DISH_CATEGORY_CREATE = "dish.category.create";
    public static final String COMMAND_DISH_CATEGORY_UPDATE = "dish.category.update";
    public static final String COMMAND_DISH_CATEGORY_GET = "dish.category.get";
    public static final String COMMAND_DISH_CATEGORY_ALL = "dish.category.all";
    public static final String COMMAND_DISH_GET = "dish.get";
    public static final String COMMAND_DISH_CREATE = "dish.create";
    public static final String COMMAND_DISH_UPDATE = "dish.update";
    public static final String COMMAND_DISH_SHOW = "dish.show";
    public static final String COMMAND_DISH_ONLINE = "dish.online";
    public static final String COMMAND_DISH_OFFLINE = "dish.offline";
    public static final String COMMAND_DISH_DELETE = "dish.delete";
    public static final String COMMAND_DISH_THRESHOLD_SET_V2 = "dish.threshold.setv2";
    public static final String COMMAND_DISH_REPLACE_BATCH = "dish.replace.batch";
    public static final String COMMAND_DISH_SALEOUT = "dish.saleout";

    @Override
    public long createCategory(Category category) throws BdWmErrorException {
        JSONArray object = this.execute(COMMAND_DISH_CATEGORY_CREATE, category).getJSONArray("data");
        return object.getJSONObject(0).getIntValue("id");
    }

    @Override
    public void updateCategory(CategoryUpdate categoryUpdate) throws BdWmErrorException {
        this.execute(COMMAND_DISH_CATEGORY_UPDATE, categoryUpdate);
    }

    @Override
    public Category getCategory(String shopId, String name) throws BdWmErrorException {
        CategoryGet categoryGet = new CategoryGet();
        categoryGet.setName(name);
        categoryGet.setShop_id(shopId);
        try {
            return (Category)TypeUtils.castToJavaBean((Object)this.execute(COMMAND_DISH_CATEGORY_GET, categoryGet).getJSONObject("data"), Category.class);
        }
        catch (BdWmErrorException e) {
            if (e.getCode() == 10205) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public List<Category> getAllCategory(final String shopId) throws BdWmErrorException {
        HashMap<String, String> bodyMap = new HashMap<String, String>(1){
            {
                super(x0);
                this.put("shop_id", shopId);
            }
        };
        return this.execute(COMMAND_DISH_CATEGORY_ALL, bodyMap).getJSONArray("data").stream().map(o -> (Category)TypeUtils.castToJavaBean((Object)o, Category.class)).collect(Collectors.toList());
    }

    @Override
    public void create(Dish dish) throws BdWmErrorException {
        this.execute(COMMAND_DISH_CREATE, dish);
    }

    @Override
    public void update(Dish dish) throws BdWmErrorException {
        this.execute(COMMAND_DISH_UPDATE, dish);
    }

    @Override
    public void online(String shopId, String dishId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(2);
        bodyMap.put("dish_id", dishId);
        bodyMap.put("shop_id", shopId);
        this.execute(COMMAND_DISH_ONLINE, bodyMap);
    }

    @Override
    public void offline(String shopId, String dishId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(2);
        bodyMap.put("dish_id", dishId);
        bodyMap.put("shop_id", shopId);
        this.execute(COMMAND_DISH_OFFLINE, bodyMap);
    }

    @Override
    public void delete(String shopId, String dishId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(2);
        bodyMap.put("dish_id", dishId);
        bodyMap.put("shop_id", shopId);
        this.execute(COMMAND_DISH_DELETE, bodyMap);
    }

    @Override
    public void saleout(String shopId, String dishId) throws BdWmErrorException {
        LinkedHashMap<String, String> bodyMap = new LinkedHashMap<String, String>(2);
        bodyMap.put("dish_id", dishId);
        bodyMap.put("shop_id", shopId);
        this.execute(COMMAND_DISH_SALEOUT, bodyMap);
    }

    @Override
    public void setThreshold(final String shopId, final String dishId, final int stock) throws BdWmErrorException {
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>(3){
            {
                super(x0);
                this.put("dish_id", dishId);
                this.put("shop_id", shopId);
                this.put("stock", stock);
            }
        };
        this.execute(COMMAND_DISH_THRESHOLD_SET_V2, bodyMap);
    }

    @Override
    public void replaceBatch(DishReplaceBatch dishReplaceBatch) throws BdWmErrorException {
        this.execute(COMMAND_DISH_REPLACE_BATCH, dishReplaceBatch);
    }

    @Override
    public List<DishProduct> gets(final String shopId) throws BdWmErrorException {
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>(1){
            {
                super(x0);
                this.put("shop_id", shopId);
            }
        };
        return this.execute(COMMAND_DISH_SHOW, bodyMap).getJSONArray("data").stream().map(o -> (DishProduct)TypeUtils.castToJavaBean((Object)o, DishProduct.class)).collect(Collectors.toList());
    }

    @Override
    public DishDetail get(final String shopId, final String dishId) throws BdWmErrorException {
        LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>(2){
            {
                super(x0);
                this.put("shop_id", shopId);
                this.put("dish_id", dishId);
            }
        };
        try {
            return (DishDetail)TypeUtils.castToJavaBean((Object)this.execute(COMMAND_DISH_GET, bodyMap).getJSONObject("data"), DishDetail.class);
        }
        catch (BdWmErrorException e) {
            if (e.getCode() == 10202) {
                return null;
            }
            throw e;
        }
    }
}

