/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.bdwmsdk.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.jiabangou.bdwmsdk.api.BdWmClient;
import com.jiabangou.bdwmsdk.api.BdWmConfigStorage;
import com.jiabangou.bdwmsdk.api.DishService;
import com.jiabangou.bdwmsdk.api.LogListener;
import com.jiabangou.bdwmsdk.api.OrderService;
import com.jiabangou.bdwmsdk.api.PushConsumer;
import com.jiabangou.bdwmsdk.api.ShopService;
import com.jiabangou.bdwmsdk.api.impl.DishServiceImpl;
import com.jiabangou.bdwmsdk.api.impl.OrderServiceImpl;
import com.jiabangou.bdwmsdk.api.impl.ShopServiceImpl;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.Cmd;
import com.jiabangou.bdwmsdk.model.OrderDelivery;
import com.jiabangou.bdwmsdk.model.OrderDetail;
import com.jiabangou.bdwmsdk.model.OrderStatusResult;
import com.jiabangou.bdwmsdk.utils.CmdUtils;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;

public class BdWmClientImpl
implements BdWmClient {
    private BdWmConfigStorage baiduWaimaiConfigStorage;
    private LogListener logListener;
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;
    private DishService dishService;
    private ShopService shopService;
    private OrderService orderService;
    private PushConsumer pushConsumer;

    @Override
    public void setBaiduWaimaiConfigStorage(BdWmConfigStorage baiduWaimaiConfigStorage) {
        this.baiduWaimaiConfigStorage = baiduWaimaiConfigStorage;
        String http_proxy_host = baiduWaimaiConfigStorage.getHttp_proxy_host();
        int http_proxy_port = baiduWaimaiConfigStorage.getHttp_proxy_port();
        String http_proxy_username = baiduWaimaiConfigStorage.getHttp_proxy_username();
        String http_proxy_password = baiduWaimaiConfigStorage.getHttp_proxy_password();
        HttpClientBuilder builder = HttpClients.custom();
        if (StringUtils.isNotBlank((String)http_proxy_host)) {
            if (StringUtils.isNotBlank((String)http_proxy_username)) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(http_proxy_host, http_proxy_port), (Credentials)new UsernamePasswordCredentials(http_proxy_username, http_proxy_password));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            this.httpProxy = new HttpHost(http_proxy_host, http_proxy_port);
        }
        this.httpClient = builder.build();
    }

    @Override
    public void setLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    @Override
    public void setPushConsumer(PushConsumer pushConsumer) {
        this.pushConsumer = pushConsumer;
    }

    @Override
    public Cmd pushHandle(String requestJsonString) {
        try {
            Cmd requestCmd = CmdUtils.parseCmd(requestJsonString, this.baiduWaimaiConfigStorage.getSource(), this.baiduWaimaiConfigStorage.getSecret());
            if (this.pushConsumer == null) {
                throw new BdWmErrorException(1, "pushConsumer does not implement");
            }
            Cmd responseCmd = null;
            if ("order.create".equals(requestCmd.getCmd())) {
                OrderDetail orderDetail = this.getOrderService().getOrderDetail(((JSONObject)requestCmd.getBody()).getJSONObject("order").getString("order_id"));
                final String sourceOrderId = this.pushConsumer.createOrder(orderDetail);
                HashMap<String, String> data = new HashMap<String, String>(){
                    {
                        this.put("source_order_id", sourceOrderId);
                    }
                };
                responseCmd = CmdUtils.buildSuccessCmd(this.baiduWaimaiConfigStorage.getSource(), this.baiduWaimaiConfigStorage.getSecret(), "2", CmdUtils.getResponseCmdName(requestCmd.getCmd()), data);
            } else if ("order.status.get".equals(requestCmd.getCmd())) {
                OrderStatusResult orderStatusResult = this.pushConsumer.getOrderStatus(((JSONObject)requestCmd.getBody()).getString("order_id"));
                responseCmd = CmdUtils.buildSuccessCmd(this.baiduWaimaiConfigStorage.getSource(), this.baiduWaimaiConfigStorage.getSecret(), "2", CmdUtils.getResponseCmdName(requestCmd.getCmd()), orderStatusResult);
            } else if ("order.status.push".equals(requestCmd.getCmd())) {
                JSONObject jsonObject = (JSONObject)requestCmd.getBody();
                String orderId = jsonObject.getString("order_id");
                int status = jsonObject.getIntValue("status");
                OrderDelivery orderDelivery = this.getOrderService().getOrderDelivery(orderId);
                this.pushConsumer.pushOrderStatus(orderId, status, orderDelivery);
                responseCmd = CmdUtils.buildSuccessCmd(this.baiduWaimaiConfigStorage.getSource(), this.baiduWaimaiConfigStorage.getSecret(), "2", CmdUtils.getResponseCmdName(requestCmd.getCmd()));
            }
            if (responseCmd != null) {
                this.logging(requestCmd.getCmd(), true, requestJsonString, JSONObject.toJSONString(responseCmd));
                return responseCmd;
            }
            throw new BdWmErrorException(1, "push cmd processer is not found.");
        }
        catch (BdWmErrorException e) {
            JSONObject jsonObject = JSONObject.parseObject((String)requestJsonString);
            Cmd responseCmd = CmdUtils.buildErrorCmd(this.baiduWaimaiConfigStorage.getSource(), this.baiduWaimaiConfigStorage.getSecret(), "2", CmdUtils.getResponseCmdName(jsonObject.getString("cmd")), e);
            this.logging(jsonObject.getString("cmd"), false, requestJsonString, JSONObject.toJSONString((Object)responseCmd));
            return responseCmd;
        }
    }

    private void logging(String cmd, boolean isSuccess, String request, String response) {
        if (this.logListener != null) {
            this.logListener.requestEvent(cmd, "POST", isSuccess, request, response);
        }
    }

    @Override
    public DishService getDishService() {
        if (this.dishService == null) {
            DishServiceImpl service = new DishServiceImpl();
            service.setHttpClient(this.httpClient);
            service.setHttpHost(this.httpProxy);
            service.setBdWmConfigStorage(this.baiduWaimaiConfigStorage);
            service.setLogListener(this.logListener);
            this.dishService = service;
            return this.dishService;
        }
        return this.dishService;
    }

    @Override
    public ShopService getShopService() {
        if (this.shopService == null) {
            ShopServiceImpl service = new ShopServiceImpl();
            service.setHttpClient(this.httpClient);
            service.setHttpHost(this.httpProxy);
            service.setBdWmConfigStorage(this.baiduWaimaiConfigStorage);
            service.setLogListener(this.logListener);
            this.shopService = service;
            return this.shopService;
        }
        return this.shopService;
    }

    @Override
    public OrderService getOrderService() {
        if (this.orderService == null) {
            OrderServiceImpl service = new OrderServiceImpl();
            service.setHttpClient(this.httpClient);
            service.setHttpHost(this.httpProxy);
            service.setBdWmConfigStorage(this.baiduWaimaiConfigStorage);
            service.setLogListener(this.logListener);
            this.orderService = service;
            return this.orderService;
        }
        return this.orderService;
    }
}

