/*
 * Decompiled with CFR 0.152.
 */
package com.jiabangou.bdwmsdk.api.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jiabangou.bdwmsdk.api.BdWmConfigStorage;
import com.jiabangou.bdwmsdk.api.BdWmService;
import com.jiabangou.bdwmsdk.api.LogListener;
import com.jiabangou.bdwmsdk.exception.BdWmErrorException;
import com.jiabangou.bdwmsdk.model.BdWmError;
import com.jiabangou.bdwmsdk.model.Cmd;
import com.jiabangou.bdwmsdk.utils.CmdUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdWmBaseService
implements BdWmService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdWmBaseService.class);
    public static final String HTTP_METHOD_POST = "POST";
    protected BdWmConfigStorage bdWmConfigStorage;
    protected LogListener logListener;
    protected HttpHost httpProxy;
    protected CloseableHttpClient httpClient;

    @Override
    public void setBdWmConfigStorage(BdWmConfigStorage bdWmConfigStorage) {
        this.bdWmConfigStorage = bdWmConfigStorage;
    }

    @Override
    public void setLogListener(LogListener logListener) {
        this.logListener = logListener;
    }

    private void logging(String cmd, boolean isSuccess, String request, String response) {
        if (this.logListener != null) {
            this.logListener.requestEvent(cmd, HTTP_METHOD_POST, isSuccess, request, response);
        }
    }

    @Override
    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void setHttpHost(HttpHost httpProxy) {
        this.httpProxy = httpProxy;
    }

    private Cmd createCmd(String cmdName, Object body) {
        return CmdUtils.buildCmd(this.bdWmConfigStorage.getSource(), this.bdWmConfigStorage.getSecret(), "2", cmdName, body);
    }

    protected JSONObject execute(String cmdName, Object body) throws BdWmErrorException {
        return this.execute(this.createCmd(cmdName, body));
    }

    private JSONObject execute(Cmd cmd) throws BdWmErrorException {
        try {
            JSONObject jsonObject = this.sawExecute(cmd);
            return jsonObject.getJSONObject("body");
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private JSONObject sawExecute(Cmd cmd) throws IOException, BdWmErrorException {
        JSONObject jsonObject;
        BdWmError error;
        HttpPost httpPost = new HttpPost("http://api.waimai.baidu.com");
        if (this.httpProxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.httpProxy).build();
            httpPost.setConfig(config);
        }
        String requestString = JSON.toJSONString((Object)cmd, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.SortField});
        httpPost.setEntity((HttpEntity)new StringEntity(requestString, Charset.forName("utf-8")));
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String resultContent = new BasicResponseHandler().handleResponse((HttpResponse)response);
        if (LOGGER.isInfoEnabled()) {
            String stringBuilder = "cmd:" + cmd.toString() + "\r\n" + "req:" + requestString + "\r\n" + "resp:" + resultContent;
            LOGGER.info(stringBuilder);
        }
        if ((error = BdWmError.fromJson(jsonObject = JSON.parseObject((String)resultContent))) != null) {
            this.logging(cmd.getCmd(), false, requestString, resultContent);
            throw new BdWmErrorException(error);
        }
        this.logging(cmd.getCmd(), true, requestString, resultContent);
        return jsonObject;
    }
}

