/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.AbstractMessageProcessor;

public class TextMessageProcessor
extends AbstractMessageProcessor {
    public TextMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    @Override
    protected Object[] extractPayload(Message msg) {
        try {
            if (!(msg instanceof TextMessage)) {
                throw new IllegalStateException("expecting JMS TextMessage: " + msg);
            }
            return new Object[]{((TextMessage)msg).getText()};
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        try {
            TextMessage message = session.createTextMessage();
            message.setText(String.valueOf(o));
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }
}

