/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.AbstractMessageProcessor;

public class ObjectMessageProcessor
extends AbstractMessageProcessor {
    public ObjectMessageProcessor(JMSBinding jmsBinding) {
        super(jmsBinding);
    }

    @Override
    protected Object[] extractPayload(Message msg) {
        try {
            Serializable o = ((ObjectMessage)msg).getObject();
            if (o != null && o.getClass().isArray()) {
                return (Object[])o;
            }
            return new Object[]{o};
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    @Override
    protected Message createJMSMessage(Session session, Object o) {
        try {
            if (!(o instanceof Serializable)) {
                throw new IllegalStateException("JMS ObjectMessage payload not Serializable: " + o);
            }
            ObjectMessage message = session.createObjectMessage();
            message.setObject((Serializable)o);
            return message;
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }
}

