/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import scallop.api.ScallopRemoteException;
import scallop.core.Observer;
import scallop.core.Resource;
import scallop.core.ResourceParser;
import scallop.core.ScallopClient;
import scallop.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import scallop.sca.binding.jms.provider.JMSResourceFactory;
import scallop.sca.binding.jms.provider.JMSResourceFactoryImpl;
import scallop.sca.binding.jms.provider.JMSResourceParser;

public class JMSResourceFactoryDynamicImpl
implements JMSResourceFactory,
Observer {
    List<JMSResourceFactoryImpl> resourceFactorys = new ArrayList<JMSResourceFactoryImpl>();
    String registryName;
    String registryCenter;
    String connectionFactoryName;
    String initialContextFactoryName;
    JMSBindingServiceBindingProvider bindingServiceBindingProvider;

    public void setBindingServiceBindingProvider(JMSBindingServiceBindingProvider bindingServiceBindingProvider) {
        this.bindingServiceBindingProvider = bindingServiceBindingProvider;
    }

    public JMSResourceFactoryDynamicImpl(String connectionFactoryName, String initialContextFactoryName, String registryCenter, String registryName) throws ScallopRemoteException {
        ScallopClient sc = ScallopClient.getInstance();
        this.registryName = registryName;
        this.connectionFactoryName = connectionFactoryName;
        this.initialContextFactoryName = initialContextFactoryName;
        this.registryCenter = sc.getRealRegistryCenter(registryCenter);
        sc.registerObserver((Observer)this);
        this.update();
    }

    @Override
    public void closeConnection() throws JMSException {
        this.resourceFactorys.get(0).closeConnection();
    }

    @Override
    public Destination createDestination(String jndiName) throws NamingException {
        return this.resourceFactorys.get(0).createDestination(jndiName);
    }

    @Override
    public Session createSession() throws JMSException, NamingException {
        return this.resourceFactorys.get(0).createSession();
    }

    @Override
    public Connection getConnection() throws NamingException, JMSException {
        return this.resourceFactorys.get(0).getConnection();
    }

    @Override
    public Destination lookupDestination(String destName) throws NamingException {
        return this.resourceFactorys.get(0).lookupDestination(destName);
    }

    @Override
    public void startConnection() throws JMSException, NamingException {
        this.resourceFactorys.get(0).startConnection();
    }

    public void update() throws ScallopRemoteException {
        Resource resource = ScallopClient.getInstance().getResource(this.registryCenter, this.registryName, (ResourceParser)new JMSResourceParser());
        if (resource.getResource().size() == 0) {
            throw new ScallopRemoteException("can not get resource. resource name:" + this.registryName);
        }
        ArrayList<String> jndiUrls = new ArrayList<String>(resource.getResource().size());
        ArrayList<String> newJndiUrls = new ArrayList<String>(resource.getResource().size());
        for (String res : resource.getResource()) {
            res = res.trim();
            jndiUrls.add(res);
            newJndiUrls.add(res);
        }
        for (JMSResourceFactoryImpl resourceFactory : this.resourceFactorys) {
            String jndiUrl = resourceFactory.getJndiURL();
            newJndiUrls.remove(jndiUrl);
        }
        if (newJndiUrls.size() > 0) {
            ArrayList<JMSResourceFactoryImpl> newResourceFactorys = new ArrayList<JMSResourceFactoryImpl>();
            for (String jndiUrl : newJndiUrls) {
                newResourceFactorys.add(new JMSResourceFactoryImpl(this.connectionFactoryName, this.initialContextFactoryName, jndiUrl));
            }
            List<JMSResourceFactoryImpl> oldResourceFactorys = this.resourceFactorys;
            this.resourceFactorys = newResourceFactorys;
            if (this.bindingServiceBindingProvider != null) {
                this.bindingServiceBindingProvider.start();
            }
            for (JMSResourceFactoryImpl rf : oldResourceFactorys) {
                try {
                    rf.closeConnection();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            oldResourceFactorys.clear();
        }
    }
}

