/*
 * Decompiled with CFR 0.152.
 */
package scallop.sca.binding.jms.provider;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.osoa.sca.ServiceRuntimeException;
import scallop.sca.binding.jms.impl.JMSBinding;
import scallop.sca.binding.jms.impl.JMSBindingException;
import scallop.sca.binding.jms.provider.JMSBindingServiceBindingProvider;
import scallop.sca.binding.jms.provider.JMSMessageProcessor;
import scallop.sca.binding.jms.provider.JMSMessageProcessorUtil;
import scallop.sca.binding.jms.provider.JMSResourceFactory;

@Deprecated
public class JMSBindingInvoker
implements Invoker,
DataExchangeSemantics {
    protected Operation operation;
    protected String operationName;
    protected JMSBinding jmsBinding;
    protected JMSResourceFactory jmsResourceFactory;
    protected JMSMessageProcessor requestMessageProcessor;
    protected JMSMessageProcessor responseMessageProcessor;
    protected Destination bindingRequestDest;
    protected Destination bindingReplyDest;
    protected RuntimeComponentReference reference;

    public JMSBindingInvoker(JMSBinding jmsBinding, Operation operation, JMSResourceFactory jmsResourceFactory, RuntimeComponentReference reference) {
        this.operation = operation;
        this.operationName = operation.getName();
        this.jmsBinding = jmsBinding;
        this.jmsResourceFactory = jmsResourceFactory;
        this.reference = reference;
        this.requestMessageProcessor = JMSMessageProcessorUtil.getRequestMessageProcessor(jmsBinding);
        this.responseMessageProcessor = JMSMessageProcessorUtil.getResponseMessageProcessor(jmsBinding);
        try {
            this.bindingRequestDest = this.lookupDestination();
            this.bindingReplyDest = this.lookupResponseDestination();
        }
        catch (NamingException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    protected Destination lookupDestination() throws NamingException, JMSBindingException {
        return this.lookupDestinationQueue(false);
    }

    protected Destination lookupResponseDestination() throws NamingException, JMSBindingException {
        return this.lookupDestinationQueue(true);
    }

    protected Destination lookupDestinationQueue(boolean isReponseQueue) throws NamingException, JMSBindingException {
        String qCreateMode;
        String queueType;
        String queueName;
        if (isReponseQueue) {
            queueName = this.jmsBinding.getResponseDestinationName();
            queueType = "JMS Response Destination ";
            qCreateMode = this.jmsBinding.getResponseDestinationCreate();
            if ("NORESPONSEDESTINATION".equals(queueName)) {
                return null;
            }
        } else {
            queueName = this.jmsBinding.getDestinationName();
            queueType = "JMS Destination ";
            qCreateMode = this.jmsBinding.getDestinationCreate();
        }
        Destination dest = this.jmsResourceFactory.lookupDestination(queueName);
        if (qCreateMode.equals("always")) {
            if (dest != null) {
                throw new JMSBindingException(String.valueOf(queueType) + queueName + " already exists but has create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
            }
            dest = this.jmsResourceFactory.createDestination(queueName);
        } else if (qCreateMode.equals("ifnotexist")) {
            if (dest == null) {
                dest = this.jmsResourceFactory.createDestination(queueName);
            }
        } else if (qCreateMode.equals("never") && dest == null) {
            throw new JMSBindingException(String.valueOf(queueType) + queueName + " not found but create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
        }
        if (dest == null) {
            throw new JMSBindingException(String.valueOf(queueType) + queueName + " not found with create mode of \"" + qCreateMode + "\" while registering binding " + this.jmsBinding.getName() + " invoker");
        }
        return dest;
    }

    public Message invoke(Message tuscanyMsg) {
        try {
            Object resp = this.invokeTarget(tuscanyMsg);
            tuscanyMsg.setBody(resp);
        }
        catch (InvocationTargetException e) {
            tuscanyMsg.setFaultBody((Object)e.getCause());
        }
        catch (ServiceRuntimeException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                if (e.getCause().getCause() instanceof RuntimeException) {
                    tuscanyMsg.setFaultBody((Object)e.getCause());
                } else {
                    tuscanyMsg.setFaultBody((Object)e.getCause().getCause());
                }
            } else {
                tuscanyMsg.setFaultBody((Object)e);
            }
        }
        catch (Throwable e) {
            tuscanyMsg.setFaultBody((Object)e);
        }
        return tuscanyMsg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object invokeTarget(Message tuscanyMsg) throws InvocationTargetException {
        try {
            Session session = this.jmsResourceFactory.createSession();
            try {
                Destination replyToDest = this.getReplyToDestination(session);
                javax.jms.Message requestMsg = this.sendRequest(tuscanyMsg, session, replyToDest);
                if (replyToDest == null) {
                    return null;
                }
                javax.jms.Message replyMsg = this.receiveReply(session, replyToDest, requestMsg.getJMSMessageID());
                Object[] response = (Object[])this.responseMessageProcessor.extractPayloadFromJMSMessage(replyMsg);
                Object object = response != null && response.length > 0 ? response[0] : null;
                return object;
            }
            finally {
                session.close();
            }
        }
        catch (JMSException e) {
            throw new InvocationTargetException(e);
        }
        catch (NamingException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected Destination getReplyToDestination(Session session) throws JMSException, JMSBindingException, NamingException {
        Object replyToDest = this.operation.isNonBlocking() ? null : (this.bindingReplyDest != null ? this.bindingReplyDest : session.createTemporaryQueue());
        return replyToDest;
    }

    protected javax.jms.Message sendRequest(Message tuscanyMsg, Session session, Destination replyToDest) throws JMSException, JMSBindingException, NamingException {
        javax.jms.Message requestMsg = this.requestMessageProcessor.insertPayloadIntoJMSMessage(session, tuscanyMsg.getBody());
        this.setHeaders(tuscanyMsg, requestMsg);
        requestMsg.setJMSReplyTo(replyToDest);
        Destination requestDest = this.getRequestDestination(tuscanyMsg, session);
        MessageProducer producer = session.createProducer(requestDest);
        if (this.jmsBinding.getOperationJMSTimeToLive(this.operationName) != null) {
            producer.setTimeToLive(this.jmsBinding.getOperationJMSTimeToLive(this.operationName).longValue());
        }
        try {
            producer.send(requestMsg);
        }
        finally {
            producer.close();
        }
        return requestMsg;
    }

    protected Destination getRequestDestination(Message tuscanyMsg, Session session) throws JMSBindingException, NamingException, JMSException {
        String toURI;
        Object requestDestination = this.reference.isCallback() ? ((toURI = tuscanyMsg.getTo().getURI()) != null && toURI.startsWith("jms:") ? session.createQueue(toURI.substring(4)) : this.lookupDestination()) : this.bindingRequestDest;
        return requestDestination;
    }

    protected void setHeaders(Message tuscanyMsg, javax.jms.Message jmsMsg) throws JMSException {
        this.requestMessageProcessor.setOperationName(this.jmsBinding.getNativeOperationName(this.operationName), jmsMsg);
        for (String propName : this.jmsBinding.getPropertyNames()) {
            Object value = this.jmsBinding.getProperty(propName);
            jmsMsg.setObjectProperty(propName, value);
        }
        Map operationProperties = this.jmsBinding.getOperationProperties(this.operationName);
        if (operationProperties != null) {
            for (String propName : operationProperties.keySet()) {
                Object value = operationProperties.get(propName);
                jmsMsg.setObjectProperty(propName, value);
            }
        }
    }

    protected boolean hasCallback() {
        JavaInterface jiface;
        return this.operation.getInterface() instanceof JavaInterface && (jiface = (JavaInterface)this.operation.getInterface()).getCallbackClass() != null;
    }

    protected javax.jms.Message receiveReply(Session session, Destination replyToDest, String requestMsgId) throws JMSException, NamingException {
        javax.jms.Message replyMsg;
        String msgSelector = "JMSCorrelationID = '" + requestMsgId + "'";
        MessageConsumer consumer = session.createConsumer(replyToDest, msgSelector);
        long receiveWait = this.jmsBinding.getOperationJMSTimeToLive(this.operationName) != null ? this.jmsBinding.getOperationJMSTimeToLive(this.operationName) * 2L : 20000L;
        try {
            this.jmsResourceFactory.startConnection();
            replyMsg = consumer.receive(receiveWait);
        }
        finally {
            consumer.close();
        }
        if (replyMsg == null) {
            throw new JMSBindingException("No reply message received on " + replyToDest + " for message id " + requestMsgId);
        }
        return replyMsg;
    }

    protected String getCallbackDestinationName(RuntimeComponentReference reference) {
        RuntimeComponentService s = (RuntimeComponentService)reference.getCallbackService();
        JMSBinding b = (JMSBinding)s.getBinding(JMSBinding.class);
        if (b != null) {
            JMSBindingServiceBindingProvider bp = (JMSBindingServiceBindingProvider)s.getBindingProvider((Binding)b);
            return bp.getDestinationName();
        }
        return null;
    }

    public boolean allowsPassByReference() {
        return true;
    }
}

