package com.ptteng.wealth.user.service.impl;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.gemantic.dal.id.util.SequenceService;
import com.ptteng.wealth.consign.constant.GlobalConstant;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.AutoDocBailRechargeIn;
import com.ptteng.wealth.consign.model.in.BindingBankIn;
import com.ptteng.wealth.consign.model.out.AutoDocBailRechargeOut;
import com.ptteng.wealth.consign.model.out.BindingBank;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.service.PersonService;
import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.User;
import com.ptteng.wealth.user.service.UserService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component("UserService")
public class UserServiceImpl extends BaseDaoServiceImpl implements UserService {


    private static final Log log = LogFactory.getLog(UserServiceImpl.class);

    private PersonService personService;


    private FundService fundService;


    private AccountService accountService;


    private UserAccountRelationService userAccountRelationService;

    private ConsignmentService consignmentService;

    public PersonService getPersonService() {
        return personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public FundService getFundService() {
        return fundService;
    }

    public void setFundService(FundService fundService) {
        this.fundService = fundService;
    }

    public AccountService getAccountService() {
        return accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public UserAccountRelationService getUserAccountRelationService() {
        return userAccountRelationService;
    }

    public void setUserAccountRelationService(UserAccountRelationService userAccountRelationService) {
        this.userAccountRelationService = userAccountRelationService;
    }

    //代销的支付接口
    @Override
    public boolean pay(Long userId, BigDecimal payMoney) throws ServiceException, ServiceDaoException {

        boolean bPay = false;

        User user = getObjectById(userId);

        //第一步： 找到用户绑定的主卡
        BindingBank bindingBank = null;
        try {
            BindingBankIn bindingBankIn = new BindingBankIn();
            bindingBankIn.setFunctionId(9534);
            bindingBankIn.setUserId("1980120910");
            bindingBankIn.setFundAccount(880294775);
            bindingBankIn.setBranchNo(GlobalConstant.BRANCH_NO);
            List<BindingBank> bindingBanks = consignmentService.getBindingBanks(bindingBankIn);
            for (BindingBank bindingBank1 : bindingBanks) {
                if (bindingBank1.getMainFlag().equals("1")) {
                    bindingBank = bindingBank1;
                    break;
                }
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        //第二步： 调用代销接口支付
        AutoDocBailRechargeIn organBindCardIn = new AutoDocBailRechargeIn();
        organBindCardIn.setFunctionId(9751);
        organBindCardIn.setUserId(user.getId() + "");
        organBindCardIn.setFundAccount(user.getFundAccount());
        organBindCardIn.setPassword(user.getPayPwd());
        organBindCardIn.setBranchNo(GlobalConstant.BRANCH_NO);
        organBindCardIn.setFundAccountG(user.getFundAccount());
        organBindCardIn.setFundAccountB(user.getFundAccount());
        organBindCardIn.setOpbusinessFlag("8035");
        organBindCardIn.setOccurBalanceG(payMoney);
        organBindCardIn.setTiedCardType("0");
        organBindCardIn.setMoneyType("1");
        organBindCardIn.setFundCompany(GlobalConstant.FUND_COMPANY);
        organBindCardIn.setFundCode(990006 + "");
        organBindCardIn.setPayType("0");
        organBindCardIn.setChannelResource("");
        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        organBindCardIn.setBankNoDk(bindingBank.getBankNo());
        organBindCardIn.setBankAccountDk(bindingBank.getBankAccount());
        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
        try {
            AutoDocBailRechargeOut autoDocBailRechargeOut = consignmentService.autoDocBailRecharge(organBindCardIn);
            log.info(" pay result : " + autoDocBailRechargeOut);
            if (0 == autoDocBailRechargeOut.getErrorNo()) {
                bPay = true;
            }
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return bPay;
    }

    @Override
    public Long insert(User user) throws ServiceException, ServiceDaoException {

        log.info(" insert data : " + user);
        if (user == null) {
            return null;
        }
        Long result = null;
        try {
            long currentTimeMillis = System.currentTimeMillis();
            user.setCreateAt(currentTimeMillis);
            user.setUpdateAt(currentTimeMillis);
            result = (Long) dao.save(user);
            log.info(" 创建用户:" + user.getId() + "同步信息表流程 ");

            log.info("==========第二步：生成资产信息表==========");
            Fund fund = new Fund();
            fund.setId(result);
            Long fundId =  fundService.insert(fund);
            log.info("  fundId = "+fundId);

            log.info("==========第三步：生成开磷账户信息表==========");
            List<Long> ids = accountService.getAccountIds(0, Integer.MAX_VALUE);
            List<Account> accounts = accountService.getObjectsByIds(ids);
            log.info("==========第四步：插入用户信息表==========");
            UserAccountRelation userAccountRelation = new UserAccountRelation();
            for (Account account : accounts) {
                userAccountRelation.setUserId(user.getId());
                userAccountRelation.setAccountCode(account.getAccCode());
                userAccountRelation.setAccountId(account.getId());
                userAccountRelation.setMoney(new BigDecimal("0"));
                userAccountRelationService.insert(userAccountRelation);
            }
            log.info("==========第五步：插入用户信息表==========");

        } catch (DaoException e) {
            log.error(" insert wrong : " + user);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }

    @Override
    public Long insertUser(User user) throws ServiceException, ServiceDaoException {
        log.info(" insert data : " + user);
        if (user == null) {
            return null;
        }
        Long result = null;
        try {
            long currentTimeMillis = System.currentTimeMillis();
            user.setCreateAt(currentTimeMillis);
            user.setUpdateAt(currentTimeMillis);

            result = (Long) dao.save(user);
        } catch (DaoException e) {
            log.error(" insert wrong : " + user);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;

        }

    @Override
    public Long getLatestUserId() throws ServiceException, ServiceDaoException {
        return SequenceService.getInstance().nextValue("wealthUser");
    }


    @Override
    public List<User> insertList(List<User> userList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userList == null ? "null" : userList.size()));

        List<User> resultList = null;

        if (CollectionUtils.isEmpty(userList)) {
            return new ArrayList<User>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (User user : userList) {
            user.setCreateAt(currentTimeMillis);
            user.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<User>) dao.batchSave(userList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(User.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(User user) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (user == null ? "null" : user.getId()));

        boolean result = false;

        if (user == null) {
            return true;
        }
        user.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(user);
        } catch (DaoException e) {
            log.error(" update wrong : " + user);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + user);
        }
        return result;
    }


    @Override
    public boolean updateList(List<User> userList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userList == null ? "null" : userList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (User user : userList) {
            user.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userList.size());

        return result;
    }


    @Override
    public User getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        User user = null;

        if (id == null) {
            return user;
        }

        try {
            user = (User) dao.get(User.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return user;
    }


    @Override
    public List<User> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<User> user = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<User>();
        }

        try {
            user = (List<User>) dao.getList(User.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (user == null ? "null" : user.size()));

        return user;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserIdsByType", new Object[]{type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserIdsByType(Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by type  : " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getUserIdsByType", new Object[]{type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by type)  : " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserIdByMobile(String mobile) throws ServiceException, ServiceDaoException {

        log.info(" get id by mobile  : " + mobile);
        Long id = null;
        // TODO 参数检查!
        try {
            id = (Long) dao.getMapping("getUserIdByMobile", new Object[]{mobile});
        } catch (DaoException e) {
            log.error(" get id wrong by mobile  : " + mobile);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserIdByKailinCode(String kailinCode) throws ServiceException, ServiceDaoException {

        log.info(" get id by kailinCode  : " + kailinCode);
        Long id = null;
        // TODO 参数检查!
        try {
            id = (Long) dao.getMapping("getUserIdByKailinCode", new Object[]{kailinCode});
        } catch (DaoException e) {
            log.error(" get id wrong by kailinCode  : " + kailinCode);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }

    public ConsignmentService getConsignmentService() {
        return consignmentService;
    }

    public void setConsignmentService(ConsignmentService consignmentService) {
        this.consignmentService = consignmentService;
    }
}

