package com.ptteng.wealth.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.UserOpenidRelation;
import com.ptteng.wealth.user.service.UserOpenidRelationService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.stereotype.Component;


@Component("UserOpenidRelationService")
public class UserOpenidRelationServiceImpl extends BaseDaoServiceImpl implements UserOpenidRelationService {


    private static final Log log = LogFactory.getLog(UserOpenidRelationServiceImpl.class);


    @Override
    public Long insert(UserOpenidRelation userOpenidRelation) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userOpenidRelation);

        if (userOpenidRelation == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userOpenidRelation.setCreateAt(currentTimeMillis);
        userOpenidRelation.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userOpenidRelation);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userOpenidRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserOpenidRelation> insertList(List<UserOpenidRelation> userOpenidRelationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userOpenidRelationList == null ? "null" : userOpenidRelationList.size()));

        List<UserOpenidRelation> resultList = null;

        if (CollectionUtils.isEmpty(userOpenidRelationList)) {
            return new ArrayList<UserOpenidRelation>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOpenidRelation userOpenidRelation : userOpenidRelationList) {
            userOpenidRelation.setCreateAt(currentTimeMillis);
            userOpenidRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserOpenidRelation>) dao.batchSave(userOpenidRelationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userOpenidRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserOpenidRelation.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserOpenidRelation userOpenidRelation) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userOpenidRelation == null ? "null" : userOpenidRelation.getId()));

        boolean result = false;

        if (userOpenidRelation == null) {
            return true;
        }

        userOpenidRelation.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userOpenidRelation);
        } catch (DaoException e) {
            log.error(" update wrong : " + userOpenidRelation);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userOpenidRelation);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserOpenidRelation> userOpenidRelationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userOpenidRelationList == null ? "null" : userOpenidRelationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userOpenidRelationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOpenidRelation userOpenidRelation : userOpenidRelationList) {
            userOpenidRelation.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userOpenidRelationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userOpenidRelationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userOpenidRelationList.size());

        return result;
    }


    @Override
    public UserOpenidRelation getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserOpenidRelation userOpenidRelation = null;

        if (id == null) {
            return userOpenidRelation;
        }

        try {
            userOpenidRelation = (UserOpenidRelation) dao.get(UserOpenidRelation.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userOpenidRelation;
    }


    @Override
    public List<UserOpenidRelation> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserOpenidRelation> userOpenidRelation = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOpenidRelation>();
        }

        try {
            userOpenidRelation = (List<UserOpenidRelation>) dao.getList(UserOpenidRelation.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userOpenidRelation == null ? "null" : userOpenidRelation.size()));

        return userOpenidRelation;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserOpenidRelationIdByOpenidAndStatus(String openid, String status) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by openid,status  : " + openid + " , " + status);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getUserOpenidRelationIdByOpenidAndStatus", new Object[]{openid, status});
        } catch (DaoException e) {
            log.error(" get id wrong by openid,status  : " + openid + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }

    @Override
    public Long getUserOpenidRelationIdByUidAndType(Long uid, String type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,type  : " + uid + " , " + type);
        }
        Long id = null;
        // TODO 参数检查!
        try {
            id = (Long) dao.getMapping("getUserOpenidRelationIdByUidAndType", new Object[]{uid, type});
        } catch (DaoException e) {
            log.error(" get id wrong by uid,type  : " + uid + " , " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getUserOpenidRelationIdByTypeId(Long typeId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by typeId  : " + typeId);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getUserOpenidRelationIdByTypeId", new Object[]{typeId});
        } catch (DaoException e) {
            log.error(" get id wrong by typeId  : " + typeId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    @Override
    public List<Long> getUserOpenidRelationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOpenidRelationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserOpenidRelationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserOpenidRelationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserOpenidRelationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

