package com.ptteng.wealth.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.ScoreHistory;
import com.ptteng.wealth.user.service.ScoreHistoryService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class ScoreHistoryServiceImpl extends BaseDaoServiceImpl implements ScoreHistoryService {

 

	private static final Log log = LogFactory.getLog(ScoreHistoryServiceImpl.class);



		   
		@Override
		public Long insert(ScoreHistory scoreHistory)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + scoreHistory);

		if (scoreHistory == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		scoreHistory.setCreateAt(currentTimeMillis);
		scoreHistory.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(scoreHistory);
		} catch (DaoException e) {
			log.error(" insert wrong : " + scoreHistory);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<ScoreHistory> insertList(List<ScoreHistory> scoreHistoryList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (scoreHistoryList == null ? "null" : scoreHistoryList.size()));
      
		List<ScoreHistory> resultList = null;

		if (CollectionUtils.isEmpty(scoreHistoryList)) {
			return new ArrayList<ScoreHistory>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ScoreHistory scoreHistory : scoreHistoryList) {
			scoreHistory.setCreateAt(currentTimeMillis);
			scoreHistory.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<ScoreHistory>) dao.batchSave(scoreHistoryList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + scoreHistoryList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(ScoreHistory.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(ScoreHistory scoreHistory)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (scoreHistory == null ? "null" : scoreHistory.getId()));

		boolean result = false;

		if (scoreHistory == null) {
			return true;
		}

		scoreHistory.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(scoreHistory);
		} catch (DaoException e) {
			log.error(" update wrong : " + scoreHistory);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + scoreHistory);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<ScoreHistory> scoreHistoryList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (scoreHistoryList == null ? "null" : scoreHistoryList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(scoreHistoryList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (ScoreHistory scoreHistory : scoreHistoryList) {
			scoreHistory.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(scoreHistoryList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + scoreHistoryList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + scoreHistoryList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public ScoreHistory getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		ScoreHistory scoreHistory = null;

		if (id == null) {
			return scoreHistory;
		}

		try {
			scoreHistory = (ScoreHistory) dao.get(ScoreHistory.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return scoreHistory;		
		}	
		  
    	   
		@Override
		public List<ScoreHistory> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<ScoreHistory> scoreHistory = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<ScoreHistory>();
		}

		try {
			scoreHistory = (List<ScoreHistory>) dao.getList(ScoreHistory.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (scoreHistory == null ? "null" : scoreHistory.size()));
    
		return scoreHistory;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Long  getScoreHistoryIdByUid(Long uid)throws ServiceException, ServiceDaoException{
		
		      if(log.isInfoEnabled()){
	  log.info(" get id by uid  : " + uid );
	  }
	  Long id = null;
	
      // TODO 参数检查!
      
	try {
		
	
	
        id = (Long) dao.getMapping("getScoreHistoryIdByUid", new Object[] {uid });
   } catch (DaoException e) {
			log.error(" get id wrong by uid  : " + uid );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get id success : " + id);
   }
		return id;
        
	
	
	
	
	}
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getScoreHistoryIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getScoreHistoryIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countScoreHistoryIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getScoreHistoryIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getScoreHistoryIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

