package com.ptteng.wealth.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.Person;
import com.ptteng.wealth.user.service.PersonService;



import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class PersonServiceImpl extends BaseDaoServiceImpl implements PersonService {

 

	private static final Log log = LogFactory.getLog(PersonServiceImpl.class);



		   
		@Override
		public Long insert(Person person)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + person);

		if (person == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		person.setCreateAt(currentTimeMillis);
		person.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(person);
		} catch (DaoException e) {
			log.error(" insert wrong : " + person);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Person> insertList(List<Person> personList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (personList == null ? "null" : personList.size()));
      
		List<Person> resultList = null;

		if (CollectionUtils.isEmpty(personList)) {
			return new ArrayList<Person>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Person person : personList) {
			person.setCreateAt(currentTimeMillis);
			person.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Person>) dao.batchSave(personList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + personList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Person.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Person person)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (person == null ? "null" : person.getId()));

		boolean result = false;

		if (person == null) {
			return true;
		}

		person.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(person);
		} catch (DaoException e) {
			log.error(" update wrong : " + person);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + person);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Person> personList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (personList == null ? "null" : personList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(personList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Person person : personList) {
			person.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(personList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + personList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + personList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Person getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Person person = null;

		if (id == null) {
			return person;
		}

		try {
			person = (Person) dao.get(Person.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return person;		
		}	
		  
    	   
		@Override
		public List<Person> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Person> person = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Person>();
		}

		try {
			person = (List<Person>) dao.getList(Person.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (person == null ? "null" : person.size()));
    
		return person;	
		}	
		  
    	
		
	
	
		
	
		
	
	
	
		
	@Override
	public List<Long> getPersonIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getPersonIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countPersonIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getPersonIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getPersonIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

