package com.ptteng.wealth.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.PersonApply;
import com.ptteng.wealth.user.service.PersonApplyService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;


public class PersonApplyServiceImpl extends BaseDaoServiceImpl implements PersonApplyService {


    private static final Log log = LogFactory.getLog(PersonApplyServiceImpl.class);


    @Override
    public Long insert(PersonApply personApply) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + personApply);

        if (personApply == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        personApply.setCreateAt(currentTimeMillis);
        personApply.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(personApply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + personApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<PersonApply> insertList(List<PersonApply> personApplyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (personApplyList == null ? "null" : personApplyList.size()));

        List<PersonApply> resultList = null;

        if (CollectionUtils.isEmpty(personApplyList)) {
            return new ArrayList<PersonApply>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (PersonApply personApply : personApplyList) {
            personApply.setCreateAt(currentTimeMillis);
            personApply.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<PersonApply>) dao.batchSave(personApplyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + personApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(PersonApply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(PersonApply personApply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (personApply == null ? "null" : personApply.getId()));

        boolean result = false;

        if (personApply == null) {
            return true;
        }

        personApply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(personApply);
        } catch (DaoException e) {
            log.error(" update wrong : " + personApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + personApply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<PersonApply> personApplyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (personApplyList == null ? "null" : personApplyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(personApplyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (PersonApply personApply : personApplyList) {
            personApply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(personApplyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + personApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + personApplyList.size());

        return result;
    }


    @Override
    public PersonApply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        PersonApply personApply = null;

        if (id == null) {
            return personApply;
        }

        try {
            personApply = (PersonApply) dao.get(PersonApply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return personApply;
    }


    @Override
    public List<PersonApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<PersonApply> personApply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<PersonApply>();
        }

        try {
            personApply = (List<PersonApply>) dao.getList(PersonApply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (personApply == null ? "null" : personApply.size()));

        return personApply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getPersonApplyIdByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by uid  : " + uid);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getPersonApplyIdByUid", new Object[]{uid});
        } catch (DaoException e) {
            log.error(" get id wrong by uid  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    @Override
    public List<Long> getPersonApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPersonApplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countPersonApplyIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getPersonApplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getPersonApplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

