package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.user.model.PersonApplyRecord;
import com.ptteng.wealth.user.service.PersonApplyRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class PersonApplyRecordServiceImpl extends BaseDaoServiceImpl implements PersonApplyRecordService {

 

	private static final Log log = LogFactory.getLog(PersonApplyRecordServiceImpl.class);



		   
		@Override
		public Long insert(PersonApplyRecord personApplyRecord)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + personApplyRecord);

		if (personApplyRecord == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		personApplyRecord.setCreateAt(currentTimeMillis);
		personApplyRecord.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(personApplyRecord);
		} catch (DaoException e) {
			log.error(" insert wrong : " + personApplyRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<PersonApplyRecord> insertList(List<PersonApplyRecord> personApplyRecordList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (personApplyRecordList == null ? "null" : personApplyRecordList.size()));
      
		List<PersonApplyRecord> resultList = null;

		if (CollectionUtils.isEmpty(personApplyRecordList)) {
			return new ArrayList<PersonApplyRecord>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (PersonApplyRecord personApplyRecord : personApplyRecordList) {
			personApplyRecord.setCreateAt(currentTimeMillis);
			personApplyRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<PersonApplyRecord>) dao.batchSave(personApplyRecordList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + personApplyRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(PersonApplyRecord.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(PersonApplyRecord personApplyRecord)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (personApplyRecord == null ? "null" : personApplyRecord.getId()));

		boolean result = false;

		if (personApplyRecord == null) {
			return true;
		}

		personApplyRecord.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(personApplyRecord);
		} catch (DaoException e) {
			log.error(" update wrong : " + personApplyRecord);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + personApplyRecord);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<PersonApplyRecord> personApplyRecordList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (personApplyRecordList == null ? "null" : personApplyRecordList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(personApplyRecordList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (PersonApplyRecord personApplyRecord : personApplyRecordList) {
			personApplyRecord.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(personApplyRecordList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + personApplyRecordList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + personApplyRecordList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public PersonApplyRecord getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		PersonApplyRecord personApplyRecord = null;

		if (id == null) {
			return personApplyRecord;
		}

		try {
			personApplyRecord = (PersonApplyRecord) dao.get(PersonApplyRecord.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return personApplyRecord;		
		}	
		  
    	   
		@Override
		public List<PersonApplyRecord> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<PersonApplyRecord> personApplyRecord = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<PersonApplyRecord>();
		}

		try {
			personApplyRecord = (List<PersonApplyRecord>) dao.getList(PersonApplyRecord.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (personApplyRecord == null ? "null" : personApplyRecord.size()));
    
		return personApplyRecord;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getPersonApplyRecordIdsByPersonApplyId(Long personApplyId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by personApplyId,start,limit  : " + personApplyId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getPersonApplyRecordIdsByPersonApplyId", new Object[] { personApplyId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by personApplyId,start,limit)  : " + personApplyId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countPersonApplyRecordIdsByPersonApplyId(Long personApplyId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by personApplyId  : " + personApplyId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getPersonApplyRecordIdsByPersonApplyId", new Object[] { personApplyId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by personApplyId)  : " + personApplyId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getPersonApplyRecordIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getPersonApplyRecordIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countPersonApplyRecordIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getPersonApplyRecordIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getPersonApplyRecordIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

