package com.ptteng.wealth.user.service.impl;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.wealth.user.model.Organization;
import com.ptteng.wealth.user.service.OrganizationService;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.stereotype.Component;


@Component("OrganizationService")
public class OrganizationServiceImpl extends BaseDaoServiceImpl implements OrganizationService {


    private static final Log log = LogFactory.getLog(OrganizationServiceImpl.class);


    @Override
    public Long insert(Organization organization) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + organization);

        if (organization == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        organization.setCreateAt(currentTimeMillis);
        organization.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(organization);
        } catch (DaoException e) {
            log.error(" insert wrong : " + organization);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<Organization> insertList(List<Organization> organizationList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (organizationList == null ? "null" : organizationList.size()));

        List<Organization> resultList = null;

        if (CollectionUtils.isEmpty(organizationList)) {
            return new ArrayList<Organization>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Organization organization : organizationList) {
            organization.setCreateAt(currentTimeMillis);
            organization.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<Organization>) dao.batchSave(organizationList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + organizationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(Organization.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(Organization organization) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (organization == null ? "null" : organization.getId()));

        boolean result = false;

        if (organization == null) {
            return true;
        }

        organization.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(organization);
        } catch (DaoException e) {
            log.error(" update wrong : " + organization);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + organization);
        }
        return result;
    }


    @Override
    public boolean updateList(List<Organization> organizationList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (organizationList == null ? "null" : organizationList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(organizationList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (Organization organization : organizationList) {
            organization.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(organizationList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + organizationList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + organizationList.size());

        return result;
    }


    @Override
    public Organization getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        Organization organization = null;

        if (id == null) {
            return organization;
        }

        try {
            organization = (Organization) dao.get(Organization.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return organization;
    }


    @Override
    public List<Organization> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<Organization> organization = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Organization>();
        }

        try {
            organization = (List<Organization>) dao.getList(Organization.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (organization == null ? "null" : organization.size()));

        return organization;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getOrganizationIdsByType(Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by type,start,limit  : " + type + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrganizationIdsByType", new Object[]{type}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by type,start,limit)  : " + type + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getOrganizationIdByOrgCode(String orgCode) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by orgCode  : " + orgCode);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getOrganizationIdByOrgCode", new Object[]{orgCode});
        } catch (DaoException e) {
            log.error(" get id wrong by orgCode  : " + orgCode);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getOrganizationIdByCreditCode(String creditCode) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by creditCode  : " + creditCode);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getOrganizationIdByCreditCode", new Object[]{creditCode});
        } catch (DaoException e) {
            log.error(" get id wrong by creditCode  : " + creditCode);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countOrganizationIdsByType(Integer type) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by type  : " + type);
        }
        Integer count = null;


        try {

            count = dao.count("getOrganizationIdsByType", new Object[]{type});


        } catch (DaoException e) {
            log.error(" count ids  wrong by type)  : " + type);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getOrganizationIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrganizationIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countOrganizationIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getOrganizationIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getOrganizationIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public Long getOrganizationIdByName(String name) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by name  : " + name);
        }
        Long id = null;

        // TODO 参数检查!

        try {


            id = (Long) dao.getMapping("getOrganizationIdByName", new Object[]{name});
        } catch (DaoException e) {
            log.error(" get id wrong by name  : " + name);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

}

