package com.ptteng.wealth.user.service.impl;

import java.net.URLEncoder;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

import com.gemantic.common.util.PasswordUtils;
import com.gemantic.common.util.StringUtil;
import com.ptteng.wealth.consign.constant.FunctionConstants;
import com.ptteng.wealth.consign.constant.OpEntrustWayEnum;
import com.ptteng.wealth.consign.model.in.OrganBindCardIn;
import com.ptteng.wealth.consign.model.in.OrganOpenAccountIn;
import com.ptteng.wealth.consign.model.in.RetrieveTransactionPasswordIn;
import com.ptteng.wealth.consign.model.out.CardBindingOut;
import com.ptteng.wealth.consign.model.out.CommonOut;
import com.ptteng.wealth.consign.model.out.CustomerInfo;
import com.ptteng.wealth.consign.model.out.OpenAccountOut;
import com.ptteng.wealth.consign.service.ConsignmentService;
import com.ptteng.wealth.user.Environment;
import com.ptteng.wealth.user.model.*;
import com.ptteng.wealth.user.service.*;
import com.ptteng.wealth.user.util.Constant;
import com.qding.common.util.HttpClientUtil;
import org.json.JSONObject;
import org.junit.Assert;
import org.osoa.sca.annotations.Remotable;


import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component("OrgApplyService")
public class OrgApplyServiceImpl extends BaseDaoServiceImpl implements OrgApplyService {


    private static final Log log = LogFactory.getLog(OrgApplyServiceImpl.class);
    private static final Log orgApplyLog = LogFactory.getLog("orgApply");

    private UserService userService;
    private ConsignmentService consignmentService;
    private OrganizationService organizationService;
    private UserOpenidRelationService userOpenidRelationService;
    private Environment environment;


    @Override
    public Long insert(OrgApply orgApply) throws ServiceException, ServiceDaoException {
        log.info(" insert data : " + orgApply);
        if (orgApply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        orgApply.setCreateAt(currentTimeMillis);
        orgApply.setUpdateAt(currentTimeMillis);
        Long result = null;
        try {
            result = (Long) dao.save(orgApply);
        } catch (DaoException e) {
            log.error(" insert wrong : " + orgApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<OrgApply> insertList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (orgApplyList == null ? "null" : orgApplyList.size()));

        List<OrgApply> resultList = null;

        if (CollectionUtils.isEmpty(orgApplyList)) {
            return new ArrayList<OrgApply>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (OrgApply orgApply : orgApplyList) {
            orgApply.setCreateAt(currentTimeMillis);
            orgApply.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<OrgApply>) dao.batchSave(orgApplyList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + orgApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(OrgApply.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(OrgApply orgApply) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (orgApply == null ? "null" : orgApply.getId()));

        boolean result = false;

        if (orgApply == null) {
            return true;
        }

        orgApply.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(orgApply);
        } catch (DaoException e) {
            log.error(" update wrong : " + orgApply);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + orgApply);
        }
        return result;
    }


    @Override
    public boolean updateList(List<OrgApply> orgApplyList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (orgApplyList == null ? "null" : orgApplyList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(orgApplyList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (OrgApply orgApply : orgApplyList) {
            orgApply.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(orgApplyList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + orgApplyList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + orgApplyList.size());

        return result;
    }


    @Override
    public OrgApply getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        OrgApply orgApply = null;

        if (id == null) {
            return orgApply;
        }

        try {
            orgApply = (OrgApply) dao.get(OrgApply.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return orgApply;
    }


    @Override
    public List<OrgApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<OrgApply> orgApply = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OrgApply>();
        }

        try {
            orgApply = (List<OrgApply>) dao.getList(OrgApply.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        log.info(" get data success : " + (orgApply == null ? "null" : orgApply.size()));
        return orgApply;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getOrgApplyIdByMobile(String mobile) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get id by mobile  : " + mobile);
        }
        Long id = null;
        // TODO 参数检查!
        try {
            id = (Long) dao.getMapping("getOrgApplyIdByMobile", new Object[]{mobile});
        } catch (DaoException e) {
            log.error(" get id wrong by mobile  : " + mobile);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getOrgApplyIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = dao.getIdList("getOrgApplyIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countOrgApplyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getOrgApplyIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getOrgApplyIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

    @Override
    public List<Long> orgCodeIds(String code) throws ServiceException, ServiceDaoException {
        List<Long> idList = null;
        try {
            idList = dao.getIdList("getOrgApplyIdByOrgCode", new Object[]{code}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + 0 + " , " + Integer.MAX_VALUE);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> licenseCodeIds(String code) throws ServiceException, ServiceDaoException {
        List<Long> idList = null;
        try {
            idList = dao.getIdList("getOrgApplyIdByLicenceCode", new Object[]{code}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + 0 + " , " + Integer.MAX_VALUE);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> creditCodeIds(String code) throws ServiceException, ServiceDaoException {
        List<Long> idList = null;
        try {
            idList = dao.getIdList("getOrgApplyIdByCreditCode", new Object[]{code}, 0, Integer.MAX_VALUE, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + 0 + " , " + Integer.MAX_VALUE);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    //创建机构用户相关数据
    @Override
    public Integer createOrg(OrgApply orgApply) throws ServiceDaoException, ServiceException {

        orgApplyLog.info("============================================================");
        orgApplyLog.info("orgApply is  " + orgApply.getId());
        boolean result = false;
        if (null != orgApply) {
            try {
                Long relationID = userOpenidRelationService.getUserOpenidRelationIdByOpenidAndStatus(orgApply.getMobile(), UserOpenidRelation.Type_Org_Mobile);
                //全局错误编码，表示用户不存在
                if (null == relationID) {
                    return -2000;
                }
                UserOpenidRelation relation = this.userOpenidRelationService.getObjectById(relationID);
                if (null == relation) {
                    return -2000;
                }
                Long userId = relation.getTypeId();
                orgApplyLog.info(" userId = " + userId);
                User user = userService.getObjectById(userId);
                int fundCode = 0;
                OpenAccountOut openAccountOut = null;
                //第一步： 机构开户
                try {
                    //fundAccount=880294775
                    if (User.ALREADY_OPEN_ACCOUNT.equals(user.getAccStatus()) && user.getFundAccount() > 0) {
                        orgApplyLog.info(" already open account  orgApply id = " + orgApply.getId());
                        fundCode = user.getFundAccount();
                    } else {
                        OrganOpenAccountIn organOpenAccountIn = new OrganOpenAccountIn();
                        organOpenAccountIn.setFunctionId(FunctionConstants.OrganOpenAccountIn);
                        organOpenAccountIn.setUserId(userId + "");
                        organOpenAccountIn.setActionIn(0);
                        organOpenAccountIn.setOrganName(orgApply.getName());
                        organOpenAccountIn.setPassword(orgApply.getPayPwd());
                        organOpenAccountIn.setMobiletelephone(orgApply.getMobile());
                        organOpenAccountIn.setOrganCode(orgApply.getUseOrgCode());
                        organOpenAccountIn.setSaleLicence(orgApply.getUseLicenseCode());
                        organOpenAccountIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        openAccountOut = consignmentService.openOrgan(organOpenAccountIn);
                        orgApplyLog.info("S4: openAccountOut: " + openAccountOut);
                        if (0 == openAccountOut.getErrorNo()) {
                            fundCode = openAccountOut.getFundAccount();
                            orgApplyLog.info("fundcode: " + fundCode);
                            if (fundCode > 0) {
                                user.setAccStatus(User.ALREADY_OPEN_ACCOUNT);
                            } else {
                                user.setAccStatus(User.NO_OPEN_ACCOUNT);
                            }
                            user.setFundAccount(fundCode);
                            user.setPayPwd(orgApply.getPayPwd());
                            userService.update(user);
                        } else {
                            CustomerInfo customerInfo = consignmentService.getCustomerInfo(userId + "");
                            if (null != customerInfo && customerInfo.getFundAccount() > 0) {
                                fundCode = customerInfo.getFundAccount();
                                user.setAccStatus(User.ALREADY_OPEN_ACCOUNT);
                                user.setFundAccount(fundCode);
                                user.setPayPwd(orgApply.getPayPwd());
                                userService.update(user);
                            } else {
                                return openAccountOut.getErrorNo();
                            }
                        }
                    }
                } catch (Exception e) {
                    orgApplyLog.info(e.getMessage());
                    e.printStackTrace(System.out);
                    return  -3015;
                }
                //第二步： 机构绑卡
                try {
                    if (1 == user.getCardStatus()) {
                        orgApplyLog.info(" already binding card  account  " + user.getId());
                    } else {
                        OrganBindCardIn organBindCardIn = new OrganBindCardIn();
                        organBindCardIn.setFunctionId(FunctionConstants.OrganCardIn);
                        organBindCardIn.setUserId(userId + "");
                        organBindCardIn.setFundAccount(fundCode);
                        organBindCardIn.setPassword(orgApply.getPayPwd());
                        organBindCardIn.setOrganName(orgApply.getName());
                        organBindCardIn.setBankNo(orgApply.getBank());   //银行卡
                        organBindCardIn.setBankAccount(orgApply.getCardNo());
                        organBindCardIn.setOrganCode(orgApply.getUseOrgCode());
                        organBindCardIn.setSaleLicence(orgApply.getUseLicenseCode());
                        organBindCardIn.setOpEntrustWay(OpEntrustWayEnum.WEB.getValue());
                        organBindCardIn.setIdKind(Constant.IDKIND);
                        CardBindingOut cardBindingOut = consignmentService.orgBindcard(organBindCardIn);
                        if (0 == cardBindingOut.getErrorNo()) {
                            orgApplyLog.info(" binding card success id = " + orgApply.getId());
                            user.setCardStatus(User.CARD_HAVE);
                            user.setPayPwd(orgApply.getPayPwd());
                            userService.update(user);
                            orgApplyLog.info(" binding success update orgApply success id = " + orgApply.getId());
                        } else {
                            //失败
                            orgApplyLog.info("s5 cardBindingOut is  " + cardBindingOut);
                            return cardBindingOut.getErrorNo();
                        }
                    }
                } catch (Exception e) {
                    orgApplyLog.info(e.getMessage());
                    e.printStackTrace(System.out);
                    return  -3015;
                }
                //第三步： 创建Organization 表
                Organization organization = organizationService.getObjectById(userId);
                boolean bOrgInsert = false;
                if (null == organization) {
                    bOrgInsert = true;
                    organization = new Organization();
                    organization.setId(userId);
                }
                organization.setLicenceCode(orgApply.getLicenceCode());
                organization.setCreditCode(orgApply.getCreditCode());
                organization.setOrgCode(orgApply.getOrgCode());
                organization.setLicenceImg(orgApply.getLicenceImg());
                organization.setPermitImg(orgApply.getPermitImg());
                organization.setTaxImg(orgApply.getTaxImg());
                organization.setType(orgApply.getOrgType());
                organization.setCreateBy(userId);
                organization.setName(orgApply.getName());
                if (bOrgInsert) {
                    organizationService.insert(organization);
                    orgApplyLog.info(" save organization id : " + userId);
                } else {
                    organizationService.update(organization);
                    orgApplyLog.info(" update organization id : " + userId);
                }

                //第四步： 更新用户姓名
                user.setName(organization.getName());
                user.setVerifyStatus(User.VERIFY_YES);
                userService.update(user);

                orgApplyLog.info("============================================================");

            } catch (Exception e) {
                e.printStackTrace(System.out);
                orgApplyLog.error(e.getMessage());
                return  -1;
            }
        }
        return 0;
    }


    public UserService getUserService() {
        return userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public OrganizationService getOrganizationService() {
        return organizationService;
    }

    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    public UserOpenidRelationService getUserOpenidRelationService() {
        return userOpenidRelationService;
    }

    public void setUserOpenidRelationService(UserOpenidRelationService userOpenidRelationService) {
        this.userOpenidRelationService = userOpenidRelationService;
    }

    public ConsignmentService getConsignmentService() {
        return consignmentService;
    }

    public void setConsignmentService(ConsignmentService consignmentService) {
        this.consignmentService = consignmentService;
    }


    public Environment getEnvironment() {
        return environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

