package com.ptteng.wealth.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.user.model.OrgApplyRecord;
import com.ptteng.wealth.user.service.OrgApplyRecordService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class OrgApplyRecordServiceImpl extends BaseDaoServiceImpl implements OrgApplyRecordService {


    private static final Log log = LogFactory.getLog(OrgApplyRecordServiceImpl.class);


    @Override
    public Long insert(OrgApplyRecord orgApplyRecord) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + orgApplyRecord);

        if (orgApplyRecord == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        orgApplyRecord.setCreateAt(currentTimeMillis);
        orgApplyRecord.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(orgApplyRecord);
        } catch (DaoException e) {
            log.error(" insert wrong : " + orgApplyRecord);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<OrgApplyRecord> insertList(List<OrgApplyRecord> orgApplyRecordList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (orgApplyRecordList == null ? "null" : orgApplyRecordList.size()));

        List<OrgApplyRecord> resultList = null;

        if (CollectionUtils.isEmpty(orgApplyRecordList)) {
            return new ArrayList<OrgApplyRecord>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (OrgApplyRecord orgApplyRecord : orgApplyRecordList) {
            orgApplyRecord.setCreateAt(currentTimeMillis);
            orgApplyRecord.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<OrgApplyRecord>) dao.batchSave(orgApplyRecordList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + orgApplyRecordList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(OrgApplyRecord.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(OrgApplyRecord orgApplyRecord) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (orgApplyRecord == null ? "null" : orgApplyRecord.getId()));

        boolean result = false;

        if (orgApplyRecord == null) {
            return true;
        }

        orgApplyRecord.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(orgApplyRecord);
        } catch (DaoException e) {
            log.error(" update wrong : " + orgApplyRecord);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + orgApplyRecord);
        }
        return result;
    }


    @Override
    public boolean updateList(List<OrgApplyRecord> orgApplyRecordList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (orgApplyRecordList == null ? "null" : orgApplyRecordList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(orgApplyRecordList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (OrgApplyRecord orgApplyRecord : orgApplyRecordList) {
            orgApplyRecord.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(orgApplyRecordList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + orgApplyRecordList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + orgApplyRecordList.size());

        return result;
    }


    @Override
    public OrgApplyRecord getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        OrgApplyRecord orgApplyRecord = null;

        if (id == null) {
            return orgApplyRecord;
        }

        try {
            orgApplyRecord = (OrgApplyRecord) dao.get(OrgApplyRecord.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return orgApplyRecord;
    }


    @Override
    public List<OrgApplyRecord> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<OrgApplyRecord> orgApplyRecord = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<OrgApplyRecord>();
        }

        try {
            orgApplyRecord = (List<OrgApplyRecord>) dao.getList(OrgApplyRecord.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (orgApplyRecord == null ? "null" : orgApplyRecord.size()));

        return orgApplyRecord;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getOrgApplyRecordIdsByOrgApplyId(Long orgApplyId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by orgApplyId,start,limit  : " + orgApplyId + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO �������!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrgApplyRecordIdsByOrgApplyId", new Object[]{orgApplyId}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by orgApplyId,start,limit)  : " + orgApplyId + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countOrgApplyRecordIdsByOrgApplyId(Long orgApplyId) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by orgApplyId  : " + orgApplyId);
        }
        Integer count = null;


        try {

            count = dao.count("getOrgApplyRecordIdsByOrgApplyId", new Object[]{orgApplyId});


        } catch (DaoException e) {
            log.error(" count ids  wrong by orgApplyId)  : " + orgApplyId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getOrgApplyRecordIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getOrgApplyRecordIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countOrgApplyRecordIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getOrgApplyRecordIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getOrgApplyRecordIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }

}

