/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl.account;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.service.account.AccountService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AccountServiceImpl
extends BaseDaoServiceImpl
implements AccountService {
    private static final Log log = LogFactory.getLog(AccountServiceImpl.class);

    public Long insert(Account account) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + account));
        if (account == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        account.setCreateAt(Long.valueOf(currentTimeMillis));
        account.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)account);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + account));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Account> insertList(List<Account> accountList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (accountList == null ? "null" : Integer.valueOf(accountList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(accountList)) {
            return new ArrayList<Account>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Account account : accountList) {
            account.setCreateAt(Long.valueOf(currentTimeMillis));
            account.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(accountList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + accountList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Account.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Account account) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (account == null ? "null" : account.getId())));
        boolean result = false;
        if (account == null) {
            return true;
        }
        account.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)account);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + account));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + account));
        }
        return result;
    }

    public boolean updateList(List<Account> accountList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (accountList == null ? "null" : Integer.valueOf(accountList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(accountList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Account account : accountList) {
            account.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(accountList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + accountList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + accountList.size()));
        return result;
    }

    public Account getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Account account = null;
        if (id == null) {
            return account;
        }
        try {
            account = (Account)this.dao.get(Account.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return account;
    }

    public Long getObjectByCode(String code) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by ,code  : " + code));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getObjectByCode", new Object[]{code});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by code  : " + code));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Account> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List account = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Account>();
        }
        try {
            account = this.dao.getList(Account.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (account == null ? "null" : Integer.valueOf(account.size()))));
        return account;
    }

    public List<Long> getAccountIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAccountIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAccountIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAccountIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAccountIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

