/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.Fund;
import com.ptteng.wealth.finance.service.FundService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FundServiceImpl
extends BaseDaoServiceImpl
implements FundService {
    private static final Log log = LogFactory.getLog(FundServiceImpl.class);

    public Long insert(Fund fund) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + fund));
        if (fund == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        fund.setCreateAt(Long.valueOf(currentTimeMillis));
        fund.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)fund);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + fund));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Fund> insertList(List<Fund> fundList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (fundList == null ? "null" : Integer.valueOf(fundList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(fundList)) {
            return new ArrayList<Fund>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Fund fund : fundList) {
            fund.setCreateAt(Long.valueOf(currentTimeMillis));
            fund.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(fundList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + fundList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Fund.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Fund fund) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (fund == null ? "null" : fund.getId())));
        boolean result = false;
        if (fund == null) {
            return true;
        }
        fund.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)fund);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + fund));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + fund));
        }
        return result;
    }

    public boolean updateList(List<Fund> fundList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (fundList == null ? "null" : Integer.valueOf(fundList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(fundList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Fund fund : fundList) {
            fund.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(fundList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + fundList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + fundList.size()));
        return result;
    }

    public Fund getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Fund fund = null;
        if (id == null) {
            return fund;
        }
        try {
            fund = (Fund)this.dao.get(Fund.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return fund;
    }

    public List<Fund> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List fund = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Fund>();
        }
        try {
            fund = this.dao.getList(Fund.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (fund == null ? "null" : Integer.valueOf(fund.size()))));
        return fund;
    }

    public List<Long> getFundIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFundIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFundIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getFundIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getFundIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

