/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.FundHistory;
import com.ptteng.wealth.finance.model.Order;
import com.ptteng.wealth.finance.model.account.Account;
import com.ptteng.wealth.finance.model.account.UserAccountRelation;
import com.ptteng.wealth.finance.service.FundHistoryService;
import com.ptteng.wealth.finance.service.account.AccountService;
import com.ptteng.wealth.finance.service.account.UserAccountRelationService;
import com.ptteng.wealth.user.model.User;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FundHistoryServiceImpl
extends BaseDaoServiceImpl
implements FundHistoryService {
    private static final Log log = LogFactory.getLog(FundHistoryServiceImpl.class);
    @Autowired
    public AccountService accountService;
    @Autowired
    public UserAccountRelationService userAccountRelationService;

    public Long insert(FundHistory fundHistory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + fundHistory));
        if (fundHistory == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        fundHistory.setCreateAt(Long.valueOf(currentTimeMillis));
        fundHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)fundHistory);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + fundHistory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<FundHistory> insertList(List<FundHistory> fundHistoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (fundHistoryList == null ? "null" : Integer.valueOf(fundHistoryList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(fundHistoryList)) {
            return new ArrayList<FundHistory>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (FundHistory fundHistory : fundHistoryList) {
            fundHistory.setCreateAt(Long.valueOf(currentTimeMillis));
            fundHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(fundHistoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + fundHistoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(FundHistory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(FundHistory fundHistory) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (fundHistory == null ? "null" : fundHistory.getId())));
        boolean result = false;
        if (fundHistory == null) {
            return true;
        }
        fundHistory.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)fundHistory);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + fundHistory));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + fundHistory));
        }
        return result;
    }

    public boolean updateList(List<FundHistory> fundHistoryList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (fundHistoryList == null ? "null" : Integer.valueOf(fundHistoryList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(fundHistoryList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (FundHistory fundHistory : fundHistoryList) {
            fundHistory.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(fundHistoryList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + fundHistoryList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + fundHistoryList.size()));
        return result;
    }

    public FundHistory getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        FundHistory fundHistory = null;
        if (id == null) {
            return fundHistory;
        }
        try {
            fundHistory = (FundHistory)this.dao.get(FundHistory.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return fundHistory;
    }

    public List<FundHistory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List fundHistory = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<FundHistory>();
        }
        try {
            fundHistory = this.dao.getList(FundHistory.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (fundHistory == null ? "null" : Integer.valueOf(fundHistory.size()))));
        return fundHistory;
    }

    public List<Long> getFundHistoryIdsByUidAndStatusAndType(Long uid, Integer status, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status,type,start,limit  : " + uid + " , " + status + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFundHistoryIdsByUidAndStatusAndType", new Object[]{uid, status, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,type,start,limit)  : " + uid + " , " + status + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getFundHistoryIdsByUidAndType(Long uid, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,type,start,limit  : " + uid + " , " + type + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFundHistoryIdsByUidAndType", new Object[]{uid, type}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,type,start,limit)  : " + uid + " , " + type + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFundHistoryIdsByUidAndStatusAndType(Long uid, Integer status, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,status,type  : " + uid + " , " + status + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getFundHistoryIdsByUidAndStatusAndType", new Object[]{uid, status, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,status,type)  : " + uid + " , " + status + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countFundHistoryIdsByUidAndType(Long uid, Integer type) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,type  : " + uid + " , " + type));
        }
        Integer count = null;
        try {
            count = this.dao.count("getFundHistoryIdsByUidAndType", new Object[]{uid, type});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,type)  : " + uid + " , " + type));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getFundHistoryIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getFundHistoryIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countFundHistoryIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getFundHistoryIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getFundHistoryIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public Long insertTransaction(Order order, User user, Integer type, Integer detail, Long payAccount, BigDecimal amount, String comment, Integer flag, Integer status, String serialNum, BigDecimal before, BigDecimal after) throws ServiceException, ServiceDaoException {
        log.info((Object)("add transaction : order " + order + " , user : " + user + " , type : " + type + " , detailedType : " + " payAccount : " + payAccount + " amount : " + amount + " comment : " + comment + " flag : " + flag + " status : " + status + " serialNum : " + serialNum + " beforeAmount : " + before + " afterAmount : " + after));
        FundHistory fundHistory = new FundHistory();
        Long id = 0L;
        try {
            UserAccountRelation userAccountRelation = this.userAccountRelationService.getObjectById(payAccount);
            Long accountId = this.accountService.getObjectByCode(userAccountRelation.getAccountCode());
            Account account = this.accountService.getObjectById(accountId);
            log.info((Object)("account : " + account));
            fundHistory.setUid(user.getId());
            fundHistory.setName(user.getName());
            fundHistory.setMobile(user.getMobile());
            fundHistory.setUserType(user.getType());
            fundHistory.setType(type);
            fundHistory.setDetail(detail);
            fundHistory.setPayAccountId(payAccount);
            fundHistory.setPayAccountName(account.getName());
            fundHistory.setAmount(amount);
            fundHistory.setComment(comment);
            if (null != order) {
                log.info((Object)"order exist");
                fundHistory.setOrderNo(order.getOrderNo());
                fundHistory.setAdditional(order.getAdditional());
            }
            fundHistory.setFlag(flag);
            fundHistory.setStatus(status);
            fundHistory.setSerialNum(serialNum);
            fundHistory.setBeforeTransaction(before);
            fundHistory.setAfterTransaction(after);
            id = this.insert(fundHistory);
        }
        catch (Exception e) {
            log.error((Object)" count by getFundHistoryIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)("transaction amount : " + amount));
        log.info((Object)("now insert transaction success and user : " + user.getId() + " account : " + payAccount + " amount " + before + " >>>>>>>>>> " + after));
        return id;
    }
}

