/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.CreditApply;
import com.ptteng.wealth.finance.service.CreditApplyService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreditApplyServiceImpl
extends BaseDaoServiceImpl
implements CreditApplyService {
    private static final Log log = LogFactory.getLog(CreditApplyServiceImpl.class);

    public Long insert(CreditApply creditApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + creditApply));
        if (creditApply == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        creditApply.setCreateAt(Long.valueOf(currentTimeMillis));
        creditApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)creditApply);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + creditApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<CreditApply> insertList(List<CreditApply> creditApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (creditApplyList == null ? "null" : Integer.valueOf(creditApplyList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(creditApplyList)) {
            return new ArrayList<CreditApply>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CreditApply creditApply : creditApplyList) {
            creditApply.setCreateAt(Long.valueOf(currentTimeMillis));
            creditApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(creditApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + creditApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(CreditApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(CreditApply creditApply) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (creditApply == null ? "null" : creditApply.getId())));
        boolean result = false;
        if (creditApply == null) {
            return true;
        }
        creditApply.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)creditApply);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + creditApply));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + creditApply));
        }
        return result;
    }

    public boolean updateList(List<CreditApply> creditApplyList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (creditApplyList == null ? "null" : Integer.valueOf(creditApplyList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(creditApplyList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (CreditApply creditApply : creditApplyList) {
            creditApply.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(creditApplyList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + creditApplyList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + creditApplyList.size()));
        return result;
    }

    public CreditApply getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        CreditApply creditApply = null;
        if (id == null) {
            return creditApply;
        }
        try {
            creditApply = (CreditApply)this.dao.get(CreditApply.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return creditApply;
    }

    public List<CreditApply> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List creditApply = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CreditApply>();
        }
        try {
            creditApply = this.dao.getList(CreditApply.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (creditApply == null ? "null" : Integer.valueOf(creditApply.size()))));
        return creditApply;
    }

    public List<Long> getCreditApplyIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCreditApplyIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCreditApplyIdsByVerifyManager(String verifyManager, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by verifyManager,start,limit  : " + verifyManager + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCreditApplyIdsByVerifyManager", new Object[]{verifyManager}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by verifyManager,start,limit)  : " + verifyManager + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getCreditApplyIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCreditApplyIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCreditApplyIdsByUidAndStatus(Long uid, Integer status) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,status  : " + uid + " , " + status));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCreditApplyIdsByUidAndStatus", new Object[]{uid, status});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,status)  : " + uid + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCreditApplyIdsByVerifyManager(String verifyManager) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by verifyManager  : " + verifyManager));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCreditApplyIdsByVerifyManager", new Object[]{verifyManager});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by verifyManager)  : " + verifyManager));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countCreditApplyIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getCreditApplyIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getCreditApplyIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getCreditApplyIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countCreditApplyIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getCreditApplyIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getCreditApplyIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

