/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.wealth.finance.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.wealth.finance.model.AnnualYield;
import com.ptteng.wealth.finance.service.AnnualYieldService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnnualYieldServiceImpl
extends BaseDaoServiceImpl
implements AnnualYieldService {
    private static final Log log = LogFactory.getLog(AnnualYieldServiceImpl.class);

    public Long insert(AnnualYield annualYield) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + annualYield));
        if (annualYield == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        annualYield.setCreateAt(Long.valueOf(currentTimeMillis));
        annualYield.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)annualYield);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + annualYield));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<AnnualYield> insertList(List<AnnualYield> annualYieldList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (annualYieldList == null ? "null" : Integer.valueOf(annualYieldList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(annualYieldList)) {
            return new ArrayList<AnnualYield>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (AnnualYield annualYield : annualYieldList) {
            annualYield.setCreateAt(Long.valueOf(currentTimeMillis));
            annualYield.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(annualYieldList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + annualYieldList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(AnnualYield.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(AnnualYield annualYield) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (annualYield == null ? "null" : annualYield.getId())));
        boolean result = false;
        if (annualYield == null) {
            return true;
        }
        annualYield.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)annualYield);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + annualYield));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + annualYield));
        }
        return result;
    }

    public boolean updateList(List<AnnualYield> annualYieldList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (annualYieldList == null ? "null" : Integer.valueOf(annualYieldList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(annualYieldList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (AnnualYield annualYield : annualYieldList) {
            annualYield.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(annualYieldList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + annualYieldList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + annualYieldList.size()));
        return result;
    }

    public AnnualYield getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        AnnualYield annualYield = null;
        if (id == null) {
            return annualYield;
        }
        try {
            annualYield = (AnnualYield)this.dao.get(AnnualYield.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return annualYield;
    }

    public List<AnnualYield> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List annualYield = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<AnnualYield>();
        }
        try {
            annualYield = this.dao.getList(AnnualYield.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (annualYield == null ? "null" : Integer.valueOf(annualYield.size()))));
        return annualYield;
    }

    public List<Long> getAnnualYieldIdsByProductId(Long productId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by productId,start,limit  : " + productId + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAnnualYieldIdsByProductId", new Object[]{productId}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by productId,start,limit)  : " + productId + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAnnualYieldIdsByProductId(Long productId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by productId  : " + productId));
        }
        Integer count = null;
        try {
            count = this.dao.count("getAnnualYieldIdsByProductId", new Object[]{productId});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by productId)  : " + productId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getAnnualYieldIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getAnnualYieldIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countAnnualYieldIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getAnnualYieldIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getAnnualYieldIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

