package com.ptteng.wealth.consign.util;

import com.ptteng.wealth.consign.model.out.BindingBank;
import org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.util.CollectionUtils;

public class ConsignmentUtil {
    /**
     * 获取用户没有绑定的银行卡
     *
     */
    public static List<String> notBindingBanks(List<BindingBank> bindedBanks,
                                               List<String> allBanks) {
        if (CollectionUtils.isEmpty(bindedBanks)) {
            return allBanks;
        }
        List<String> deleteList = new ArrayList<String>();
        for (String s : allBanks) {
            for (BindingBank bindingBank : bindedBanks) {
                if (bindingBank.getBankNo().equals(s)) {
                    deleteList.add(s);
                    break;
                }
            }
        }
        allBanks.removeAll(deleteList);
        return allBanks;
    }

    /**
     * 根据当前的银行代码获取相应的绑定银行对象，如果bankno不存在或绑定银行列表不存在，则返回null
     *
     * @param bindedBanks
     *            所有绑定的银行
     * @param bankno
     *            银行代码
     * @return
     */
    public static BindingBank getBindingBank(List<BindingBank> bindedBanks,
                                             String bankno) {
        if (StringUtils.isBlank(bankno) || CollectionUtils.isEmpty(bindedBanks)) {
            return null;
        }

        for (BindingBank bindingBank : bindedBanks) {
            if (bindingBank == null)
                continue;
            if (bankno.equalsIgnoreCase(bindingBank.getBankNo())) {
                return bindingBank;
            }
        }

        return null;
    }

    /**
     * 获取当天唯一的金融超市申请号，小于或等于32位
     *
     * @return
     */
    public static final String getOutterSerialNo() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    /**
     * 每隔四位插入一个空格，用于显示用户已经绑定的银行卡账号
     *
     * @param s
     * @return
     */
    public static String insertSpace(String s) {
        StringBuffer sb = new StringBuffer();
        char[] array = s.toCharArray();
        for (int i = 0; i < array.length; i++) {
            sb.append(array[i]);
            if (i % 4 == 3 && i != array.length - 1) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    /**
     * 获取银行卡号的末位
     *
     * @param bankAccount
     * @return
     */
    public static String getLastNumber4BankAccount(String bankAccount) {
        if (StringUtils.isBlank(bankAccount)) {
            return "";
        }
        String hasSpace = insertSpace(bankAccount);
        return hasSpace.substring(hasSpace.lastIndexOf(" ") + 1);
    }

    /**
     * 对获取到的所有的银行卡List的过滤
     *
     * @param allBankCardList
     * @return
     */
    public static List<BindingBank> filtrateBankCards(
            List<BindingBank> allBankCardList, List<String> bankTypeList) {
        List<BindingBank> result = new ArrayList<BindingBank>();
        for (BindingBank bindingBank : allBankCardList) {
            if (bankTypeList.contains(bindingBank.getBankType())) {
                result.add(bindingBank);
            }
        }
        return result;
    }
}