package com.ptteng.wealth.consign.service.impl;

import com.gemantic.common.util.CalendarUtil;
import com.hczq.hz.intf.*;
import com.ptteng.wealth.consign.constant.*;
import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.consign.service.ConsignmentService;

import com.ptteng.wealth.consign.util.ConsignmentUtil;
import com.ptteng.wealth.consign.util.Encryptor;
import com.ptteng.wealth.user.model.User;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

import java.math.BigDecimal;
import java.util.*;

/**
 * Created by arthur on 16/5/28.
 */
public class ConsignmentServiceImpl implements ConsignmentService {

    private static final Log businessLog = LogFactory.getLog(ConsignmentServiceImpl.class);
    private Log log = LogFactory.getLog(ConsignmentServiceImpl.class);
    private Log resultLog = LogFactory.getLog(ConsignmentServiceImpl.class);
    private AmServices amServices;

    private BigDecimal singleLimit;

    private int dailyStrokeCount;

    public void setAmServices(AmServices amServices) {
        this.amServices = amServices;
    }

    /**
     * 开户
     *
     * @param in
     * @return
     */
    @Override
    public OpenAccountOut openAccount(OpenAccountIn in) throws Exception {
        log.info("openAccount 9500. in:" + in);
        try {
            Fun9500Requst requst = new Fun9500Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setEMail(in.geteMail());
            if (requst.getFunctionId() == 0) {
                requst.setFunctionId(9500);
            }
            Fun9500Response response = amServices.fun9500(requst);
            OpenAccountOut out = new OpenAccountOut();
            out.setErrorNo(response.getErrorNo());
            out.setErrorInfo(response.getErrorInfo());
            out.setFundAccount(response.getFundAccount());
            resultLog.info("openAccount 9500 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("openAccount 9500 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public MainCardOut setMainCard(MainCardIn in) throws Exception {
        log.info("setMainCard 9503. in:" + in);
        if (in == null) {
            return null;
        }
        try {
            Fun9503Requst requst = new Fun9503Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9503);

            Fun9503Response response = amServices.fun9503(requst);
            MainCardOut out = new MainCardOut();
            BeanUtils.copyProperties(response, out);
            resultLog.info("setMainCard 9503 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("setMainCard 9503 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 获取客户信息
     */
    @Override
    public CustomerInfo getCustomerInfo(String userId) throws Exception {
        log.info("getCustomerInfo 9524. in:[userId=" + userId + "]");
        try {
            Fun9524Requst request = new Fun9524Requst();
            request.setFunctionId(9524);
            request.setUserId(userId);
            CustomerInfo ci = null;
            AmResultList<Fun9524Response> responseList = amServices.fun9524(request);
            if (CollectionUtils.isNotEmpty(responseList)) {
                ci = new CustomerInfo();
                Fun9524Response response = responseList.get(0);
                BeanUtils.copyProperties(response, ci);
                ci.setZipCode(response.getZipcode());
                ci.setEmail(response.getEMail());
                ci.setMobileTelePhone(response.getMobiletelephone());
                ci.setVipFlag(response.getVipFlag());
            }
            resultLog.info("getCustomerInfo 9524 success. in:[userId=" + userId + "], out:" + ci);
            return ci;
        } catch (Throwable e) {
            resultLog.error("getCustomerInfo 9524 error. in:[userId=" + userId + "]", e);
            throw new Exception(e);
        }
    }

    /**
     * 获取用户已经绑定的银行卡信息
     */
    public List<BindingBank> getBanks(int fundAccount, String userId) throws Exception {
        log.info("getBanks 9534. in:[fundAccount=" + fundAccount + " userId=" + userId + "]");
        try {
            Fun9534Requst request = new Fun9534Requst();
            request.setFundAccount(fundAccount);
            request.setUserId(userId);
            AmResultList<Fun9534Response> responses = amServices.fun9534(request);
            if (CollectionUtils.isEmpty(responses)) {
                return new ArrayList<BindingBank>();
            }
            List<BindingBank> result = new ArrayList<BindingBank>();
            for (Fun9534Response fr : responses) {
                if (null == fr) {
                    continue;
                }
                BindingBank bindingBank = new BindingBank();
                BeanUtils.copyProperties(fr, bindingBank);
                result.add(bindingBank);
            }
            Collections.reverse(result);
            resultLog.info("getBanks 9534 success. in:[fundAccount=" + fundAccount + " userId=" + userId + "], out size=" + result.size());
            return result;
        } catch (Throwable e) {
            resultLog.error("getBanks 9534 success. in:[fundAccount=" + fundAccount
                    + " userId=" + userId + "]", e);
            throw new Exception(e);
        }
    }


    @Override
    public List<BindingBank> getBindingBanks(BindingBankIn in) throws Exception {
        log.info("getBindingBanks 9534. in:" + in);
        if (in == null) {
            return new ArrayList<BindingBank>();
        }
        Fun9534Requst requst = new Fun9534Requst();
        BeanUtils.copyProperties(in, requst);
        requst.setFunctionId(9534);
        AmResultList<Fun9534Response> responses = amServices.fun9534(requst);
        if (responses == null) {
            return new ArrayList<BindingBank>();
        }
        List<BindingBank> outs = new ArrayList<BindingBank>();
        for (Fun9534Response response : responses) {
            if (response == null) {
                continue;
            }
            BindingBank out = new BindingBank();
            BeanUtils.copyProperties(response, out);
            outs.add(out);
        }
        resultLog.info("getBindingBanks 9534 success. in:" + in + ", out size=" + outs.size());
        return outs;
    }

    /**
     * 银行卡绑定
     */
    @Override
    public CardBindingOut cardBinding(CardBindingIn in) throws Exception {
        log.info("cardBinding 9502. in:" + in);
        try {
            Fun9502Requst request = new Fun9502Requst();
            BeanUtils.copyProperties(in, request);
            if (request.getFunctionId() == 0) {
                request.setFunctionId(9502);
            }
            Fun9502Response response = amServices.fun9502(request);
            CardBindingOut cbo = new CardBindingOut();
            cbo.setErrorNo(response.getErrorNo());
            cbo.setErrorInfo(response.getErrorInfo());
            cbo.setForward_params(response.getForwardParams());

            resultLog.info("cardBinding 9502 success. in:" + in + ", out:" + cbo);
//            cbo.setErrorNo(getRightErrorNumber(cbo.getErrorNo(),cbo.getErrorInfo()));
            return cbo;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("cardBinding 9502 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 修改交易密码
     */
    @Override
    public CommonOut modifyTransactionPassword(TransactionPasswordIn tpi) throws Exception {
        log.info("modifyTransactionPassword 9504. in:" + tpi);
        if (tpi == null) {
            return null;
        }
        try {
            Fun9504Requst request = new Fun9504Requst();
            BeanUtils.copyProperties(tpi, request);
            request.setFunctionId(9504);
            Fun9504Response response = amServices.fun9504(request);
            CommonOut co = new CommonOut();
            BeanUtils.copyProperties(response, co);
            resultLog.info("modifyTransactionPassword 9504 success. in:" + tpi + ", out:" + co);
            co.setErrorNo(getRightErrorNumber(co.getErrorNo(),co.getErrorInfo()));
            return co;
        } catch (Throwable e) {
            resultLog.error("modifyTransactionPassword 9504 error. in:" + tpi, e);
            throw new Exception(e);
        }
    }

    /**
     * 重置交易密码
     */
    @Override
    public CommonOut retrieveTransactionPassword(RetrieveTransactionPasswordIn in) throws Exception {
        log.info("retrieveTransactionPassword 9505. in:" + in);
        try {
            CommonOut out = new CommonOut();
            Fun9505Requst requst = new Fun9505Requst();
            in.setFunctionId(9505);
            BeanUtils.copyProperties(in, requst);
            Fun9505Response response = amServices.fun9505(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("retrieveTransactionPassword 9505 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("retrieveTransactionPassword 9505 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 组织机构户开户
     */
    @Override
    public OpenAccountOut openOrgan(OrganOpenAccountIn in) throws Exception {
        log.info("openAccount 21000. in:" + in);
        try {

            in.setPassword(Encryptor.encrypt(in.getPassword()));
            Fun21000Requst requst = new Fun21000Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setEMail(in.geteMail());
            if (requst.getFunctionId() == 0) {
                requst.setFunctionId(21000);
            }

            Fun21000Response response = amServices.fun21000(requst);
            OpenAccountOut out = new OpenAccountOut();
            out.setErrorNo(response.getErrorNo());
            out.setErrorInfo(response.getErrorInfo());
            out.setFundAccount(response.getFundAccount());
            resultLog.info("openAccount 21000 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            resultLog.error("openAccount 21000 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 机构户绑卡
     */
    @Override
    public CardBindingOut orgBindcard(OrganBindCardIn in) throws Exception {
        log.info("cardBinding 21001. in:" + in);
        try {
            in.setPassword(Encryptor.encrypt(in.getPassword()));
            Fun21001Requst request = new Fun21001Requst();
            BeanUtils.copyProperties(in, request);
            if (request.getFunctionId() == 0) {
                request.setFunctionId(21001);
            }
            request.setIdKind(in.getIdKind());
            Fun21001Response response = amServices.fun21001(request);
            CardBindingOut cbo = new CardBindingOut();
            cbo.setErrorNo(response.getErrorNo());
            cbo.setErrorInfo(response.getErrorInfo());
            cbo.setForward_params(response.getForwardParams());
            resultLog.info("cardBinding 21001 success. in:" + in + ", out:" + cbo);
            cbo.setErrorNo(getRightErrorNumber(cbo.getErrorNo(),cbo.getErrorInfo()));
            return cbo;
        } catch (Throwable e) {
            resultLog.error("cardBinding 21001 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public OrganInfo getOrganInfo(OrganInfoIn organInfoIn) throws Exception {
        log.info("getOrganInfo 21002. in:" + organInfoIn);
        try {
            Fun21002Requst request = new Fun21002Requst();

            BeanUtils.copyProperties(organInfoIn, request);
            request.setFunctionId(21002);
            OrganInfo info = null;
            AmResultList<Fun21002Response> responseList = amServices.fun21002(request);
            if (CollectionUtils.isNotEmpty(responseList)) {
                info = new OrganInfo();
                Fun21002Response response = responseList.get(0);
                BeanUtils.copyProperties(response, info);
            }
            resultLog.info("getOrganInfo 20005 success. in:" + request + ", out:" + info);
            return info;
        } catch (Throwable e) {
            resultLog.error("getOrganInfo 20005 error. in:" + organInfoIn, e);
            throw new Exception(e);
        }
    }

    @Override
    public CancelCardOut cancelCard(CancelCardIn in) throws Exception {
        log.info("cancelCard 9545. in:" + in);
        if (in == null) {
            return null;
        }
        try {
            Fun9545Requst requst = new Fun9545Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9545);

            Fun9545Response response = amServices.fun9545(requst);
            CancelCardOut out = new CancelCardOut();
            BeanUtils.copyProperties(response, out);
            resultLog.info("cancelCard 9545 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            resultLog.error("cancelCard 9545 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public CommonOut modifyAccountInfo(AccountInfoIn ai) throws Exception {
        log.info("modifyAccountInfo 9542. in:" + ai);
        if (ai == null) {
            return null;
        }

        try {
            Fun9542Requst request = new Fun9542Requst();
            BeanUtils.copyProperties(ai, request);
            request.setFunctionId(9542);
            Fun9542Response response = amServices.fun9542(request);
            CommonOut co = new CommonOut();
            BeanUtils.copyProperties(response, co);
            resultLog.info("modifyAccountInfo 9542 success. in:" + ai + ", out:" + co);
            co.setErrorNo(getRightErrorNumber(co.getErrorNo(),co.getErrorInfo()));
            return co;
        } catch (Throwable e) {
            resultLog.error("modifyAccountInfo 9542 error. in:" + ai, e);
            throw new Exception(e);
        }
    }

    @Override
    public CommonOut modifyPersonalInfo(PersonalInfoIn pii) throws Exception {
        log.info("modifyPersonalInfo 9543. in:" + pii);
        if (pii == null) {
            return null;
        }
        try {
            Fun9543Requst request = new Fun9543Requst();
            BeanUtils.copyProperties(pii, request);
            request.setFunctionId(9543);
//            request.setEmail(pii.getEmail());
            Fun9543Response response = amServices.fun9543(request);
            CommonOut co = new CommonOut();
            BeanUtils.copyProperties(response, co);
            resultLog.error("modifyPersonalInfo 9543 success. in:" + pii + ", out:" + co);
            co.setErrorNo(getRightErrorNumber(co.getErrorNo(),co.getErrorInfo()));
            return co;
        } catch (Throwable e) {
            resultLog.error("modifyPersonalInfo 9543 error. in:" + pii, e);
            throw new Exception(e);
        }
    }

    /**
     * 修改用户风险等级
     */
    public RiskLevelModifyOut modifyRiskLevel(RiskLevelModifyIn in) throws Exception {
        log.info("modifyRiskLevel 9544. in :" + in);

        if (in == null) {
            return null;
        }

        try {
            Fun9544Requst requst = new Fun9544Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9544);

            Fun9544Response response = amServices.fun9544(requst);
            if (response == null) {
                return null;
            }
            RiskLevelModifyOut riskLevelModifyOut = new RiskLevelModifyOut();
            BeanUtils.copyProperties(response, riskLevelModifyOut);

            resultLog.info("modifyRiskLevel 9544 success. in:" + in + ", out:" + riskLevelModifyOut);
            riskLevelModifyOut.setErrorNo(getRightErrorNumber(riskLevelModifyOut.getErrorNo(),riskLevelModifyOut.getErrorInfo()));
            return riskLevelModifyOut;
        } catch (Throwable e) {
            resultLog.error("modifyRiskLevel 9544 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 充值
     */
    @Override
    public RechargeOut recharge(RechargeIn ri) throws Exception {
        log.info("recharge 9900. in:" + ri);
        try {
            if (BankTypeConstant.TIED_CARD_TYPE_GATEWAY.equals(ri
                    .getTiedCardType())) {
                return rechargeGateway(ri);
            }
            Fun9900Requst requst = new Fun9900Requst();

            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            ri.setFundTime(Integer.parseInt(hms));
            ri.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            ri.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            ri.setResv("resv");
            ri.setFunctionId(9900);
            BeanUtils.copyProperties(ri, requst);
            Fun9900Response response = amServices.fun9900(requst);

            RechargeOut ro = new RechargeOut();
            BeanUtils.copyProperties(response, ro);
            ro.setRespCode(response.getRespCode());
            ro.setRespDesc(response.getRespDesc());
            if (StringUtils.isNotBlank(response.getErrorInfo()) && !"RC30".equals(response.getRespCode())) {
                ro.setErrorInfo(response.getErrorInfo());
                ro.setErrorNo(response.getErrorNo());
            } else {
                ro.setErrorInfo(response.getRespDesc());
            }
            resultLog.info("recharge 9900 success. in:" + ri + ", out:" + ro);
            ro.setErrorNo(getRightErrorNumber(ro.getErrorNo(),ro.getErrorInfo()));
            return ro;
        } catch (Throwable e) {
            resultLog.error("recharge 9900 success. in:" + ri, e);
            throw new Exception(e);
        }
    }

    /**
     * 网关充值
     */
    @Override
    public RechargeOut rechargeGateway(RechargeIn ri) throws Exception {
        log.info("rechargeGateway 9906. in:" + ri);
        try {
            Fun9906Requst requst = new Fun9906Requst();
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            ri.setFundTime(Integer.parseInt(hms));
            ri.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            ri.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            ri.setResv("resv");
            ri.setFunctionId(9906);
            //00：余额充值 01：保证金充值 02:风险准备金充值
            if (ri.getBusinessType() == null) {
                ri.setBusinessType("00");
            }

            BeanUtils.copyProperties(ri, requst);
            Fun9906Response response = amServices.fun9906(requst);
            RechargeOut ro = new RechargeOut();
            BeanUtils.copyProperties(response, ro);
            resultLog.info("rechargeGateway 9906 success. in:" + ri + ", out:" + ro);
            ro.setErrorNo(getRightErrorNumber(ro.getErrorNo(),ro.getErrorInfo()));
            return ro;
        } catch (Throwable e) {
            resultLog.error("rechargeGateway 9906 error. in:" + ri, e);
            throw new Exception(e);
        }
    }

    /**
     * 提现
     */
    @Override
    public WithdrawCashOut withdraw(WithdrawCashIn wci) throws Exception {
        log.info("withdraw 9901. in:" + wci);
        try {
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            wci.setFundTime(Integer.parseInt(hms));
            wci.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            wci.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            wci.setResv("resv");
            wci.setFunctionId(9901);

            Fun9901Requst requst = new Fun9901Requst();
            BeanUtils.copyProperties(wci, requst);
            Fun9901Response response = amServices.fun9901(requst);
            WithdrawCashOut wco = new WithdrawCashOut();
            BeanUtils.copyProperties(response, wco);
            wco.setRespCode(response.getRespCode());
            wco.setRespDesc(response.getRespDesc());
            if (StringUtils.isNotBlank(response.getErrorInfo())
                    && !"RC30".equals(response.getRespCode())) {
                wco.setErrorInfo(response.getErrorInfo());
                wco.setErrorNo(response.getErrorNo());
            } else {
                wco.setErrorInfo(response.getRespDesc());
            }
            resultLog.info("withdraw 9901 success. in:" + wci + ", out:" + wco);
            wco.setErrorNo(getRightErrorNumber(wco.getErrorNo(),wco.getErrorInfo()));
            return wco;
        } catch (Throwable e) {
            resultLog.error("withdraw 9901 error. in:" + wci, e);
            throw new Exception(e);
        }
    }

    @Override
    public OfflineRechargeOut rechargeOffline(OfflineRechargeIn in) throws Exception {
        log.info("rechargeOffline 9907. in:" + in);
        try {

            Fun9907Requst requst = new Fun9907Requst();
            in.setFunctionId(9907);
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString() + second.toString();
            in.setFundTime(Integer.parseInt(hms));
            in.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar.getTimeInMillis()));
            in.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            BeanUtils.copyProperties(in, requst);
            requst.setReceibankCode(in.getReceibankCode());
            requst.setPaymentbankCode(in.getPaymentbankCode());
            Fun9907Response response = amServices.fun9907(requst);
            OfflineRechargeOut out = new OfflineRechargeOut();
            BeanUtils.copyProperties(response, out);
            out.setRespCode(response.getRespCode());
            out.setRespDesc(response.getRespDesc());
            if (StringUtils.isNotBlank(response.getErrorInfo())) {
                out.setErrorInfo(response.getErrorInfo());
                out.setErrorNo(response.getErrorNo());
                out.setSerialNoTrans(response.getSerialNoTrans());
            } else {
                out.setErrorInfo(response.getRespDesc());
            }

            if (out.getErrorNo() == 0) {
                StringBuilder sb = new StringBuilder().append(9907).append(" ")
                        .append((null != in.getUserId() && StringUtils.isNotBlank(in.getUserId().toString().trim())) ? in.getUserId() : "无").append(" ")
                        .append(in.getFundAccount()).append(" ")
                        .append((null != out.getRechargeCode() && StringUtils.isNotBlank(out.getRechargeCode().toString().trim())) ? out.getRechargeCode() : "无").append(" ")
                        .append((null != in.getPaymentbankCode() && StringUtils.isNotBlank(in.getPaymentbankCode().toString().trim())) ? in.getPaymentbankCode() : "无").append(" ")
                        .append((null != in.getCardName() && StringUtils.isNotBlank(in.getCardName().toString().trim())) ? in.getCardName() : "无").append(" ")
                        .append(BusinessTypeEnum.BALANCE_RECHARGE.getValue().equalsIgnoreCase(in.getBusinessType()) ? "余额"
                                : BusinessTypeEnum.SURETYAMT_RECHARGE.getValue().equalsIgnoreCase(in.getBusinessType()) ? "保证金"
                                : BusinessTypeEnum.RISKAMT_RECHARGE.getValue().equalsIgnoreCase(in.getBusinessType()) ? "风险准备金" : " ").append(" ")
                        .append((null != in.getRechargeAmt() && StringUtils.isNotBlank(in.getRechargeAmt().toString().trim())) ? in.getRechargeAmt() : "0").append(" ")
                        .append(System.currentTimeMillis());
                businessLog.info(sb.toString());
            }
            resultLog.info("rechargeOffline 9907 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("rechargeOffline 9907 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public List<OfflineRecharge> getRechargeOfflineRecord(OfflineRechargeQueryIn in) throws Exception {
        log.info("getRechargeOfflineRecord 9908. in " + in);
        if (in == null) {
            return new ArrayList<OfflineRecharge>();
        }
        try {
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString() + second.toString();
            in.setFundTime(Integer.parseInt(hms));
            in.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar.getTimeInMillis()));
            in.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            in.setFunctionId(9908);
            Fun9908Requst requst = new Fun9908Requst();
            BeanUtils.copyProperties(in, requst);
            AmResultList<Fun9908Response> responses = amServices.fun9908(requst);
            if (responses == null) {
                return new ArrayList<OfflineRecharge>();
            }
            List<OfflineRecharge> outs = new ArrayList<OfflineRecharge>();
            for (Fun9908Response response : responses) {
                if (response == null) {
                    continue;
                }
                OfflineRecharge out = new OfflineRecharge();
                BeanUtils.copyProperties(response, out);
                out.setOrderDateLong(CalendarUtil.convertYyyyMMdd2TimeMillis(out.getOrderDate()));
                outs.add(out);
            }
            resultLog.info("getRechargeOfflineRecord 9908 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("getRechargeOfflineRecord 9908 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public WithdrawLimitOut getWithdrawLimit(WithdrawLimitIn wli) throws Exception {
        log.info("getWithdrawLimit 9909. in:" + wli);
        try {
            Fun9909Requst requst = new Fun9909Requst();
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            wli.setFundTime(Integer.parseInt(hms));
            wli.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            wli.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            wli.setResv("resv");
            wli.setFunctionId(9909);
            BeanUtils.copyProperties(wli, requst);
            Fun9909Response response = amServices.fun9909(requst);
            WithdrawLimitOut wlo = new WithdrawLimitOut();
            BeanUtils.copyProperties(response, wlo);
            wlo.setRespCode(response.getRespCode());
            wlo.setRespDesc(response.getRespDesc());
            wlo.setSingleLimit(singleLimit);
            wlo.setDailyStrokeCount(dailyStrokeCount);
            if (StringUtils.isNotBlank(response.getErrorInfo())) {
                wlo.setErrorInfo(response.getErrorInfo());
                wlo.setErrorNo(response.getErrorNo());
                wlo.setSerialNoTrans(response.getSerialNoTrans());
            } else {
                wlo.setErrorInfo(response.getRespDesc());
            }
            resultLog.info("getWithdrawLimit 9909 success. in:" + wli + ", out:" + wlo);
            wlo.setErrorNo(getRightErrorNumber(wlo.getErrorNo(),wlo.getErrorInfo()));
            return wlo;
        } catch (Throwable e) {
            resultLog.error("getWithdrawLimit 9909 error. in:" + wli, e);
            throw new Exception(e);
        }
    }

    /*
     * <p>Title: getMessageCode</p>
	 * <p>Description:9910 获取短信验证码 </p>
	 * @param in
	 * @return
	 * @throws ServiceException
	 * @see com.gemantic.wealth.consignment.service.ConsignmentService#getMessageCode(com.gemantic.wealth.consignment.model.in.MessageAuthenticationCodeIn)
	 */
    @Override
    public MessageAuthenticationCodeOut getMessageCode(MessageAuthenticationCodeIn in) throws Exception {
        log.info("getMessageCode 9910. in:" + in);
        try {
            MessageAuthenticationCodeOut out = new MessageAuthenticationCodeOut();
            Fun9910Requst requst = new Fun9910Requst();
            in.setFunctionId(9910);
            BeanUtils.copyProperties(in, requst);
            Fun9910Response response = amServices.fun9910(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("getMessageCode 9910 success. in:" + in + ", out:" + out);
            return out;
        } catch (Throwable e) {
            resultLog.error("getMessageCode 9910 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 签署协议
     *
     * @param userId
     * @param branchNo
     * @param fundAccount
     * @param fundCompany
     * @param fundCode
     * @param mobiletelephone
     * @param password
     * @param chargeType
     * @param opEntrustWay
     * @param signRiskNotice  签约类型：1-购买电子协议，3-转让协议
     * @return
     */
    private CommonOut signNotice(String userId, int branchNo, int fundAccount,
                                 String fundCompany, String fundCode, String mobiletelephone,
                                 String password, String chargeType, String opEntrustWay,
                                 String signRiskNotice) throws Throwable {

        log.info("signNotice 9955. [userId=" + userId + ",branchNo="
                + branchNo + ",fundAccount=" + fundAccount
                + ",fundCompany=" + fundCompany + ",fundCode=" + fundCode
                + ",mobiletelephone=" + mobiletelephone + ",chargeType="
                + chargeType + ",signRiskNotice=" + signRiskNotice
                + ",opEntrustWay=" + opEntrustWay + "]");

        CommonOut out = new CommonOut();
        Fun9954Requst erequst = new Fun9954Requst();
        erequst.setFunctionId(9954);
        erequst.setUserId(userId);
        erequst.setBranchNo(branchNo);
        erequst.setFundAccount(fundAccount);
        erequst.setFundCompany(fundCompany);
        erequst.setFundCode(fundCode);
        erequst.setChargeType(chargeType);

        // 查询是否已签对应产品协议
        AmResultList<Fun9954Response> eresult = amServices.fun9954(erequst);
        boolean isNotSign = true;
        if (CollectionUtils.isNotEmpty(eresult)) {
            for (Fun9954Response r : eresult) {
                if (signRiskNotice.equalsIgnoreCase(r.getSignRiskNotice())) {
                    isNotSign = false;
                    break;
                }

            }
        }

        if (isNotSign) {
            Fun9955Requst esrequst = new Fun9955Requst();
            esrequst.setFunctionId(9955);
            esrequst.setUserId(userId);
            esrequst.setBranchNo(branchNo);
            esrequst.setFundAccount(fundAccount);
            esrequst.setFundCompany(fundCompany);
            esrequst.setFundCode(fundCode);
            esrequst.setMobiletelephone(mobiletelephone);
            esrequst.setPassword(password);
            esrequst.setSignRiskNotice(signRiskNotice);
            esrequst.setChargeType(chargeType);
            esrequst.setOpEntrustWay(opEntrustWay);
            // 签署协议
            Fun9955Response esresult = amServices.fun9955(esrequst);
            out.setErrorNo(esresult.getErrorNo());
            out.setErrorInfo(esresult.getErrorInfo());
            resultLog.info("signNotice 9955 success. [userId=" + userId + ",branchNo="
                    + branchNo + ",fundAccount=" + fundAccount
                    + ",fundCompany=" + fundCompany + ",fundCode=" + fundCode
                    + ",mobiletelephone=" + mobiletelephone + ",chargeType="
                    + chargeType + ",signRiskNotice=" + signRiskNotice
                    + ",opEntrustWay=" + opEntrustWay + ",errorNo="
                    + esresult.getErrorNo() + ",errorInfo="
                    + esresult.getErrorInfo() + "]");
        }
        return out;

    }

    @Override
    public List<SpiritPosition> getSpiritPosition(SpiritPositionIn in) throws Exception {
        log.info("getSpiritPosition 9957. in:" + in);
        try {
            Fun9957Requst requst = new Fun9957Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9957);
            requst.setMStockType(in.getmStockType());
            AmResultList<Fun9957Response> responses = amServices
                    .fun9957(requst);
            if (responses == null) {
                return new ArrayList<SpiritPosition>();
            }
            List<SpiritPosition> outs = new ArrayList<SpiritPosition>();
            for (Fun9957Response response : responses) {
                if (response == null) {
                    continue;
                }
                SpiritPosition out = new SpiritPosition();
                BeanUtils.copyProperties(response, out);
                out.setCloseDayMillisecond(CalendarUtil
                        .convertYyyyMMdd2TimeMillis(out.getCloseDay()));
                out.setmStockType(response.getMStockType());
                outs.add(out);
            }
            resultLog.info("getSpiritPosition 9957 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("getSpiritPosition 9957 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public SpiritPositionStat getSpiritPositionStat(SpiritPositionStatIn in) throws Exception {
        log.info("getSpiritPositionStat 9958. in:" + in);
        try {
            Fun9958Requst requst = new Fun9958Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9958);
            Fun9958Response response = amServices.fun9958(requst);
            SpiritPositionStat out = new SpiritPositionStat();
            BeanUtils.copyProperties(response, out);
            resultLog.info("getSpiritPositionStat 9958 success. in:" + in + ", out:" + out);
            return out;
        } catch (Throwable e) {
            resultLog.error("getSpiritPositionStat 9958 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public Position getPosition(PositionIn in) throws Exception {
        log.info("getPosition 9959. in:" + in);
        try {
            Fun9959Requst requst = new Fun9959Requst();
            BeanUtils.copyProperties(in, requst);
            in.setFunctionId(9959);
            Fun9959Response response = amServices.fun9959(requst);
            Position out = new Position();
            BeanUtils.copyProperties(response, out);
            resultLog.info("getPosition 9959 success. in:" + in + ", out:" + out);
            return out;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("getPosition 9959 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public List<UncomeBalanceRecord> getUncomeBalanceRecord(UncomeBalanceIn in) throws Exception {
        log.info("getUncomeBalanceRecord 9960. in:" + in);
        try {
            Fun9960Requst requst = new Fun9960Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9960);
            requst.setMStockType(in.getmStockType());
            AmResultList<Fun9960Response> responses = amServices
                    .fun9960(requst);
            if (responses == null) {
                return new ArrayList<UncomeBalanceRecord>();
            }
            List<UncomeBalanceRecord> outs = new ArrayList<UncomeBalanceRecord>();
            for (Fun9960Response response : responses) {
                if (response == null) {
                    continue;
                }
                UncomeBalanceRecord out = new UncomeBalanceRecord();
                BeanUtils.copyProperties(response, out);
                out.setmStockType(response.getMStockType());
                String time = String.valueOf(out.getCurrTime());
                String yyyyMMddHHmmss = String.valueOf(out.getCurrDate())
                        + (time.length() < 6 ? StringUtils
                        .leftPad(time, 6, "0") : time);
//                out.setCurrMillisecond(CalendarUtil.convertDateStr2TimeMillis(
//                        yyyyMMddHHmmss, CalendarUtil.yyyyMMddHHmmssTimeFormate));
                outs.add(out);
            }
            resultLog.error("getUncomeBalanceRecord 9960 success. in:" + in + ", out size=" + outs.size());

            return outs;
        } catch (Throwable e) {
            resultLog.error("getUncomeBalanceRecord 9960 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public CommonOut setUpDefer(DeferIn in) throws Exception {
        log.info("setUpDefer 9963. in:" + in);
        try {
            CommonOut out = new CommonOut();
            Fun9963Requst requst = new Fun9963Requst();
            in.setFunctionId(9963);
            in.setOutterSerialNo(ConsignmentUtil.getOutterSerialNo());
            BeanUtils.copyProperties(in, requst);
            Fun9963Response response = amServices.fun9963(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("setUpDefer 9963 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("setUpDefer 9963 error " + in, e);
            throw new Exception(e);
        }

    }

    @Override
    public List<CurrentIncomeRecord> getCurrentIncomeRecord(CurrentIncomeRecordIn in) throws Exception {
        log.info("getCurrentIncomeRecord 9984. in:" + in);
        try {
            Fun9984Requst requst = new Fun9984Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9984);
            Long startTime = System.currentTimeMillis();
            log.info("startTime : " + startTime);
            AmResultList<Fun9984Response> responses = amServices.fun9984(requst);
            log.info("endTime : " + System.currentTimeMillis() + " , and spend time : " + (startTime - System.currentTimeMillis()));
            if (responses == null) {
                return new ArrayList<CurrentIncomeRecord>();
            }
            List<CurrentIncomeRecord> outs = new ArrayList<CurrentIncomeRecord>();
            for (Fun9984Response response : responses) {
                if (response == null) {
                    continue;
                }
                CurrentIncomeRecord out = new CurrentIncomeRecord();
                BeanUtils.copyProperties(response, out);
                out.setInitDateMillisecond(CalendarUtil.convertYyyyMMdd2TimeMillis(out.getInitDate()));
                outs.add(out);
            }
            resultLog.info("getCurrentIncomeRecord 9984 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("getCurrentIncomeRecord 9984 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public Integer getCurrentIncomeRecordCount(CurrentIncomeRecordIn in) throws Exception {
        log.info("getCurrentIncomeRecordCount 9985. in:" + in);
        try {
            Fun9985Requst requst = new Fun9985Requst();
            in.setFunctionId(9985);
            BeanUtils.copyProperties(in, requst);
            Fun9985Response response = amServices.fun9985(requst);
            if (null != response) {
                resultLog.info("getCurrentIncomeRecordCount 9985 success. in:" + in + ", out size=" + response.getSumRowcount());
                return response.getSumRowcount();
            }
            return 0;
        } catch (Throwable e) {
            resultLog.error("getCurrentIncomeRecordCount 9985 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public LoanInfoStatOut getLoanInfoStat(LoanInfoStatIn in) throws Exception {
        log.info("getLoanInfoStat 9700. in:" + in);
        try {
            LoanInfoStatOut out = new LoanInfoStatOut();
            Fun9700Requst requst = new Fun9700Requst();
            in.setFunctionId(9700);
            BeanUtils.copyProperties(in, requst);
            Fun9700Response response = amServices.fun9700(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("getLoanInfoStat 9700 success. in:" + in + ", out:" + out);
            return out;

        } catch (Throwable e) {
            resultLog.error("getLoanInfoStat 9700 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public List<LoanInfoOut> getLoanInfo(LoanInfoIn in) throws Exception {
        log.info("getLoanInfo 9701. in:" + in);
        try {
            List<LoanInfoOut> out = new ArrayList<LoanInfoOut>();
            Fun9701Requst requst = new Fun9701Requst();
            in.setFunctionId(9701);
            BeanUtils.copyProperties(in, requst);
            LoanInfoOut infoOut = null;
            AmResultList<Fun9701Response> responseList = amServices.fun9701(requst);
            for (Fun9701Response response : responseList) {
                infoOut = new LoanInfoOut();
                BeanUtils.copyProperties(response, infoOut);
//                infoOut.setCurrDateStr(DateUtil.convertDateFromInteger(infoOut.getCurrDate(),
//                        DateUtil.webFormat)) ;
//                infoOut.setCurrTimeStr(DateUtil.convertTimeFromInteger(infoOut.getCurrTime(),
//                        DateUtil.timeFormat2)) ;

                out.add(infoOut);
            }
            resultLog.info("getLoanInfo 9701 success. in:" + in + ", out size=" + out.size());
            return out;

        } catch (Throwable e) {
            resultLog.error("getLoanInfo 9701 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public RepaymentPlanStatOut getRepaymentPlanStat(RepaymentPlanStatIn in) throws Exception {
        log.info("getRepaymentPlanStat 9702. in:" + in);
        try {
            RepaymentPlanStatOut out = new RepaymentPlanStatOut();
            Fun9702Requst requst = new Fun9702Requst();
            in.setFunctionId(9702);
            BeanUtils.copyProperties(in, requst);
            Fun9702Response response = amServices.fun9702(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("getRepaymentPlanStat 9702 success. in:" + in + ", out:" + out);
            return out;

        } catch (Throwable e) {
            resultLog.error("getRepaymentPlanStat 9702 error. in:" + in, e);
            throw new Exception(e);
        }

    }

    @Override
    public List<RepaymentPlanOut> getRepaymentPlan(RepaymentPlanIn in) throws Exception {
        log.info("getRepaymentPlan 9703. in:" + in);
        try {
            List<RepaymentPlanOut> out = new ArrayList<RepaymentPlanOut>();
            Fun9703Requst requst = new Fun9703Requst();
            in.setFunctionId(9703);
            BeanUtils.copyProperties(in, requst);
            RepaymentPlanOut planOut = null;
            AmResultList<Fun9703Response> responseList = amServices.fun9703(requst);
            for (Fun9703Response response : responseList) {
                planOut = new RepaymentPlanOut();
                BeanUtils.copyProperties(response, planOut);
                out.add(planOut);
            }
            resultLog.info("getRepaymentPlan 9703 success. in:" + in + ", out size=" + out.size());
            return out;

        } catch (Throwable e) {
            resultLog.error("getRepaymentPlan 9703 error. in:" + in, e);
            throw new Exception(e);
        }

    }

    @Override
    public LoanMoneyStatOut getLoanMoneyStat(LoanMoneyStatIn in) throws Exception {
        log.info("getLoanMoneyStat 9710. in:" + in);
        try {
            LoanMoneyStatOut out = new LoanMoneyStatOut();
            Fun9710Requst requst = new Fun9710Requst();
            in.setFunctionId(9710);
            BeanUtils.copyProperties(in, requst);
            Fun9710Response response = amServices.fun9710(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("getLoanMoneyStat 9710 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;

        } catch (Throwable e) {
            resultLog.error("getLoanMoneyStat 9710 error. in:" + in, e);
            throw new Exception(e);
        }

    }


    @Override
    public BailRechargeOut bailRecharge(BailRechargeIn in) throws Exception {
        log.info("bailRecharge 9711. in:" + in);
        try {
            BailRechargeOut out = new BailRechargeOut();
            Fun9711Requst requst = new Fun9711Requst();
            in.setFunctionId(9711);
            BeanUtils.copyProperties(in, requst,
                    new String[]{"bankNoDk", "bankAccountDk", "fundCompanyBack",
                            "fundCodeBack", "chargeTypeBack"});
//            requst.setOpBusinessFlag(in.getOpBusinessFlag());
            requst.setOpEntrustWay(in.getOpEntrustWay());
            // 金汇宝份额
            BigDecimal amount = BigDecimal.ZERO;
            // 银行卡金额
            BigDecimal bankBalance = null;
            if (BailRechargeIn.PayType_Bank.equals(in.getPayType())) { //银行卡支付
                requst.setBankAccountDk(in.getBankAccountDk());
                requst.setBankNoDk(in.getBankNoDk());

                bankBalance = in.getOccurBalance();
            } else if (BailRechargeIn.PayType_Bank_Current.equals(in.getPayType())) { //银行卡+金汇宝支付
                requst.setBankAccountDk(in.getBankAccountDk());
                requst.setBankNoDk(in.getBankNoDk());
                requst.setFundCodeBack(in.getFundCodeBack());
                requst.setFundCompanyBack(in.getFundCompanyBack());
                requst.setChargeTypeBack(in.getChargeTypeBack());

                bankBalance = in.getOccurBalance().subtract(in.getUserEnableBalance());
                amount = in.getUserEnableShare();
            } else if (BailRechargeIn.PayType_Current.equals(in.getPayType())) {  //金汇宝支付
                requst.setFundCompanyBack(in.getFundCompanyBack());
                requst.setFundCodeBack(in.getFundCodeBack());
                requst.setChargeTypeBack(in.getChargeTypeBack());
                if (in.getUserEnableShare().compareTo(in.getOccurBalance()) >= 0) {
                    amount = in.getOccurBalance();
                } else {
                    amount = in.getUserEnableShare();
                }
            }
            //活宝使用额
            requst.setShareBack(amount);
            in.setShareBack(amount);
            //银行卡使用额
            requst.setBankBalance(bankBalance);
            in.setBankBalance(bankBalance);

            Fun9711Response response = amServices.fun9711(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("bailRecharge 9711 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            resultLog.error("bailRecharge 9711 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 获取余额
     */
    @Override
    public BalanceInquiryOut getBalance(BalanceInquiryIn bii) throws Exception {
        log.info("getBalance 9902. in:" + bii);
        try {
            Fun9902Requst requst = new Fun9902Requst();
            bii.setFunctionId(9902);
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            bii.setFundTime(Integer.parseInt(hms));
            bii.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            bii.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            bii.setResv("resv");
            BeanUtils.copyProperties(bii, requst);
            Fun9902Response response = amServices.fun9902(requst);
            BalanceInquiryOut bio = new BalanceInquiryOut();
            BeanUtils.copyProperties(response, bio);
            bio.setRedeeTransitmAmt(response.getRedeeTransitmAmt());
            if (null == response.getTransAmt()) {
                bio.setTotalAmt(response.getRedeeTransitmAmt());
            } else if (null == response.getRedeeTransitmAmt()) {
                bio.setTotalAmt(response.getTransAmt());
            } else {
                bio.setTotalAmt(response.getTransAmt().add(
                        response.getRedeeTransitmAmt()));
            }
            resultLog.info("getBalance 9902 success. in:" + bii + ", out:" + bio);
            bio.setErrorNo(getRightErrorNumber(bio.getErrorNo(),bio.getErrorInfo()));
            return bio;
        } catch (Throwable e) {
            e.printStackTrace();
            resultLog.error("getBalance 9902 error. in:" + bii, e);
            throw new Exception(e);
        }
    }

    /**
     * 证联融通-充值流水查询(9903)
     */
    @Override
    public List<RechargeWaterQueryOut> getRechargeWaterQuery(RechargeWaterQueryIn in) throws Exception {
        log.info("getRechargeWaterQuery 9903. in:" + in);
        if (in == null) {
            // log.warn("getRechargeWaterQuery in param is null");
            return new ArrayList<RechargeWaterQueryOut>();
        }
        try {
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            in.setFundTime(Integer.parseInt(hms));
            in.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            in.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            Fun9903Requst requst = new Fun9903Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9903);
            AmResultList<Fun9903Response> responses = amServices.fun9903(requst);
            if (responses == null) {
                log.warn("9903resp is null");
                return new ArrayList<RechargeWaterQueryOut>();
            }
            List<RechargeWaterQueryOut> outs = new ArrayList<RechargeWaterQueryOut>();
            for (Fun9903Response response : responses) {
                if (response == null) {
                    continue;
                }
                RechargeWaterQueryOut out = new RechargeWaterQueryOut();
                BeanUtils.copyProperties(response, out);
//                out.setOrderDateLong(CalendarUtil.convertDateStr2TimeMillis(
//                        out.getOrderDate(),
//                        CalendarUtil.yyyyMMddHHmmssTimeFormate));
                outs.add(out);
            }
            resultLog.info("getRechargeWaterQuery 9903 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("getRechargeWaterQuery 9903 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 证联融通-提现流水查询(9904)
     */
    @Override
    public List<WithdrawWaterQueryOut> getWithdrawWaterQuery(
            WithdrawWaterQueryIn in) throws Exception {
        log.info("getWithdrawWaterQuery 9904. in:" + in);
        if (in == null) {
            return new ArrayList<WithdrawWaterQueryOut>();
        }

        try {
            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            in.setFundTime(Integer.parseInt(hms));
            in.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            in.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
            Fun9904Requst requst = new Fun9904Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9904);
            AmResultList<Fun9904Response> responses = amServices
                    .fun9904(requst);
            if (responses == null) {
                // log.warn("9904resp is null");
                return new ArrayList<WithdrawWaterQueryOut>();
            }
            List<WithdrawWaterQueryOut> outs = new ArrayList<WithdrawWaterQueryOut>();
            for (Fun9904Response response : responses) {
                if (response == null) {
                    continue;
                }
                log.info("response : " + response);
                WithdrawWaterQueryOut out = new WithdrawWaterQueryOut();
                BeanUtils.copyProperties(response, out);
//                out.setOrderDateLong(CalendarUtil.convertDateStr2TimeMillis(
//                        out.getOrderDate(),
//                        CalendarUtil.yyyyMMddHHmmssTimeFormate));
                outs.add(out);
            }
            resultLog.info("getWithdrawWaterQuery 9904 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("getWithdrawWaterQuery 9904 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public List<CapitalFlowOut> getCapitalFlows(CapitalFlowIn in) throws Exception {
        log.info("getCapitalFlows 9905. in:" + in);
        if (in == null) {
            return new ArrayList<CapitalFlowOut>();
        }

        // 获得系统当前时间的时分秒部分
        Calendar calendar = Calendar.getInstance();
        Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
        Integer minute = calendar.get(Calendar.MINUTE);
        Integer second = calendar.get(Calendar.SECOND);
        String hms = hour.toString() + minute.toString()
                + second.toString();
        in.setFundTime(Integer.parseInt(hms));
        in.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                .getTimeInMillis()));
        in.setFundSeqId(ConsignmentUtil.getOutterSerialNo());
        Fun9905Requst requst = new Fun9905Requst();
        BeanUtils.copyProperties(in, requst);
        requst.setFunctionId(9905);

        AmResultList<Fun9905Response> responses = amServices.fun9905(requst);
        if (responses == null) {
            return new ArrayList<CapitalFlowOut>();
        }

        List<CapitalFlowOut> outs = new ArrayList<CapitalFlowOut>();
        for (Fun9905Response response : responses) {
            if (response == null) {
                continue;
            }
            CapitalFlowOut out = new CapitalFlowOut();
            BeanUtils.copyProperties(response, out);
//            out.setOrderDateLong(CalendarUtil.convertDateStr2TimeMillis(
//                    out.getOrderDate(),
//                    CalendarUtil.yyyyMMddHHmmssTimeFormate));
            outs.add(out);
        }
        resultLog.info("getCapitalFlows 9905 success. in:" + in + ", out size=" + outs.size() + ", responses size=" + responses.size());
        return outs;
    }

    /**
     * 交易记录统计
     *
     * @param trci
     * @return
     * @throws Exception
     */
    @Override
    public TransactionRecordCountOut getRecordCount(TransactionRecordCountIn trci) throws Exception {
        log.info("getRecordCount 9552. in:" + trci);
        try {
            TransactionRecordCountOut trco = new TransactionRecordCountOut();
            Fun9552Requst requst = new Fun9552Requst();
            trci.setFunctionId(9552);
            BeanUtils.copyProperties(trci, requst);
            requst.setMEntrustStatus(trci.getmEntrustStatus());
            requst.setMStockType(trci.getmStockType());
            Fun9552Response response = amServices.fun9552(requst);
            BeanUtils.copyProperties(response, trco);
            resultLog.info("getRecordCount 9552 success. in:" + trci + ", out:" + trco);
            return trco;
        } catch (Throwable e) {
            resultLog.error("getRecordCount 9552 success. in:" + trci, e);
            throw new Exception(e);
        }
    }

    /**
     * 查询交易记录 9553
     *
     * @param trqi
     * @return
     */
    @Override
    public List<TransactionRecordQueryOut> queryRecord(TransactionRecordQueryIn trqi) throws Exception {
        log.info("queryRecord 9553. in:" + trqi);
        try {
            Fun9553Requst requst = new Fun9553Requst();
            trqi.setFunctionId(9553);
            BeanUtils.copyProperties(trqi, requst);
            requst.setMEntrustStatus(trqi.getmEntrustStatus());
            requst.setMStockType(trqi.getmStockType());
            AmResultList<Fun9553Response> list = amServices.fun9553(requst);
            if (CollectionUtils.isEmpty(list)) {
                return new ArrayList<TransactionRecordQueryOut>();
            }
            List<TransactionRecordQueryOut> result = new ArrayList<TransactionRecordQueryOut>();
            for (Fun9553Response fr : list) {
                if (null == fr) {
                    continue;
                }
                log.info("queryRecord 9553 out:" + fr.toString());
                TransactionRecordQueryOut trqo = new TransactionRecordQueryOut();
                BeanUtils.copyProperties(fr, trqo);
                trqo.setmStockType(fr.getMStockType());
                trqo.setmEntrustStatus(fr.getMEntrustStatus());
                trqo.setcBalance(fr.getCBalance());
                trqo.setbBalance(fr.getBBalance());

//                trqo.setCurrTimeMillisecond(CalendarUtil
//                        .convertDateStr2TimeMillis(
//                                trqo.getDate() + trqo.getTime(),
//                                CalendarUtil.yyyyMMddHHmmssTimeFormate));
                if ((MStockTypeConstant.STOCK_TYPE_EXCHANGE_STOCKS_HONOR_SHARE.equalsIgnoreCase(trqo.getmStockType()) ||
                        MStockTypeConstant.STOCK_TYPE_EXCHANGE_STOCKS_FINANCIAL_ASSETS.equalsIgnoreCase(trqo.getmStockType()))
                        && FundOPBusinessFlagConstant.REDEMPTION.equals(trqo.getBusinessFlag())) {
                    int enStatus = Integer.valueOf(trqo.getmEntrustStatus());
                    switch (enStatus) {
                        case 0:
                            trqo.setStatusDesc("确认中");
                            break;
                        case 6:
                            trqo.setStatusDesc("已撤单");
                            break;
                        case 8:
                            trqo.setStatusDesc("成功");
                            break;
                        case 9:
                            trqo.setStatusDesc("失败");
                            break;
                        default:
                            trqo.setStatusDesc("确认中");
                            break;
                    }
                } else if (EntrustStatusConstant.Failed.equals(trqo
                        .getmEntrustStatus())
                        || TreatStatusConstant.MODIFY_BONUS.equals(trqo
                        .getTreatStatus())
                        || TreatStatusConstant.MODIFY_BONUS9.equals(trqo
                        .getTreatStatus())) {
                    trqo.setStatusDesc("失败");
                    // 购买
                } else if (FundOPBusinessFlagConstant.buyBusinessFlag
                        .contains(trqo.getBusinessFlag())) {
                    if (TreatStatusConstant.REDEMPTION.equals(trqo
                            .getTreatStatus())) {
                        if (EntrustStatusConstant.Success.equals(trqo
                                .getmEntrustStatus())) {
                            trqo.setStatusDesc("成功");
                        } else if (EntrustStatusConstant.Confirmed_Ing
                                .equals(trqo.getmEntrustStatus())
                                || EntrustStatusConstant.To_Confirmed
                                .equals(trqo.getmEntrustStatus())) {
                            trqo.setStatusDesc("已付款");
                        }
                    }
                    // 快速提现
                } else if (FundOPBusinessFlagConstant.withdraw == trqo
                        .getBusinessFlag() || FundOPBusinessFlagConstant.withdraw_shb == trqo.getBusinessFlag()) {
                    if (TreatStatusConstant.MODIFY_BONUS8.equals(trqo
                            .getTreatStatus())) {
                        trqo.setStatusDesc("成功");
                    }
                    // 普通提现
                } else if (FundOPBusinessFlagConstant.withdraw2 == trqo
                        .getBusinessFlag()
                        || FundOPBusinessFlagConstant.REDEMPTION == trqo
                        .getBusinessFlag()) {
                    if (EntrustStatusConstant.Success.equals(trqo
                            .getmEntrustStatus()) && TreatStatusConstant.MODIFY_BONUS8.equals(trqo.getTreatStatus())) {
                        trqo.setStatusDesc("成功");
                    } else if (EntrustStatusConstant.Failed.equals(trqo.getmEntrustStatus())
                            && (TreatStatusConstant.MODIFY_BONUS9.equals(trqo.getTreatStatus()) || "--".equals(trqo.getTreatStatus()))) {
                        trqo.setStatusDesc("失败");
                    } else {
                        trqo.setStatusDesc("确认中");
                    }
                    // 提酒
                } else if (FundOPBusinessFlagConstant.redeem == trqo
                        .getBusinessFlag()) {
                    if (EntrustStatusConstant.Success.equals(trqo
                            .getmEntrustStatus())) {
                        trqo.setStatusDesc("成功");
                    } else {
                        trqo.setStatusDesc("已申请");
                    }
                    // 酒产品到期兑付
                } else if (FundOPBusinessFlagConstant.Spirit_Cash_Buy == trqo
                        .getBusinessFlag()
                        || FundOPBusinessFlagConstant.Spirit_Cash_Redemption == trqo
                        .getBusinessFlag() || FundOPBusinessFlagConstant.Early_Dpl_Repay_Term == trqo
                        .getBusinessFlag()) {
                    if (EntrustStatusConstant.Success.equals(trqo
                            .getmEntrustStatus())) {
                        trqo.setStatusDesc("成功");
                    } else {
                        trqo.setStatusDesc("兑付中");
                    }
                    // 活宝支付||转让卖出
                } else if ((223 == trqo.getBusinessFlag() || FundOPBusinessFlagConstant.Early_Redeem == trqo
                        .getBusinessFlag() || FundOPBusinessFlagConstant.Early_Redeem_Buy == trqo.getBusinessFlag()
                        || FundOPBusinessFlagConstant.Early_Redeem_Retained == trqo.getBusinessFlag()
                        || FundOPBusinessFlagConstant.Early_Redeem_Retained_Buy == trqo.getBusinessFlag())
                        && TreatStatusConstant.REDEMPTION.equals(trqo
                        .getTreatStatus())) {
                    trqo.setStatusDesc("成功");

                    // 新转让卖出(9965)
                } else if (FundOPBusinessFlagConstant.Early_TransDeal_Sellout == trqo.getBusinessFlag()) {
                    String tStr = trqo.getTreatStatus();
                    if (TreatStatusConstant.SUBSCRIBE.equals(tStr) || TreatStatusConstant.REDEMPTION.equals(tStr)) {
                        int enStatus = Integer.valueOf(trqo.getmEntrustStatus());
                        switch (enStatus) {
                            case 0:
                                trqo.setStatusDesc("已申请");
                                break;
                            case 9:
                                trqo.setStatusDesc("失败");
                                break;
                            case 8:
                                trqo.setStatusDesc("已成交");
                                break;
                            case 7:
                                trqo.setStatusDesc("部分成交");
                                break;
                            case 6:
                                trqo.setStatusDesc("已撤销");
                                break;
                            case 5:
                                trqo.setStatusDesc("部分成交");
                                break;

                            default:
                                break;
                        }
                    }

                } else if (FundOPBusinessFlagConstant.Early_Dpl_Repay_In == trqo.getBusinessFlag()
                        || FundOPBusinessFlagConstant.Early_Dpl_Expiry_Repay_In == trqo.getBusinessFlag()) {
                    //首付贷
                    if (TreatStatusConstant.REDEMPTION.equals(trqo
                            .getTreatStatus())) {
                        if (EntrustStatusConstant.Success.equals(trqo
                                .getmEntrustStatus())) {
                            trqo.setStatusDesc("成功");
                        } else if (EntrustStatusConstant.Confirmed_Ing
                                .equals(trqo.getmEntrustStatus())
                                || EntrustStatusConstant.To_Confirmed
                                .equals(trqo.getmEntrustStatus())) {
                            trqo.setStatusDesc("已还款");
                        }
                    } else {
                        trqo.setStatusDesc("失败");
                    }
                } else if (FundOPBusinessFlagConstant.Early_Pz_Drawback == trqo.getBusinessFlag() || FundOPBusinessFlagConstant.Early_Pz_Drawback_Now == trqo.getBusinessFlag()) {
                    //配资--退款
                    if (TreatStatusConstant.MODIFY_BONUS7.equals(trqo.getTreatStatus())) {

                        trqo.setStatusDesc("退款中");


                    } else if (TreatStatusConstant.MODIFY_BONUS8.equals(trqo.getTreatStatus())) {

                        trqo.setStatusDesc("成功");


                    } else if (TreatStatusConstant.MODIFY_BONUS9.equals(trqo.getTreatStatus())) {

                        trqo.setStatusDesc("失败");


                    } else {
                        trqo.setStatusDesc("确认中");
                    }
                }

                if (null == trqo.getStatusDesc()) {
                    trqo.setStatusDesc("确认中");
                }
                result.add(trqo);
            }

            resultLog.info("queryRecord 9553 success. in:" + trqi + ", out size=" + result.size());
            return result;
        } catch (Throwable e) {
            resultLog.error("queryRecord 9553 error. in:" + trqi, e);
            throw new Exception(e);
        }
    }

    @Override
    public SuretyDepositStatOut getSuretyDepositStat(SuretyDepositStatIn in) throws Exception {
        log.info("getSuretyDepositStat 9717. in:" + in);
        try {
            SuretyDepositStatOut out = null;
            Fun9717Requst requst = new Fun9717Requst();
            in.setFunctionId(9717);
            BeanUtils.copyProperties(in, requst);
            AmResultList<Fun9717Response> responseList = amServices.fun9717(requst);

            if (CollectionUtils.isNotEmpty(responseList)) {
                out = new SuretyDepositStatOut();
                Fun9717Response response = responseList.get(0);
                BeanUtils.copyProperties(response, out);
            }
            resultLog.info("getSuretyDepositStat 9717 success. in:" + in + ", out:" + out);
            return out;

        } catch (Throwable e) {
            resultLog.error("getSuretyDepositStat 9717 error, in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public TransferCapitalOut getTransferCapital(TransferCapitalIn in)
            throws Exception {
        log.info("getTransferCapital 9912. in:" + in);
        try {
            TransferCapitalOut out = new TransferCapitalOut();

            // 获得系统当前时间的时分秒部分
            Calendar calendar = Calendar.getInstance();
            Integer hour = calendar.get(Calendar.HOUR_OF_DAY);
            Integer minute = calendar.get(Calendar.MINUTE);
            Integer second = calendar.get(Calendar.SECOND);
            String hms = hour.toString() + minute.toString()
                    + second.toString();
            in.setFundTime(Integer.parseInt(hms));
            in.setFundDate(CalendarUtil.convertTimeMillis2yyyyMMdd(calendar
                    .getTimeInMillis()));
            in.setFundSeqId(ConsignmentUtil.getOutterSerialNo());

            Fun9912Requst requst = new Fun9912Requst();
            in.setFunctionId(9912);
            BeanUtils.copyProperties(in, requst);
            Fun9912Response response = amServices.fun9912(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("getTransferCapital 9912 success. in:" + in + ", out:" + out);
            return out;

        } catch (Throwable e) {
            resultLog.error("getTransferCapital 9912 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public CommonOut insertSpiritDelivery(SpiritDeliveryIn in) throws Exception {
        log.info("insertSpiritDelivery 9950. in:" + in);
        try {

            CommonOut out = new CommonOut();
            Fun9950Requst requst = new Fun9950Requst();
            in.setFunctionId(9950);
            BeanUtils.copyProperties(in, requst);
            Fun9950Response response = amServices.fun9950(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("insertSpiritDelivery 9950 success. in:" + in + ", out:" + out);
            return out;
        } catch (Throwable e) {
            resultLog.error("insertSpiritDelivery 9950 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    @Override
    public Map<String, FixPosition> getFixPosition(CommonIn in) throws Exception {
        log.info("getFixPosition... in:" + in);
        try {
            Map<String, FixPosition> result = new HashMap<String, FixPosition>();
            SpiritPositionIn sin = new SpiritPositionIn();
            sin.setBranchNo(in.getBranchNo());
            sin.setFundAccount(in.getFundAccount());
            sin.setOpEntrustWay(in.getOpEntrustWay());
            sin.setUserId(in.getUserId());
            List<SpiritPosition> list = getSpiritPosition(sin);

            for (SpiritPosition sp : list) {
                FixPosition fp = result.get(sp.getmStockType());
                if (null == fp) {
                    fp = new FixPosition();
                }
                fp.setmStockType(sp.getmStockType());
                List<SpiritPosition> slist = fp.getList();
                if (null == slist) {
                    slist = new ArrayList<SpiritPosition>();
                }
                slist.add(sp);
                fp.setList(slist);
                // 期初份额 合计
                BigDecimal sumCurrentShare = fp.getSumCurrentShare();

                // 已提份额 合计
                BigDecimal sumBackShare = fp.getSumBackShare();

                // 冻结份额 合计
                BigDecimal sumFrozenShare = fp.getSumFrozenShare();

                // 可提份额 合计
                BigDecimal sumEnableShare = fp.getSumEnableShare();

                // 收益 合计
                BigDecimal sumIncomeBalance = fp.getSumIncomeBalance();

                // 本金 合计
                BigDecimal sumCurrentBalance = fp.getSumCurrentBalance();

                // 提酒奖励金额 合计
                BigDecimal sumRewardBalance = fp.getSumRewardBalance();

                if (null == sumCurrentShare) {
                    sumCurrentShare = sp.getCurrentShare();
                } else if (null != sp.getCurrentShare()) {
                    sumCurrentShare = sumCurrentShare.add(sp.getCurrentShare());
                }

                if (null == sumBackShare) {
                    sumBackShare = sp.getBackShare();
                } else if (null != sp.getBackShare()) {
                    sumBackShare = sumBackShare.add(sp.getBackShare());
                }

                if (null == sumFrozenShare) {
                    sumFrozenShare = sp.getFrozenShare();
                } else if (null != sp.getFrozenShare()) {
                    sumFrozenShare = sumFrozenShare.add(sp.getFrozenShare());
                }

                if (null == sumEnableShare) {
                    sumEnableShare = sp.getEnableShare();
                } else if (null != sp.getEnableShare()) {
                    sumEnableShare = sumEnableShare.add(sp.getEnableShare());
                }

                if (null == sumIncomeBalance) {
                    sumIncomeBalance = sp.getIncomeBalance();
                } else if (null != sp.getIncomeBalance()) {
                    sumIncomeBalance = sumIncomeBalance.add(sp
                            .getIncomeBalance());
                }

                if (null == sumCurrentBalance) {
                    sumCurrentBalance = sp.getCurrentBalance();
                } else if (null != sp.getCurrentBalance()) {
                    sumCurrentBalance = sumCurrentBalance.add(sp
                            .getCurrentBalance());
                }

                if (null == sumRewardBalance) {
                    sumRewardBalance = sp.getRewardBalance();
                } else if (null != sp.getRewardBalance()) {
                    sumRewardBalance = sumRewardBalance.add(sp
                            .getRewardBalance());
                }

                fp.setSumBackShare(sumBackShare);
                fp.setSumCurrentBalance(sumCurrentBalance);
                fp.setSumCurrentShare(sumCurrentShare);
                fp.setSumEnableShare(sumEnableShare);
                fp.setSumFrozenShare(sumFrozenShare);
                fp.setSumIncomeBalance(sumIncomeBalance);
                fp.setSumRewardBalance(sumRewardBalance);
                result.put(sp.getmStockType(), fp);
            }
            log.info("getFixPosition success. in:" + in + ", out:" + result);
            return result;
        } catch (Throwable e) {
            log.error("getFixPosition error. in:" + in, e);
            throw new Exception(e);
        }

    }


    @Override
    public List<SpiritDelivery> querySpiritDelivery(SpiritDeliveryQueryIn in)
            throws Exception {
        log.info("querySpiritDelivery 9951. in:" + in);
        if (in == null) {
            return new ArrayList<SpiritDelivery>();
        }
        try {
            Fun9951Requst requst = new Fun9951Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9951);
            AmResultList<Fun9951Response> responses = amServices
                    .fun9951(requst);
            if (responses == null) {
                return new ArrayList<SpiritDelivery>();
            }
            List<SpiritDelivery> outs = new ArrayList<SpiritDelivery>();
            for (Fun9951Response response : responses) {
                if (response == null) {
                    continue;
                }
                SpiritDelivery out = new SpiritDelivery();
                BeanUtils.copyProperties(response, out);
                outs.add(out);
            }
            resultLog.info("querySpiritDelivery 9951 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("querySpiritDelivery 9951 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /**
     * 获取用户已经绑定的普通的银行卡
     *
     * @param fundAccount
     * @param userId
     * @return
     */
    public List<BindingBank> getCardsByType(int fundAccount, String userId, List<String> bankTypeList) throws Exception {
        log.info("getCardsByType 9534. in:[fundAccount:" + fundAccount + ",userId:" + userId + ",bankTypeList:" + bankTypeList + "]");
        try {
            Fun9534Requst request = new Fun9534Requst();
            request.setFundAccount(fundAccount);
            request.setUserId(userId);
            AmResultList<Fun9534Response> responses = amServices.fun9534(request);
            if (CollectionUtils.isEmpty(responses)) {
                return new ArrayList<BindingBank>();
            }
            List<BindingBank> result = new ArrayList<BindingBank>();
            for (Fun9534Response fr : responses) {
                if (null == fr || !bankTypeList.contains(fr.getBankType())) {
                    continue;
                }
                BindingBank bindingBank = new BindingBank();
                BeanUtils.copyProperties(fr, bindingBank);
                result.add(bindingBank);
            }
            Collections.sort(result);
            resultLog.info("getCardsByType 9534 success. in:[fundAccount=" + fundAccount + " userId=" + userId + " bankTypeList " + bankTypeList + "], out size=" + result.size());
            return result;
        } catch (Throwable e) {
            resultLog.error("getCardsByType 9534 error. in:[fundAccount=" + fundAccount + " userId=" + userId + " bankTypeList " + bankTypeList + "]");
            throw new Exception(e);
        }
    }

    @Override
    public SpiritBuyOut buySpirit(SpiritBuyIn in) throws Exception {
        log.info("buySpirit 9956. in:" + in);
        try {
            in.setFunctionId(9956);
            SpiritBuyOut out = new SpiritBuyOut();
            CommonOut sout = signNotice(in.getUserId(), in.getBranchNo(),
                    in.getFundAccount(), in.getFundCompany(), in.getFundCode(),
                    in.getMobiletelephone(), in.getPassword(),
                    in.getChargeType(), in.getOpEntrustWay(),
                    ConsignmentConstant.SignRiskNotice_Electronic);
            if (sout.getErrorNo() != CommonOut.SUCCESS) {
                out.setErrorNo(sout.getErrorNo());
                out.setErrorInfo(sout.getErrorInfo());
                return out;
            }
            Fun9956Requst brequst = new Fun9956Requst();

            BeanUtils.copyProperties(in, brequst,
                    new String[]{"bankNo", "bankAccount", "cashFundCompany",
                            "cashFundCode", "amount"});
            brequst.setFunctionId(9956);
            brequst.setOutterSerialNo(ConsignmentUtil.getOutterSerialNo());
            // 金汇宝份额
            BigDecimal amount = BigDecimal.ZERO;
            // 金汇宝金额
            BigDecimal balance = BigDecimal.ZERO;
            // 银行卡金额
            BigDecimal bankBalance = null;

            if (SpiritBuyIn.PayType_Bank.equals(in.getPayType())) { //银行卡支付
                brequst.setBankAccount(in.getBankAccount());
                brequst.setBankNo(in.getBankNo());

                bankBalance = in.getAmount();

            } else if (SpiritBuyIn.PayType_Bank_Current.equals(in.getPayType())) { //银行卡+金汇宝支付
                brequst.setBankAccount(in.getBankAccount());
                brequst.setBankNo(in.getBankNo());

                brequst.setCashFundCode(in.getCashFundCode());
                brequst.setCashFundCompany(in.getCashFundCompany());
                brequst.setCashChargeType(in.getCashChargeType());

                bankBalance = in.getAmount()
                        .subtract(in.getUserEnableBalance());
                amount = in.getUserEnableShare();
                balance = in.getUserEnableBalance();

            } else if (SpiritBuyIn.PayType_Bank_Redbao.equals(in.getPayType())) { //银行卡+红包支付
                brequst.setBankAccount(in.getBankAccount());
                brequst.setBankNo(in.getBankNo());
                bankBalance = in.getAmount();

                brequst.setOccurBalanceHb(in.getOccurBalanceHb());
                brequst.setPositionStrHb(in.getPositionStrHb());

            } else if (SpiritBuyIn.PayType_Bank_Current_Redbao.equals(in.getPayType())) { //银行卡+金汇宝+红包支付
                brequst.setBankAccount(in.getBankAccount());
                brequst.setBankNo(in.getBankNo());
                brequst.setOccurBalanceHb(in.getOccurBalanceHb());
                brequst.setPositionStrHb(in.getPositionStrHb());

                brequst.setCashFundCode(in.getCashFundCode());
                brequst.setCashFundCompany(in.getCashFundCompany());
                brequst.setCashChargeType(in.getCashChargeType());

                bankBalance = in.getAmount()
                        .subtract(in.getUserEnableBalance());
                amount = in.getUserEnableShare();
                balance = in.getUserEnableBalance();


            } else if (SpiritBuyIn.PayType_Current_Redbao.equals(in.getPayType())) {//金汇宝+红包支付

                brequst.setOccurBalanceHb(in.getOccurBalanceHb());
                brequst.setPositionStrHb(in.getPositionStrHb());

                brequst.setCashFundCode(in.getCashFundCode());
                brequst.setCashFundCompany(in.getCashFundCompany());
                brequst.setCashChargeType(in.getCashChargeType());

                if (in.getUserEnableShare().compareTo(in.getAmount()) >= 0) {
                    amount = in.getAmount();
                } else {
                    amount = in.getUserEnableShare();
                }
                balance = in.getAmount();

            } else {  //金汇宝支付
                brequst.setCashFundCode(in.getCashFundCode());
                brequst.setCashFundCompany(in.getCashFundCompany());
                brequst.setCashChargeType(in.getCashChargeType());

                if (in.getUserEnableShare().compareTo(in.getAmount()) >= 0) {
                    amount = in.getAmount();
                } else {
                    amount = in.getUserEnableShare();
                }
                balance = in.getAmount();
            }

            brequst.setAmount(amount);
            brequst.setBalance(balance);
            brequst.setBankBalance(bankBalance);

            Fun9956Response bresult = amServices.fun9956(brequst);
            out.setErrorNo(bresult.getErrorNo());
            out.setErrorInfo(bresult.getErrorInfo());
//            out.setSerialNo(bresult.getSerialNo());
            out.setForwardParams(bresult.getForwardParams());
            out.setSerialNoTrans(bresult.getSerialNoTrans());
            resultLog.info("buySpirit 9956 success. in:" + in + ", out:" + out);
            return out;
        } catch (Throwable e) {
            resultLog.error("buySpirit 9956 error. in:" + in, e);
            throw new Exception(e);
        }
    }


    @Override
    public AutoDocBailClearOut autoDocBailClear(AutoDocBailClearIn in)
            throws Exception {
        log.info("autoDocBailClear 9752. in:" + in);
        try {
            AutoDocBailClearOut out = new AutoDocBailClearOut() ;
            Fun9752Requst requst = new Fun9752Requst();
            in.setFunctionId(9752);
            BeanUtils.copyProperties(in, requst);
//			requst.setOpbusinessFlag(in.getOpBusinessFlag());
            requst.setOpEntrustWay(in.getOpEntrustWay());
            Fun9752Response response = amServices.fun9752(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("autoDocBailClear 9752 success. in:" + in + ", out:" + out);
            return out;
        } catch (Throwable e) {
            resultLog.error("autoDocBailClear 9752 error. in:" + in, e);
            throw new Exception(e);
        }
    }


    @Override
    public AutoDocBailRechargeOut autoDocBailRecharge(AutoDocBailRechargeIn in)
            throws Exception {
        log.info("autoDocBailRecharge 9751. in:" + in);
        try {
            AutoDocBailRechargeOut out = new AutoDocBailRechargeOut();
            Fun9751Requst requst = new Fun9751Requst();
            in.setFunctionId(9751);
            BeanUtils.copyProperties(in, requst, new String[]{"bankNoDk", "bankAccountDk", "fundCompanyBack", "fundCodeBack", "chargeTypeBack"});
            requst.setOpbusinessFlag(in.getOpbusinessFlag());
            requst.setOpEntrustWay(in.getOpEntrustWay());
            // 金汇宝份额
            BigDecimal amount = BigDecimal.ZERO;
            // 银行卡金额
            BigDecimal bankBalance = null;
//            if (AutoDocBailRechargeIn.PayType_Bank.equals(in.getPayType())) { //银行卡支付
            requst.setBankAccountDk(in.getBankAccountDk());
            requst.setBankNoDk(in.getBankNoDk());

            bankBalance = in.getOccurBalanceG();
//            } else if (AutoDocBailRechargeIn.PayType_Bank_Current.equals(in.getPayType())) { //银行卡+金汇宝支付
//                requst.setBankAccountDk(in.getBankAccountDk());
//                requst.setBankNoDk(in.getBankNoDk());
//                requst.setFundCodeBack(in.getFundCodeBack());
//                requst.setFundCompanyBack(in.getFundCompanyBack());
//                requst.setChargeTypeBack(in.getChargeTypeBack());
//
//                bankBalance = in.getOccurBalanceG().subtract(in.getUserEnableBalance());
//                amount = in.getUserEnableShare();
//            } else if (AutoDocBailRechargeIn.PayType_Current.equals(in.getPayType())) {  //金汇宝支付
//                requst.setFundCompanyBack(in.getFundCompanyBack());
//                requst.setFundCodeBack(in.getFundCodeBack());
//                requst.setChargeTypeBack(in.getChargeTypeBack());
//                if (in.getUserEnableShare().compareTo(in.getOccurBalanceG()) >= 0) {
//                    amount = in.getOccurBalanceG();
//                } else {
//                    amount = in.getUserEnableShare();
//                }
//            }
            //活宝使用额
            requst.setShareBack(amount);
            in.setShareBack(amount);
            //银行卡使用额
            requst.setBankBalance(bankBalance);
            in.setBankBalance(bankBalance);
            log.info("request : ");
            Fun9751Response response = amServices.fun9751(requst);
            BeanUtils.copyProperties(response, out);
            log.info("autoDocBailRecharge 9751 success. in:" + in + ", out:" + out);
            out.setErrorNo(getRightErrorNumber(out.getErrorNo(),out.getErrorInfo()));
            return out;
        } catch (Throwable e) {
            log.error("autoDocBailRecharge 9751 error. in:" + in, e);
            throw new Exception(e);
        }
    }

    /*
     * <p>Title: increaseLevelOfCreditOut</p>
     * <p>Description: 9911 提升信用等级</p>
     * @param in
     * @return
     * @throws ServiceException
     * @see com.gemantic.wealth.consignment.service.ConsignmentService#increaseLevelOfCreditOut(com.gemantic.wealth.consignment.model.in.IncreaseLevelOfCreditIn)
     */
    @Override
    public IncreaseLevelOfCreditOut increaseLevelOfCreditOut(
            IncreaseLevelOfCreditIn in) throws Exception {
        log.info("increaseLevelOfCreditOut 9911. in:" + in);
        try {
            IncreaseLevelOfCreditOut out = new IncreaseLevelOfCreditOut() ;
            Fun9911Requst requst = new Fun9911Requst();
            in.setFunctionId(9911);
            BeanUtils.copyProperties(in, requst);
            Fun9911Response response = amServices.fun9911(requst);
            BeanUtils.copyProperties(response, out);
            resultLog.info("increaseLevelOfCreditOut 9911 success. in:" + in + ", out:" + out);

            return out;
        } catch (Throwable e) {
            resultLog.error("increaseLevelOfCreditOut 9911 error. in:" + in, e);
            throw new Exception(e);
        }
    }


    private Integer getRightErrorNumber(int errono,String errorInfo){
        if(errono >= 0){
            return  errono;
        }
        else{
            int idx = errorInfo.indexOf("RC");
            if(idx==0){
                idx= errorInfo.indexOf("Z");
            }
            String num = "6666600"+errorInfo.substring(idx+2,idx+4);
            return  Integer.parseInt(num);
        }

    }


    @Override
    public FundBuyOut buyFund(FundBuyIn fundBuyIn, String mobile) throws Exception {

        log.info("buyFund 9509. in:" + fundBuyIn);

        if (fundBuyIn == null) {
            return null;
        }

        FundBuyOut fundBuyOut = new FundBuyOut();

        try {
            CommonOut sout = signNotice(fundBuyIn.getUserId(), fundBuyIn.getBranchNo(),
                    fundBuyIn.getFundAccount(), fundBuyIn.getFundCompany(), fundBuyIn.getFundCode(),
                    mobile, fundBuyIn.getPassword(),
                    fundBuyIn.getChargeType(), fundBuyIn.getOpEntrustWay(),
                    ConsignmentConstant.SignRiskNotice_Electronic);
            log.info("sout : " + sout.getErrorNo());
            if (sout.getErrorNo() != CommonOut.SUCCESS) {
                fundBuyOut.setErrorNo(sout.getErrorNo());
                fundBuyOut.setErrorInfo(sout.getErrorInfo());
                return fundBuyOut;
            }

            Fun9509Requst requst = new Fun9509Requst();
            BeanUtils.copyProperties(fundBuyIn, requst);
            requst.setFunctionId(9509);
            fundBuyIn.setFunctionId(requst.getFunctionId());
            Fun9509Response response = amServices.fun9509(requst);
            if (response == null) {
                return null;
            }

            BeanUtils.copyProperties(response, fundBuyOut);

            resultLog.info("buyFund 9509 success. in:" + fundBuyIn + ", out:" + fundBuyOut);
            return fundBuyOut;
        } catch (Throwable e) {
            resultLog.error("buyFund 9509 error. in:" + fundBuyIn, e);
            throw new Exception(e);
        }
    }

    /**
     * 基金赎回
     */
    @Override
    public RedeemOut redeem(RedeemIn ri) throws Exception {
        log.info("redeem 9511. in:" + ri);
        RedeemOut ro = new RedeemOut();
        try {
            Fun9511Requst request = new Fun9511Requst();
            request.setFunctionId(9511);
            ri.setFunctionId(request.getFunctionId());
            BeanUtils.copyProperties(ri, request);
            Fun9511Response response = amServices.fun9511(request);
            BeanUtils.copyProperties(response, ro);
            resultLog.info("redeem 9511 success. in:" + ri + ", out:" + ro);
        } catch (Throwable e) {
            resultLog.error("redeem 9511 error. in:" + ri, e);
            throw new Exception(e);
        }
        return ro;
    }

    @Override
    public List<CurrentPositionStat> getCurrentPositionStat(CurrentPositionStatIn in) throws Exception {
        log.info("getCurrentPositionStat 9983. in:" + in);
        try {
            Fun9983Requst requst = new Fun9983Requst();
            BeanUtils.copyProperties(in, requst);
            requst.setFunctionId(9983);
            Long start = System.currentTimeMillis();
            AmResultList<Fun9983Response> responses = amServices.fun9983(requst);
            Long end = System.currentTimeMillis();
            log.info("id : 9983 , time total:" + (end - start));
            if (responses == null) {
                return new ArrayList<CurrentPositionStat>();
            }
            List<CurrentPositionStat> outs = new ArrayList<CurrentPositionStat>();
            for (Fun9983Response response : responses) {
                if (response == null) {
                    continue;
                }
                CurrentPositionStat out = new CurrentPositionStat();
                BeanUtils.copyProperties(response, out);

                out.setSettledBalance(out.getIncomeBalance());
                if (null != out.getIncomeBalance()
                        && null != out.getUnsettledBalance()) {
                    out.setSettledBalance(out.getIncomeBalance().subtract(
                            out.getUnsettledBalance()));
                }
                outs.add(out);
            }
            resultLog.info("getCurrentPositionStat 9983 success. in:" + in + ", out size=" + outs.size());
            return outs;
        } catch (Throwable e) {
            resultLog.error("getCurrentPositionStat 9983 error. in:" + in+" functionId 9983", e);
            throw new Exception(e);
        }
    }

//    @Override
//    public List<SpiritDelivery> querySpiritDelivery(SpiritDeliveryQueryIn in) throws Exception {
//        log.info("querySpiritDelivery 9951. in:" + in);
//        if (in == null) {
//            return new ArrayList<SpiritDelivery>();
//        }
//        try {
//            Fun9951Requst requst = new Fun9951Requst();
//            BeanUtils.copyProperties(in, requst);
//            requst.setFunctionId(9951);
//            AmResultList<Fun9951Response> responses = amServices
//                    .fun9951(requst);
//            if (responses == null) {
//                return new ArrayList<SpiritDelivery>();
//            }
//            List<SpiritDelivery> outs = new ArrayList<SpiritDelivery>();
//            for (Fun9951Response response : responses) {
//                if (response == null) {
//                    continue;
//                }
//                SpiritDelivery out = new SpiritDelivery();
//                BeanUtils.copyProperties(response, out);
//                outs.add(out);
//            }
//            resultLog.info("querySpiritDelivery 9951 success. in:" + in +", out size=" + outs.size());
//            return outs;
//        } catch (Throwable e) {
//            resultLog.error("querySpiritDelivery 9951 error. in:" + in, e);
//            throw new Exception(e);
//        }
//    }
}
