package com.ptteng.wealth.consign.service;

import com.ptteng.wealth.consign.model.in.*;
import com.ptteng.wealth.consign.model.out.*;
import com.ptteng.wealth.user.model.User;
import org.osoa.sca.annotations.Remotable;

import java.util.List;
import java.util.Map;

/**
 * Created by arthur on 16/5/28.
 */
@Remotable
public interface ConsignmentService {

    /**
     * 开户
     *
     * @param in
     * @return
     */
    OpenAccountOut openAccount(OpenAccountIn in) throws Exception;

    /**
     * 获取客户信息
     *
     * @param userId
     * @return
     */
    CustomerInfo getCustomerInfo(String userId) throws Exception;

    /**
     * 获取用户已经绑定的银行信息
     *
     * @param fundAccount
     * @param userId
     * @return
     */
    List<BindingBank> getBanks(int fundAccount, String userId) throws Exception;

    /**
     * 获取用户已经绑定的银行信息
     *
     * @param in
     * @return
     */
    List<BindingBank> getBindingBanks(BindingBankIn in) throws Exception;

    /**
     * 银行卡绑定
     *
     */
    CardBindingOut cardBinding(CardBindingIn in) throws Exception;

    /**
     * 修改交易密码
     *
     * @param tpi
     * @return
     */
    CommonOut modifyTransactionPassword(TransactionPasswordIn tpi) throws Exception;

    /**
     * 找回交易密码(9505)
     *
     * @return
     * @throws Exception
     */
    CommonOut retrieveTransactionPassword(RetrieveTransactionPasswordIn in) throws Exception;

    /**
     * 机构开户
     *
     * @param in
     * @return
     */
    OpenAccountOut openOrgan(OrganOpenAccountIn in) throws Exception;

    /**
     * 机构银行卡绑定
     *
     */
    CardBindingOut orgBindcard(OrganBindCardIn in) throws Exception;

    /**
     * 获取机构信息
     *
     * @param organInfoIn
     * @return
     */
    OrganInfo getOrganInfo(OrganInfoIn organInfoIn) throws Exception;

    /**
     * 取消银行卡 9545
     *
     * @param in
     * @return
     * @throws Exception
     */
    CancelCardOut cancelCard(CancelCardIn in) throws Exception;

    /**
     * 9542，此接口暂时不可用
     *
     * @param ai
     * @return
     */
    @Deprecated
    CommonOut modifyAccountInfo(AccountInfoIn ai) throws Exception;

    /**
     * 客户个人信息修改（9543）
     *
     * @return
     * @throws Exception
     */
    CommonOut modifyPersonalInfo(PersonalInfoIn pii) throws Exception;

    /**
     * P2P配资贷保证金充值(9711)
     * @Title: bailRecharge
     * @return BailRechargeOut
     * @throws Exception
     */
    BailRechargeOut bailRecharge(BailRechargeIn in) throws Exception ;

    /**
     * 修改用户风险等级
     *
     * @param in
     * @return
     */
    RiskLevelModifyOut modifyRiskLevel(RiskLevelModifyIn in) throws Exception;

    /**
     * 获取余额提现限制（9909）
     *
     * @param in
     * @return
     * @throws Exception
     */
    WithdrawLimitOut getWithdrawLimit(WithdrawLimitIn in) throws Exception;

    /**
     * 充值
     *
     * @param ri
     * @return
     * @throws Exception
     */
    // @Deprecated
    RechargeOut recharge(RechargeIn ri) throws Exception;

    /**
     * 充值-网关 9906
     *
     * @param ri
     * @return
     * @throws Exception
     */
    // @Deprecated
    RechargeOut rechargeGateway(RechargeIn ri) throws Exception;

    /**
     * 大额帐号提现 9901
     *
     * @param wc
     * @return
     */
    WithdrawCashOut withdraw(WithdrawCashIn wc) throws Exception;

    /**
     * 证联融通-线下充值通知(107/207) 9907
     *
     * @param in
     * @return
     * @throws Exception
     */
    OfflineRechargeOut rechargeOffline(OfflineRechargeIn in) throws Exception;

    /**
     * 证联融通-线下充值流水查询(509/609) 9908
     *
     * @param in
     * @return
     * @throws Exception
     */
    List<OfflineRecharge> getRechargeOfflineRecord(OfflineRechargeQueryIn in) throws Exception;

    /**
     * 产品持仓查询（暂支持酒交所产品）9957
     *
     * @param in
     * @return
     * @throws Exception
     */
    List<SpiritPosition> getSpiritPosition(SpiritPositionIn in) throws Exception;

    /**
     * 产品持仓汇总查询（暂支持酒交所产品） 9958
     *
     * @param in
     * @return
     * @throws Exception
     */
    SpiritPositionStat getSpiritPositionStat(SpiritPositionStatIn in) throws Exception;

    /**
     * 获取总持仓(9959)
     *
     * @param in
     * @return
     * @throws Exception
     */
    Position getPosition(PositionIn in) throws Exception;

    /**
     * 申购在途资金查询(9960)
     *
     * @param in
     * @return
     * @throws Exception
     */
    List<UncomeBalanceRecord> getUncomeBalanceRecord(UncomeBalanceIn in) throws Exception;

    /**
     * 持仓滚存设置（9963）
     *
     * @param in
     * @return
     * @throws Exception
     */
    CommonOut setUpDefer(DeferIn in) throws Exception;

    /**
     * 金汇宝-收益流水查询 9984
     *
     * @param in
     * @return
     * @throws Exception
     */
    List<CurrentIncomeRecord> getCurrentIncomeRecord(CurrentIncomeRecordIn in) throws Exception;

    /**
     * 金汇宝-收益流水查询记录总数 9985
     *
     * @param in
     * @return
     * @throws Exception
     */
    Integer getCurrentIncomeRecordCount(CurrentIncomeRecordIn in) throws Exception;

    /**
     * 借贷项目信息明细 (9701)
     * @Title: getLoanInfo
     * @return List<LoanInfoOut>
     * @throws Exception
     */
    List<LoanInfoOut> getLoanInfo(LoanInfoIn in) throws Exception ;

    /**
     * 还款计划汇总 (9702)
     * @Title: getRepaymentPlanStat
     * @return RepaymentPlanStatOut
     * @throws Exception
     */
    RepaymentPlanStatOut getRepaymentPlanStat(RepaymentPlanStatIn in) throws Exception ;

    /**
     * 还款计划明细 (9703)
     * @Title: getRepaymentPlan
     * @return List<RepaymentPlanOut>
     * @throws Exception
     */
    List<RepaymentPlanOut> getRepaymentPlan(RepaymentPlanIn in) throws Exception ;

    /**
     * 大额帐号余额 9902
     *
     * @param bii
     * @return
     */
    BalanceInquiryOut getBalance(BalanceInquiryIn bii) throws Exception;

    /**
     * 证联融通-充值流水查询(9903)
     *
     * @param in
     * @return
     * @throws Exception
     */
    // @Deprecated
    List<RechargeWaterQueryOut> getRechargeWaterQuery(RechargeWaterQueryIn in) throws Exception;

    /**
     * 证联融通-提现流水查询(9904)
     *
     * @param in
     * @return
     * @throws Exception
     */
    List<WithdrawWaterQueryOut> getWithdrawWaterQuery(WithdrawWaterQueryIn in) throws Exception;

    /**
     * 证联融通-余额流水查询 9905
     *
     * @param in
     * @return
     * @throws Exception
     */

    List<CapitalFlowOut> getCapitalFlows(CapitalFlowIn in) throws Exception;

    /**
     * 交易记录统计总记录数 9552 酒交所产品交易记录 mStockType=6 金汇宝交易记录转入 mStockType=8
     * businessFlag=222 金汇宝交易记录转出 mStockType=8 businessFlag=224
     *
     * @param trci
     * @return
     * @throws Exception
     */
    TransactionRecordCountOut getRecordCount(TransactionRecordCountIn trci) throws Exception;


    /**
     * 查询交易记录 9553 酒交所产品交易记录 mStockType=6 金汇宝交易记录转入 mStockType=8
     * businessFlag=222 金汇宝交易记录转出 mStockType=8 businessFlag=224
     *
     * @param trqi
     * @return
     */
    List<TransactionRecordQueryOut> queryRecord(TransactionRecordQueryIn trqi) throws Exception;

    /**
     * 证联融通-资金调拨(9912)
     * @param in
     * @return TransferCapitalOut
     * @throws Exception
     *
     */
    TransferCapitalOut getTransferCapital(TransferCapitalIn in)  throws Exception ;

    /**
     *
     * @Title: getMessageCode
     * @Description: 证联融通-获取短信验证码(9910)
     * @param in
     * @return
     * @throws Exception
     */
    MessageAuthenticationCodeOut getMessageCode(MessageAuthenticationCodeIn in) throws Exception;

    /**
     * 设置主卡 9503
     *
     * @param in
     * @return
     * @throws Exception
     */
    MainCardOut setMainCard(MainCardIn in) throws Exception;

    /**
     * 借贷项目信息汇总 (9700)
     * @Title: getLoanInfoStat
     * @return LoanInfoStatOut
     * @throws Exception
     */
    LoanInfoStatOut getLoanInfoStat(LoanInfoStatIn in) throws Exception ;

    /**
     * 借贷项目金额汇总 (9710)
     * @param loanMoneyStatIn
     * @return LoanMoneyStatOut
     * @throws Exception
     *
     */
    LoanMoneyStatOut getLoanMoneyStat(LoanMoneyStatIn loanMoneyStatIn)  throws Exception ;

    /**
     * 担保人风险金保证金汇总(9717)
     * @param in
     * @return
     * @throws Exception
     *
     */
    SuretyDepositStatOut getSuretyDepositStat(SuretyDepositStatIn in)  throws Exception ;

    /**
     * 插入提货申请 9950
     *
     * @param in
     * @return
     * @throws Exception
     */
    CommonOut insertSpiritDelivery(SpiritDeliveryIn in) throws Exception;


    /**
     * 产品持仓查询，包含mStockType作为分类的统计（9957）
     *
     * @param in
     * @return
     */
    Map<String, FixPosition> getFixPosition(CommonIn in) throws Exception;
    /**
     * 查询提货申请信息 9951
     *
     * @param in
     * @return
     */
    List<SpiritDelivery> querySpiritDelivery(SpiritDeliveryQueryIn in) throws Exception;


    /**
     * 获取指定类型的银行卡
     *
     * @param fundAccount
     * @param userId
     * @return
     */
    List<BindingBank> getCardsByType(int fundAccount, String userId,
                                     List<String> bankTypeList) throws Exception;

    /**
     * 酒交所产品购买 9956
     *
     * @param in
     * @return
     */
    SpiritBuyOut buySpirit(SpiritBuyIn in) throws Exception;


    /**
     * 自动跟单保证金充值(9751)
     * @Title: autoDocBailRecharge
     * @return AutoDocBailRechargeOut
     * @throws Exception
     */
    AutoDocBailRechargeOut autoDocBailRecharge(AutoDocBailRechargeIn in) throws Exception ;

    /**
     *
     * @Title: increaseLevelOfCreditOut
     * @Description: 证联融通-客户信用等级提升(9911)
     * @param in
     * @return
     */
    IncreaseLevelOfCreditOut increaseLevelOfCreditOut(IncreaseLevelOfCreditIn in) throws Exception;

    /**
     * 自动跟单清算兑付(9752)
     * @Title: autoDocBailClear
     * @return AutoDocBailClearOut
     */
    AutoDocBailClearOut autoDocBailClear(AutoDocBailClearIn in) throws Exception ;

    /**
     * 申购基金
     *
     * @param fundBuyIn
     * @return
     */
    FundBuyOut buyFund(FundBuyIn fundBuyIn, String mobile) throws Exception;

    /**
     * 基金赎回 (普通提现)
     *
     * @param ri
     * @return
     */
    RedeemOut redeem(RedeemIn ri) throws Exception;

    /**
     * 金汇宝-持仓查询 9983
     *
     * @param in
     * @return
     * @throws Exception
     */
    List<CurrentPositionStat> getCurrentPositionStat(CurrentPositionStatIn in) throws Exception;

}
