package com.ptteng.wealth.consign.model.out;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 证联融通-提现流水查询(9904)
 * 
 */
public class WithdrawWaterQueryOut implements Serializable {
	private static final long serialVersionUID = 8239904691335943291L;
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户的时间戳，HHMMSS
	private int fundTime;
	// 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	// 当前页数
	private int currentPage;
	// 当前页显示条数
	private int pageSize;
	// 总页数
	private int totalPage;
	// 应答码，参考附录
	private String respCode;
	// 业务应答描述
	private String respDesc;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;
	// 证联融通的流水号
	private String pnrSeqId;
	// 银行代码，参见附录
	private String bankCode;
	// 银行卡号
	private String cardNo;
	// 提现金额
	private BigDecimal transAmt;
	// 提现申请日期
	private String orderDate;
	/**
	 * 提现申请日期毫秒
	 */
	private Long orderDateLong;

	// 提现记录状态
	private String status;

	/**
	 * 提现类型，00普通提现，01快速提现
	 */
	private String orderType;

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public int getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(int totalPage) {
		this.totalPage = totalPage;
	}

	public String getRespCode() {
		return respCode;
	}

	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

	public String getRespDesc() {
		return respDesc;
	}

	public void setRespDesc(String respDesc) {
		this.respDesc = respDesc;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String getPnrSeqId() {
		return pnrSeqId;
	}

	public void setPnrSeqId(String pnrSeqId) {
		this.pnrSeqId = pnrSeqId;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public BigDecimal getTransAmt() {
		return transAmt;
	}

	public void setTransAmt(BigDecimal transAmt) {
		this.transAmt = transAmt;
	}

	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	
	public void setOrderDateLong(Long orderDateLong) {
		this.orderDateLong = orderDateLong;
	}

	
	
	public Long getOrderDateLong() {
		return orderDateLong;
	}

	/**
	 * @return the orderType
	 */
	public String getOrderType() {
		return orderType;
	}

	/**
	 * @param orderType the orderType to set
	 */
	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
}
