package com.ptteng.wealth.consign.model.out;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

public class WithdrawCashOut extends CommonOut {
	private static final long serialVersionUID = -8981823779415074913L;
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户的时间戳，HHMMSS
	private int fundTime;
	// 商户系统流水号。需要保证一个交易日中流水号的唯一性
	private String fundSeqId;
	// 银行代码，参见附录
	private String bankCode;
	// 提现银行卡号
	private String cardNo;
	// 证联融通发起交易的系统日期，YYYYMMDD
	private int pnrDate;
	// 证联融通发给基金的时间戳，HHMMSS
	private int pnrTime;
	// 证联融通的流水号。需要保证一个交易日中流水号的唯一性
	private String pnrSeqId;
	// 提现金额
	private BigDecimal transAmt;
	// 应答码，参考附录
	private String respCode;
	// 业务应答描述
	private String respDesc;
	// 保留域，接收方必须原样回送该字段数据
	private String resv;

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	public String getCardNo() {
		return cardNo;
	}

	public void setCardNo(String cardNo) {
		this.cardNo = cardNo;
	}

	public int getPnrDate() {
		return pnrDate;
	}

	public void setPnrDate(int pnrDate) {
		this.pnrDate = pnrDate;
	}

	public int getPnrTime() {
		return pnrTime;
	}

	public void setPnrTime(int pnrTime) {
		this.pnrTime = pnrTime;
	}

	public String getPnrSeqId() {
		return pnrSeqId;
	}

	public void setPnrSeqId(String pnrSeqId) {
		this.pnrSeqId = pnrSeqId;
	}

	public BigDecimal getTransAmt() {
		return transAmt;
	}

	public void setTransAmt(BigDecimal transAmt) {
		this.transAmt = transAmt;
	}

	public String getRespCode() {
		return respCode;
	}

	public void setRespCode(String respCode) {
		if(RESPCODE_SUCCESS.equals(respCode)){
			setErrorNo(SUCCESS);
		}else if("RC30".equals(respCode)){
			setErrorNo(PROCESSING);
		}else {
			setErrorNo(SOCKET_ERROR);
		}
		this.respCode = respCode;
	}

	public String getRespDesc() {
		return respDesc;
	}

	public void setRespDesc(String respDesc) {
		this.respDesc = respDesc;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}
	
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	
}
