package com.ptteng.wealth.consign.model.out;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 
 * @ClassName: TransferCapitalOut
 * @Description: 证联融通-资金调拨(9912)
 * @author ykwang
 * @date 2015-5-8 上午11:26:04
 * 
 */
public class TransferCapitalOut extends CommonOut {

	private static final long serialVersionUID = -509530248450454814L;
	
	// 商户的系统日期，YYYYMMDD
	private int fundDate;
	// 商户系统流水号
	private String fundSeqId;
	// 证联融通的流水号
	private String pnrSeqId;
	// 应答码，参考附录
	private String respCode;
	// 业务应答描述
	private String respDesc;
	// 保留域
	private String resv;
	
	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public String getPnrSeqId() {
		return pnrSeqId;
	}

	public void setPnrSeqId(String pnrSeqId) {
		this.pnrSeqId = pnrSeqId;
	}

	public String getRespCode() {
		return respCode;
	}

	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

	public String getRespDesc() {
		return respDesc;
	}

	public void setRespDesc(String respDesc) {
		this.respDesc = respDesc;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
}
