package com.ptteng.wealth.consign.model.out;

import org.apache.commons.lang3.StringUtils;

import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 交易记录查询（9553）
 * 
 * @author user
 * 
 */
public class TransactionRecordQueryOut extends CommonOut {

	private static final long serialVersionUID = -4685867702878578080L;
	// 结果集条数
	private int rowcount;
	// 发生日期
	private int currDate;
	// 发生时间
	private int currTime;

	// 发生日期时间
	private Long currTimeMillisecond;

	// 业务类别
	private int businessFlag;
	// 交易状态
	private String mEntrustStatus;
	// 扣款状态
	private String treatStatus;
	// 基金简称
	private String codesimpleName;
	// 发生金额
	private BigDecimal balance;
	// 发生份额
	private BigDecimal shares;
	// 手续费
	private BigDecimal fareSx;
	// 银行编号
	private String bankNo;
	// 银行卡号
	private String bankAccount;
	// 基金代码
	private String fundCode;
	// 前后收费类型
	private String chargeType;
	// 产品类型
	private String mStockType;
	// 红利方式
	private String bonusType;
	// 备注
	private String remark;

	// 支付方式，0 银行卡；4 金汇宝；5 金汇宝+银行卡
	private String payType;

	// 银行卡支付的金额,payType=5时候使用
	private BigDecimal bBalance;

	// 支付的总金额=balance
	private BigDecimal cBalance;

	// payType=5时候使用,用户支付银行卡号
	private String otherBankNo;

	// payType=5时候使用,用户支付银行帐号
	private String otherBankAccount;

	// 状态描述,显示交易记录的合并状态
	private String statusDesc;
	// 外部流水号
	private String outerSerialNo;
	//红包使用金额
	private BigDecimal occurBalanceHb;
	//红包标识串(标识唯一一个红包)
	private String positionStrHb;

	//处理标志
	private String dealFlag;




	public String getDealFlag() {
		return dealFlag;
	}

	public void setDealFlag(String dealFlag) {
		this.dealFlag = dealFlag;
	}

	/**
	 * @return the occurBalanceHb
	 */
	public BigDecimal getOccurBalanceHb() {
		return occurBalanceHb;
	}

	/**
	 * @param occurBalanceHb the occurBalanceHb to set
	 */
	public void setOccurBalanceHb(BigDecimal occurBalanceHb) {
		this.occurBalanceHb = occurBalanceHb;
	}

	/**
	 * @return the positionStrHb
	 */
	public String getPositionStrHb() {
		return positionStrHb;
	}

	/**
	 * @param positionStrHb the positionStrHb to set
	 */
	public void setPositionStrHb(String positionStrHb) {
		this.positionStrHb = positionStrHb;
	}


	public int getRowcount() {
		return rowcount;
	}

	public void setRowcount(int rowcount) {
		this.rowcount = rowcount;
	}

	public int getCurrDate() {
		return currDate;
	}

	public String getDate() {
		return Integer.toString(currDate);
	}

	public void setCurrDate(int currDate) {
		this.currDate = currDate;
	}

	public int getBusinessFlag() {
		return businessFlag;
	}

	public String getBusinessFlagStr() {
		return Integer.toString(businessFlag);
	}

	public void setBusinessFlag(int businessFlag) {
		this.businessFlag = businessFlag;
	}

	public String getmEntrustStatus() {
		return mEntrustStatus;
	}

	public void setmEntrustStatus(String mEntrustStatus) {
		this.mEntrustStatus = mEntrustStatus;
	}

	public String getTreatStatus() {
		return treatStatus;
	}

	public void setTreatStatus(String treatStatus) {
		this.treatStatus = treatStatus;
	}

	public String getCodesimpleName() {
		return codesimpleName;
	}

	public void setCodesimpleName(String codesimpleName) {
		this.codesimpleName = codesimpleName;
	}

	public BigDecimal getBalance() {
		return balance;
	}

	public void setBalance(BigDecimal balance) {
		this.balance = balance;
	}

	public BigDecimal getShares() {
		return shares;
	}

	public void setShares(BigDecimal shares) {
		this.shares = shares;
	}

	public BigDecimal getFareSx() {
		return fareSx;
	}

	public void setFareSx(BigDecimal fareSx) {
		this.fareSx = fareSx;
	}

	public String getBankNo() {
		return bankNo;
	}

	public void setBankNo(String bankNo) {
		this.bankNo = bankNo;
	}

	public String getBankAccount() {
		return bankAccount;
	}

	public void setBankAccount(String bankAccount) {
		this.bankAccount = bankAccount;
	}

	public String getFundCode() {
		return fundCode;
	}

	public void setFundCode(String fundCode) {
		this.fundCode = fundCode;
	}

	public String getChargeType() {
		return chargeType;
	}

	public void setChargeType(String chargeType) {
		this.chargeType = chargeType;
	}

	public String getmStockType() {
		return mStockType;
	}

	public void setmStockType(String mStockType) {
		this.mStockType = mStockType;
	}

	public String getBonusType() {
		return bonusType;
	}

	public void setBonusType(String bonusType) {
		this.bonusType = bonusType;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public int getCurrTime() {
		return currTime;
	}

	public String getPayType() {
		return payType;
	}

	public void setPayType(String payType) {
		this.payType = payType;
	}

	public BigDecimal getbBalance() {
		return bBalance;
	}

	public void setbBalance(BigDecimal bBalance) {
		this.bBalance = bBalance;
	}

	public BigDecimal getcBalance() {
		return cBalance;
	}

	public void setcBalance(BigDecimal cBalance) {
		this.cBalance = cBalance;
	}

	public Long getCurrTimeMillisecond() {
		return currTimeMillisecond;
	}

	public void setCurrTimeMillisecond(Long currTimeMillisecond) {
		this.currTimeMillisecond = currTimeMillisecond;
	}

	public String getTime() {
		String time = Integer.toString(currTime);
		if (time.length() < 6) {
			time = StringUtils.leftPad(time, 6, "0");
		}
		return time;
	}

	public void setCurrTime(int currTime) {
		this.currTime = currTime;
	}

	public String getOtherBankNo() {
		return otherBankNo;
	}

	public void setOtherBankNo(String otherBankNo) {
		this.otherBankNo = otherBankNo;
	}

	public String getOtherBankAccount() {
		return otherBankAccount;
	}

	public void setOtherBankAccount(String otherBankAccount) {
		this.otherBankAccount = otherBankAccount;
	}

	public String getStatusDesc() {
		return statusDesc;
	}

	public void setStatusDesc(String statusDesc) {
		this.statusDesc = statusDesc;
	}

	public String getOuterSerialNo() {
		return outerSerialNo;
	}

	public void setOuterSerialNo(String outerSerialNo) {
		this.outerSerialNo = outerSerialNo;
	}

}
