package com.ptteng.wealth.consign.model.out;

import java.math.BigDecimal;
import java.math.BigInteger;

/**
 * 酒交所持仓查询 (9957)
 */
public class SpiritPosition extends CommonOut {

	private static final long serialVersionUID = 8793918660504390851L;

	// 产品类型
	private String mStockType;

	// 产品发行商
	private String fundCompany;

	// 产品代码
	private String fundCode;

	// 产品名称
	private String codesimpleName;

	// 期初份额
	private BigDecimal currentShare;

	// 已提/已转让份额=takegoodsAmountTot+transAmountTot
	private BigDecimal backShare;

	// 冻结份额
	private BigDecimal frozenShare;

	// 可提份额
	private BigDecimal enableShare;

	// 收益
	private BigDecimal incomeBalance;

	// 本金
	private BigDecimal currentBalance;

	// 产品收益率
	private BigDecimal incomeRatio;

	// 期初价格
	private BigDecimal openPrice;

	// 到期价格，即回购价格
	private BigDecimal backPrice;

	// 产品计息周期
	private BigInteger productTerm;

	
	// 提酒奖励金额
	private BigDecimal rewardBalance;
	
	//产品到期日
	private int closeDay;
	
	//产品到期日毫秒
    private Long closeDayMillisecond;
    
    
    //7 网上；8 手机；p 线下pos
    private String opEntrustWay;


    // 滚存标志 1关闭，2开启
    private String deferStatus;

    //转让标志(提前赎回), 0 关闭 1 开启
    private String transFlag;

    //转让买入标志(暂不使用), 0 关闭 1 开启
    private String transbuyFlag;


    // 已提酒数量
    private BigDecimal takegoodsAmountTot;

    // 已转让份数
    private BigDecimal transAmountTot;

    //滚存份额
    private BigDecimal deferShare;

    //是否属于本平台产品
    private Integer oneself;

    //平台url（空就是本平台的，否则其它地方平台的url）
    private String platUrl;

    //滚期结束停止设置的天数
    private Integer deferClosedate;

    //agencyNo//线下持仓渠道号
    private String agencyNo;

	private String isOffline;//是否是线下

	private String redeemStartDate;//赎回起始日(针对2+1产品)

	private String redeemEndDate;//赎回截止日(针对2+1产品)

	private String redeemArrivalDate;//赎回到账日(针对2+1产品)

	/**
	 * @return the deferShare
	 */
	public BigDecimal getDeferShare() {
		return deferShare;
	}

	/**
	 * @param deferShare the deferShare to set
	 */
	public void setDeferShare(BigDecimal deferShare) {
		this.deferShare = deferShare;
	}

	public String getmStockType() {
		return mStockType;
	}

	public void setmStockType(String mStockType) {
		this.mStockType = mStockType;
	}

	public String getFundCompany() {
		return fundCompany;
	}

	public void setFundCompany(String fundCompany) {
		this.fundCompany = fundCompany;
	}

	public String getFundCode() {
		return fundCode;
	}

	public void setFundCode(String fundCode) {
		this.fundCode = fundCode;
	}

	public String getCodesimpleName() {
		return codesimpleName;
	}

	public void setCodesimpleName(String codesimpleName) {
		this.codesimpleName = codesimpleName;
	}

	public BigDecimal getCurrentShare() {
		return currentShare;
	}

	public void setCurrentShare(BigDecimal currentShare) {
		this.currentShare = currentShare;
	}

	public BigDecimal getBackShare() {
		return backShare;
	}

	public void setBackShare(BigDecimal backShare) {
		this.backShare = backShare;
	}

	public BigDecimal getFrozenShare() {
		return frozenShare;
	}

	public void setFrozenShare(BigDecimal frozenShare) {
		this.frozenShare = frozenShare;
	}

	public BigDecimal getEnableShare() {
		return enableShare;
	}

	public void setEnableShare(BigDecimal enableShare) {
		this.enableShare = enableShare;
	}

	public BigDecimal getIncomeBalance() {
		return incomeBalance;
	}

	public void setIncomeBalance(BigDecimal incomeBalance) {
		this.incomeBalance = incomeBalance;
	}

	public BigDecimal getCurrentBalance() {
		return currentBalance;
	}

	public void setCurrentBalance(BigDecimal currentBalance) {
		this.currentBalance = currentBalance;
	}

	public BigDecimal getIncomeRatio() {
		return incomeRatio;
	}

	public void setIncomeRatio(BigDecimal incomeRatio) {
		this.incomeRatio = incomeRatio;
	}

	public BigDecimal getOpenPrice() {
		return openPrice;
	}

	public void setOpenPrice(BigDecimal openPrice) {
		this.openPrice = openPrice;
	}

	public BigDecimal getBackPrice() {
		return backPrice;
	}

	public void setBackPrice(BigDecimal backPrice) {
		this.backPrice = backPrice;
	}

	public BigInteger getProductTerm() {
		return productTerm;
	}

	public void setProductTerm(BigInteger productTerm) {
		this.productTerm = productTerm;
	}

	public BigDecimal getRewardBalance() {
		return rewardBalance;
	}

	public void setRewardBalance(BigDecimal rewardBalance) {
		this.rewardBalance = rewardBalance;
	}

	public int getCloseDay() {
		return closeDay;
	}

	public void setCloseDay(int closeDay) {
		this.closeDay = closeDay;
	}

	public Long getCloseDayMillisecond() {
		return closeDayMillisecond;
	}

	public void setCloseDayMillisecond(Long closeDayMillisecond) {
		this.closeDayMillisecond = closeDayMillisecond;
	}

	public String getOpEntrustWay() {
		return opEntrustWay;
	}

	public void setOpEntrustWay(String opEntrustWay) {
		this.opEntrustWay = opEntrustWay;
	}

	public String getDeferStatus() {
		return deferStatus;
	}

	public void setDeferStatus(String deferStatus) {
		this.deferStatus = deferStatus;
	}

	public String getTransFlag() {
		return transFlag;
	}

	public void setTransFlag(String transFlag) {
		this.transFlag = transFlag;
	}

	public String getTransbuyFlag() {
		return transbuyFlag;
	}

	public void setTransbuyFlag(String transbuyFlag) {
		this.transbuyFlag = transbuyFlag;
	}

	public BigDecimal getTakegoodsAmountTot() {
		return takegoodsAmountTot;
	}

	public void setTakegoodsAmountTot(BigDecimal takegoodsAmountTot) {
		this.takegoodsAmountTot = takegoodsAmountTot;
	}

	public BigDecimal getTransAmountTot() {
		return transAmountTot;
	}

	public void setTransAmountTot(BigDecimal transAmountTot) {
		this.transAmountTot = transAmountTot;
	}

	public Integer getOneself() {
		return oneself;
	}

	public void setOneself(Integer oneself) {
		this.oneself = oneself;
	}

	public String getPlatUrl() {
		return platUrl;
	}

	public void setPlatUrl(String platUrl) {
		this.platUrl = platUrl;
	}

	public Integer getDeferClosedate() {
		return deferClosedate;
	}

	public void setDeferClosedate(Integer deferClosedate) {
		this.deferClosedate = deferClosedate;
	}

	public String getAgencyNo() {
		return agencyNo;
	}

	public void setAgencyNo(String agencyNo) {
		this.agencyNo = agencyNo;
	}

	public String getIsOffline() {
		return isOffline;
	}

	public void setIsOffline(String isOffline) {
		this.isOffline = isOffline;
	}

	public String getRedeemStartDate() {
		return redeemStartDate;
	}

	public void setRedeemStartDate(String redeemStartDate) {
		this.redeemStartDate = redeemStartDate;
	}

	public String getRedeemEndDate() {
		return redeemEndDate;
	}

	public void setRedeemEndDate(String redeemEndDate) {
		this.redeemEndDate = redeemEndDate;
	}

	public String getRedeemArrivalDate() {
		return redeemArrivalDate;
	}

	public void setRedeemArrivalDate(String redeemArrivalDate) {
		this.redeemArrivalDate = redeemArrivalDate;
	}

	
	
	

}
