package com.ptteng.wealth.consign.model.out;

import java.io.Serializable;
import java.math.BigInteger;
/**
 * 酒交所产品提货申请信息-- 9951
 */
public class SpiritDelivery implements Serializable {

    /**
     * 处理中
     */
    public static final String Status_Processing = "0";
    /**
     * 已确认
     */
    public static final String Status_Confirm = "1";

    /**
     * 已撤销
     */
    public static final String Status_Cancel = "2";

    /**
     * 发票类型：0-普票
     */
    public static final String InvoiceType_Normal = "0";

    /**
     * 发票类型：1-专票
     */
    public static final String InvoiceType_Designed = "1";

    /**
     * 发生日期
     */
    private int currDate;

    /**
     * 发生时间
     */
    private int currTime;

    /**
     * 外部合同号
     */
    private String outSerialNo;

    /**
     * 提货方式
     */
    private String deliveryWay;

    /**
     * 产品代码
     */
    private String fundCode;

    /**
     * 提货数量
     */
    private BigInteger amount;

    /**
     * 收货人
     */
    private String clientName;

    /**
     * 邮编
     */
    private String zipcode;

    /**
     * 地址
     */
    private String address;

    /**
     * 电话
     */
    private String phonecode;

    /**
     * 手机
     */
    private String mobiletelephone;

    /**
     * 0 处理中 1 已确认 2 已撤消
     */
    private String status;

    /**
     * 发票类型：0-普票,1-专票
     */
    private java.lang.String invoiceType;

    /**
     * 发票抬头
     */
    private java.lang.String invoiceTitle;

    /**
     * 单位名称
     */
    private java.lang.String companyName;

    /**
     * 纳税人识别号
     */
    private java.lang.String taxpayerNo;

    /**
     * 注册地址
     */
    private java.lang.String registeredAddress;

    /**
     * 注册电话
     */
    private java.lang.String registeredPhone;

    /**
     * 开户银行
     */
    private java.lang.String bankNoInvoice;

    /**
     * 开户账号
     */
    private java.lang.String bankAccountInvoice;

    /**
     * 收票人
     */
    private java.lang.String clientNameRec;

    /**
     * 收票人邮编
     */
    private java.lang.String zipcodeRec;

    @Override
    public String toString() {
        return "SpiritDelivery{" +
                "address='" + address + '\'' +
                ", currDate=" + currDate +
                ", currTime=" + currTime +
                ", outSerialNo='" + outSerialNo + '\'' +
                ", deliveryWay='" + deliveryWay + '\'' +
                ", fundCode='" + fundCode + '\'' +
                ", amount=" + amount +
                ", clientName='" + clientName + '\'' +
                ", zipcode='" + zipcode + '\'' +
                ", phonecode='" + phonecode + '\'' +
                ", mobiletelephone='" + mobiletelephone + '\'' +
                ", status='" + status + '\'' +
                ", invoiceType='" + invoiceType + '\'' +
                ", invoiceTitle='" + invoiceTitle + '\'' +
                ", companyName='" + companyName + '\'' +
                ", taxpayerNo='" + taxpayerNo + '\'' +
                ", registeredAddress='" + registeredAddress + '\'' +
                ", registeredPhone='" + registeredPhone + '\'' +
                ", bankNoInvoice='" + bankNoInvoice + '\'' +
                ", bankAccountInvoice='" + bankAccountInvoice + '\'' +
                ", clientNameRec='" + clientNameRec + '\'' +
                ", zipcodeRec='" + zipcodeRec + '\'' +
                ", addressRec='" + addressRec + '\'' +
                ", mobiletelephoneRec='" + mobiletelephoneRec + '\'' +
                ", remark='" + remark + '\'' +
                '}';
    }

    /**
     * 收票人地址
     */
    private java.lang.String addressRec;

    /**
     * 收票人手机号
     */
    private java.lang.String mobiletelephoneRec;

    /**
     * 备注
     */
    private java.lang.String remark;

    public int getCurrDate() {
        return currDate;
    }

    public void setCurrDate(int currDate) {
        this.currDate = currDate;
    }

    public int getCurrTime() {
        return currTime;
    }

    public void setCurrTime(int currTime) {
        this.currTime = currTime;
    }

    public String getOutSerialNo() {
        return outSerialNo;
    }

    public void setOutSerialNo(String outSerialNo) {
        this.outSerialNo = outSerialNo;
    }

    public String getDeliveryWay() {
        return deliveryWay;
    }

    public void setDeliveryWay(String deliveryWay) {
        this.deliveryWay = deliveryWay;
    }

    public String getFundCode() {
        return fundCode;
    }

    public void setFundCode(String fundCode) {
        this.fundCode = fundCode;
    }

    public BigInteger getAmount() {
        return amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public String getClientName() {
        return clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getZipcode() {
        return zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhonecode() {
        return phonecode;
    }

    public void setPhonecode(String phonecode) {
        this.phonecode = phonecode;
    }

    public String getMobiletelephone() {
        return mobiletelephone;
    }

    public void setMobiletelephone(String mobiletelephone) {
        this.mobiletelephone = mobiletelephone;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static String getStatusProcessing() {
        return Status_Processing;
    }

    public static String getStatusConfirm() {
        return Status_Confirm;
    }

    public static String getStatusCancel() {
        return Status_Cancel;
    }

    public java.lang.String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(java.lang.String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public java.lang.String getInvoiceTitle() {
        return invoiceTitle;
    }

    public void setInvoiceTitle(java.lang.String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    public java.lang.String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(java.lang.String companyName) {
        this.companyName = companyName;
    }

    public java.lang.String getTaxpayerNo() {
        return taxpayerNo;
    }

    public void setTaxpayerNo(java.lang.String taxpayerNo) {
        this.taxpayerNo = taxpayerNo;
    }

    public java.lang.String getRegisteredAddress() {
        return registeredAddress;
    }

    public void setRegisteredAddress(java.lang.String registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public java.lang.String getRegisteredPhone() {
        return registeredPhone;
    }

    public void setRegisteredPhone(java.lang.String registeredPhone) {
        this.registeredPhone = registeredPhone;
    }

    public java.lang.String getBankNoInvoice() {
        return bankNoInvoice;
    }

    public void setBankNoInvoice(java.lang.String bankNoInvoice) {
        this.bankNoInvoice = bankNoInvoice;
    }

    public java.lang.String getBankAccountInvoice() {
        return bankAccountInvoice;
    }

    public void setBankAccountInvoice(java.lang.String bankAccountInvoice) {
        this.bankAccountInvoice = bankAccountInvoice;
    }

    public java.lang.String getClientNameRec() {
        return clientNameRec;
    }

    public void setClientNameRec(java.lang.String clientNameRec) {
        this.clientNameRec = clientNameRec;
    }

    public java.lang.String getZipcodeRec() {
        return zipcodeRec;
    }

    public void setZipcodeRec(java.lang.String zipcodeRec) {
        this.zipcodeRec = zipcodeRec;
    }

    public java.lang.String getAddressRec() {
        return addressRec;
    }

    public void setAddressRec(java.lang.String addressRec) {
        this.addressRec = addressRec;
    }

    public java.lang.String getMobiletelephoneRec() {
        return mobiletelephoneRec;
    }

    public void setMobiletelephoneRec(java.lang.String mobiletelephoneRec) {
        this.mobiletelephoneRec = mobiletelephoneRec;
    }

    public java.lang.String getRemark() {
        return remark;
    }

    public void setRemark(java.lang.String remark) {
        this.remark = remark;
    }

    private static final long serialVersionUID = 8535706877120768541L;

}
