package com.ptteng.wealth.consign.model.out;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 证联融通-余额流水查询输出 9905
 * 
 * @author yezhiwei
 * 2012-12-28
 */
public class CapitalFlowOut implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6258121782505756091L;

	/**
	 * 商户的系统日期，YYYYMMDD
	 */
	private int fundDate;

	/**
	 * 商户的时间戳，HHMMSS
	 */
	private int fundTime;

	/**
	 * 商户系统流水号。需要保证一个交易日中流水号的唯一性
	 */
	private String fundSeqId;

	/**
	 * 当前页数
	 */
	private int currentPage;

	/**
	 * 当前页显示条数
	 */
	private int pageSize;

	/**
	 * 总页数
	 */
	private int totalPage;

	/**
	 * 应答码，参考附录
	 */
	private String respCode;

	/**
	 * 业务应答描述
	 */
	private String respDesc;

	/**
	 * 保留域，接收方必须原样回送该字段数据
	 */
	private String resv;

	/**
	 * 证联融通的流水号
	 */
	private String pnrSeqId;

	/**
	 * 交易日期
	 */
	private String orderDate;
	
	private Long orderDateLong;

	/**
	 * @return the orderDateLong
	 */
	public Long getOrderDateLong() {
		return orderDateLong;
	}

	/**
	 * @param orderDateLong the orderDateLong to set
	 */
	public void setOrderDateLong(Long orderDateLong) {
		this.orderDateLong = orderDateLong;
	}

	/**
	 * 业务类型
	 */
	private String busiTypeDesc;

	/**
	 * 交易产品类型
	 */
	private String fundType;

	/**
	 * 交易产品代码
	 */
	private String fundCode;

	/**
	 * 收入金额
	 */
	private BigDecimal incomeAmt;

	/**
	 * 支出金额
	 */
	private BigDecimal payAmt;

	/**
	 * 账户余额
	 */
	private BigDecimal balance;

	/**
	 * 支付方式
	 */
	private String payTypeDesc;
	
	/**
	 * 银行类别
	 */
	private String bankType;
	
	/**
	 * 银行卡号
	 */
	private String bankCardNo;
	
	/**
	 * 返回状态  00：处理中  01：支付成功 02：支付失败
	 */
	private String status;
	
	/**
	 * @return the status
	 */
	public String getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	public int getFundDate() {
		return fundDate;
	}

	public void setFundDate(int fundDate) {
		this.fundDate = fundDate;
	}

	public int getFundTime() {
		return fundTime;
	}

	public void setFundTime(int fundTime) {
		this.fundTime = fundTime;
	}

	public String getFundSeqId() {
		return fundSeqId;
	}

	public void setFundSeqId(String fundSeqId) {
		this.fundSeqId = fundSeqId;
	}

	public int getCurrentPage() {
		return currentPage;
	}

	public void setCurrentPage(int currentPage) {
		this.currentPage = currentPage;
	}

	public int getPageSize() {
		return pageSize;
	}

	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}

	public int getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(int totalPage) {
		this.totalPage = totalPage;
	}

	public String getRespCode() {
		return respCode;
	}

	public void setRespCode(String respCode) {
		this.respCode = respCode;
	}

	public String getRespDesc() {
		return respDesc;
	}

	public void setRespDesc(String respDesc) {
		this.respDesc = respDesc;
	}

	public String getResv() {
		return resv;
	}

	public void setResv(String resv) {
		this.resv = resv;
	}

	public String getPnrSeqId() {
		return pnrSeqId;
	}

	public void setPnrSeqId(String pnrSeqId) {
		this.pnrSeqId = pnrSeqId;
	}

	public String getOrderDate() {
		return orderDate;
	}

	public void setOrderDate(String orderDate) {
		this.orderDate = orderDate;
	}

	public String getBusiTypeDesc() {
		return busiTypeDesc;
	}

	public void setBusiTypeDesc(String busiTypeDesc) {
		this.busiTypeDesc = busiTypeDesc;
	}

	public String getFundType() {
		return fundType;
	}

	public void setFundType(String fundType) {
		this.fundType = fundType;
	}

	public String getFundCode() {
		return fundCode;
	}

	public void setFundCode(String fundCode) {
		this.fundCode = fundCode;
	}

	public BigDecimal getIncomeAmt() {
		return incomeAmt;
	}

	public void setIncomeAmt(BigDecimal incomeAmt) {
		this.incomeAmt = incomeAmt;
	}

	public BigDecimal getPayAmt() {
		return payAmt;
	}

	public void setPayAmt(BigDecimal payAmt) {
		this.payAmt = payAmt;
	}

	public BigDecimal getBalance() {
		return balance;
	}

	public void setBalance(BigDecimal balance) {
		this.balance = balance;
	}

	public String getPayTypeDesc() {
		return payTypeDesc;
	}

	public void setPayTypeDesc(String payTypeDesc) {
		this.payTypeDesc = payTypeDesc;
	}
	
	public String getBankType() {
		return bankType;
	}

	public void setBankType(String bankType) {
		this.bankType = bankType;
	}

	public String getBankCardNo() {
		return bankCardNo;
	}

	public void setBankCardNo(String bankCardNo) {
		this.bankCardNo = bankCardNo;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
	}

}
